/*
 * Decompiled with CFR 0.152.
 */
package com.ackbox.totp.google;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/ackbox/totp/google/GoogleAuthenticatorConfig;", "", "timeStepSize", "Ljava/time/Duration;", "windowSize", "", "codeDigits", "keyModulus", "", "(Ljava/time/Duration;IIJ)V", "getCodeDigits", "()I", "getKeyModulus", "()J", "getTimeStepSize", "()Ljava/time/Duration;", "getWindowSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ackbox-totp"})
public final class GoogleAuthenticatorConfig {
    @NotNull
    private final Duration timeStepSize;
    private final int windowSize;
    private final int codeDigits;
    private final long keyModulus;

    @NotNull
    public final Duration getTimeStepSize() {
        return this.timeStepSize;
    }

    public final int getWindowSize() {
        return this.windowSize;
    }

    public final int getCodeDigits() {
        return this.codeDigits;
    }

    public final long getKeyModulus() {
        return this.keyModulus;
    }

    public GoogleAuthenticatorConfig(@NotNull Duration timeStepSize, int windowSize, int codeDigits, long keyModulus) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)timeStepSize, (String)"timeStepSize");
        this.timeStepSize = timeStepSize;
        this.windowSize = windowSize;
        this.codeDigits = codeDigits;
        this.keyModulus = keyModulus;
        boolean bl2 = bl = this.windowSize > 0;
        if (!bl) {
            String string = "Window number must be positive.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = this.codeDigits >= 6;
        if (!bl) {
            String string = "The minimum number of digits is 6.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = this.codeDigits <= 8;
        if (!bl) {
            String string = "The maximum number of digits is 8.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl5 = bl = !this.timeStepSize.isNegative() && !this.timeStepSize.isZero();
        if (!bl) {
            String string = "Time step size must be positive.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ GoogleAuthenticatorConfig(Duration duration, int n, int n2, long l, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(30)");
            duration = duration2;
        }
        if ((n3 & 2) != 0) {
            n = 3;
        }
        if ((n3 & 4) != 0) {
            n2 = 6;
        }
        if ((n3 & 8) != 0) {
            l = (long)Math.pow(10.0, n2);
        }
        this(duration, n, n2, l);
    }

    public GoogleAuthenticatorConfig() {
        this(null, 0, 0, 0L, 15, null);
    }

    @NotNull
    public final Duration component1() {
        return this.timeStepSize;
    }

    public final int component2() {
        return this.windowSize;
    }

    public final int component3() {
        return this.codeDigits;
    }

    public final long component4() {
        return this.keyModulus;
    }

    @NotNull
    public final GoogleAuthenticatorConfig copy(@NotNull Duration timeStepSize, int windowSize, int codeDigits, long keyModulus) {
        Intrinsics.checkParameterIsNotNull((Object)timeStepSize, (String)"timeStepSize");
        return new GoogleAuthenticatorConfig(timeStepSize, windowSize, codeDigits, keyModulus);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ GoogleAuthenticatorConfig copy$default(GoogleAuthenticatorConfig googleAuthenticatorConfig, Duration duration, int n, int n2, long l, int n3, Object object) {
        if ((n3 & 1) != 0) {
            duration = googleAuthenticatorConfig.timeStepSize;
        }
        if ((n3 & 2) != 0) {
            n = googleAuthenticatorConfig.windowSize;
        }
        if ((n3 & 4) != 0) {
            n2 = googleAuthenticatorConfig.codeDigits;
        }
        if ((n3 & 8) != 0) {
            l = googleAuthenticatorConfig.keyModulus;
        }
        return googleAuthenticatorConfig.copy(duration, n, n2, l);
    }

    @NotNull
    public String toString() {
        return "GoogleAuthenticatorConfig(timeStepSize=" + this.timeStepSize + ", windowSize=" + this.windowSize + ", codeDigits=" + this.codeDigits + ", keyModulus=" + this.keyModulus + ")";
    }

    public int hashCode() {
        Duration duration = this.timeStepSize;
        return (((duration != null ? ((Object)duration).hashCode() : 0) * 31 + Integer.hashCode(this.windowSize)) * 31 + Integer.hashCode(this.codeDigits)) * 31 + Long.hashCode(this.keyModulus);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GoogleAuthenticatorConfig)) break block3;
                GoogleAuthenticatorConfig googleAuthenticatorConfig = (GoogleAuthenticatorConfig)object;
                if (!Intrinsics.areEqual((Object)this.timeStepSize, (Object)googleAuthenticatorConfig.timeStepSize) || !(this.windowSize == googleAuthenticatorConfig.windowSize) || !(this.codeDigits == googleAuthenticatorConfig.codeDigits) || !(this.keyModulus == googleAuthenticatorConfig.keyModulus)) break block3;
            }
            return true;
        }
        return false;
    }
}

