/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util.validation;

import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.HubServiceCheckResult;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.ClientCertificateRequiredException;
import com.jetbrains.bundle.hub_client.util.validation.HubHomeUrlInfo;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlRedirectionException;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidationException;
import com.jetbrains.bundle.hub_client.util.validation.IServiceClientFactory;
import com.jetbrains.bundle.hub_client.util.validation.RedirectInfo;
import com.jetbrains.bundle.hub_client.util.validation.UntrustedCertificateInfo;
import com.jetbrains.bundle.hub_client.util.validation.UntrustedServerCertificateException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.ssl.CertRequestInfo;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubUrlValidator {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String HUB_ADDITIONAL_PATH = "hub/";
    public static final String URL_FOR_UNTRUSTED_CERTIFICATE_PROPERTY = "urlForUntrustedCertificate";
    public static final String IS_FIRST_CHAIN_CERTIFICATE_TRUSTED_PROPERTY = "isFirstChainCertificateTrusted";
    public static final String UNTRUSTED_CERTIFICATE_PROPERTY = "untrustedCertificate";
    public static final String REDIRECTION_INFO_PROPERTY = "redirectInfo";
    public static final String CLIENT_CERTIFICATE_REQUESTED_PROPERTY = "clientCertificateRequested";
    public static final String[] HUB_URL_RELATED_ADDITIONAL_PROPERTIES = new String[]{"urlForUntrustedCertificate", "untrustedCertificate", "redirectInfo", "clientCertificateRequested"};
    public static final int CONNECT_TIMEOUT = 15000;
    public static final int READ_TIMEOUT = 15000;
    public static final String LOCATION_HEADER = "Location";
    final HubClientProvider myHubClientProvider;
    final boolean myAllowHttpsOnlyFlag;
    @NotNull
    private final String myProductName;

    public HubUrlValidator(@NotNull HubClientProvider hubClientProvider, @NotNull String productName) {
        this(hubClientProvider, true, productName);
    }

    public HubUrlValidator(@NotNull HubClientProvider hubClientProvider, boolean allowHttpsOnly, @NotNull String productName) {
        this.myHubClientProvider = hubClientProvider;
        this.myAllowHttpsOnlyFlag = allowHttpsOnly;
        this.myProductName = productName;
    }

    private void validate(@NotNull String hubUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        try {
            try {
                this.myHubClientProvider.validateAndRememberHubClient(hubUrl, true);
            }
            catch (ClientCertificateRequiredException e) {
                validationResult.addError(ValidationResult.Error.CLIENT_CERTIFICATE_REQUIRED, propertyName, e.getMessage());
                CertRequestInfo certificateRequestInfo = e.getCertificateRequestInfo();
                if (certificateRequestInfo != null) {
                    validationResult.addInfo(CLIENT_CERTIFICATE_REQUESTED_PROPERTY, certificateRequestInfo);
                }
            }
            catch (UntrustedServerCertificateException e) {
                this.processUntrustedCertificateException(e, hubUrl, validationResult, propertyName);
            }
            catch (HubUrlRedirectionException e) {
                String redirectLocation;
                validationResult.addError(ValidationResult.Error.INVALID_HUB_URL_REDIRECT, propertyName, e.getMessage());
                if (e.getLocation() != null && (redirectLocation = this.getRedirectTargetLocation(hubUrl)) != null && !hubUrl.equals(redirectLocation)) {
                    validationResult.addInfo(REDIRECTION_INFO_PROPERTY, new RedirectInfo(hubUrl, redirectLocation));
                }
            }
            catch (HubUrlValidationException e) {
                validationResult.addError(ValidationResult.Error.INVALID_HUB_URL, propertyName, e.getStatus().getMessage() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            validationResult.addError(ValidationResult.Error.INVALID_HUB_URL, propertyName, "Hub URL is not valid. Please, see logs for details.");
        }
    }

    private void processUntrustedCertificateException(UntrustedServerCertificateException e, @NotNull String hubUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName) throws CertificateEncodingException, NoSuchAlgorithmException {
        validationResult.addError(ValidationResult.Error.UNTRUSTED_CERTIFICATE, propertyName, e.getMessage());
        X509Certificate[] certificateChain = e.getCertificateChain();
        validationResult.addInfo(UNTRUSTED_CERTIFICATE_PROPERTY, new UntrustedCertificateInfo(certificateChain));
        validationResult.addInfo(URL_FOR_UNTRUSTED_CERTIFICATE_PROPERTY, hubUrl);
        validationResult.addInfo(IS_FIRST_CHAIN_CERTIFICATE_TRUSTED_PROPERTY, e.isFirstChainCertificateTrusted());
    }

    private boolean validateUrlScheme(@NotNull String hubUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        if (this.myAllowHttpsOnlyFlag && !UrlUtil.isSecuredUrl((String)hubUrl) && !UrlUtil.isSecuredUrl((String)hubUrl)) {
            validationResult.addError(ValidationResult.Error.INVALID_HUB_URL_HTTPS_REQUIRED, propertyName, "Secure connection is required. Check that your connection to Hub over SSL or TLS is enabled and enter a URL that begins with HTTPS");
            return false;
        }
        return true;
    }

    public HubHomeUrlInfo getHubHomeUrlInfo(@NotNull HubClient hubClient, @NotNull String serviceId, @NotNull IServiceClientFactory serviceClientFactory, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        String hubServiceId = HubUtil.getHubServiceId(hubClient);
        String hubHomeUrl = HubUtil.getHubHomeUrl(serviceClientFactory.createServiceClient(hubClient), hubServiceId);
        boolean homeUrlIsAvailable = false;
        if (hubHomeUrl != null) {
            if (hubHomeUrl.equals(hubClient.getBaseUrl())) {
                homeUrlIsAvailable = true;
            } else {
                homeUrlIsAvailable = this.validateHomeUrl(hubHomeUrl, validationResult, propertyName);
                if (homeUrlIsAvailable) {
                    try {
                        ServiceClient serviceClient = serviceClientFactory.createServiceClient(this.myHubClientProvider.getHubClient(hubHomeUrl));
                        ServiceJSON service = serviceClient.getService(serviceId, null);
                        homeUrlIsAvailable = service != null;
                    }
                    catch (Exception e) {
                        validationResult.addInfo(propertyName, "Wrong configuration of Hub home URL");
                    }
                }
            }
        }
        return new HubHomeUrlInfo(hubHomeUrl, homeUrlIsAvailable);
    }

    private boolean validateHomeUrl(@NotNull String hubHomeUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        try {
            try {
                this.myHubClientProvider.validateAndRememberHubClient(hubHomeUrl, true);
                return true;
            }
            catch (ClientCertificateRequiredException e) {
                validationResult.addInfo(propertyName, e.getMessage());
                CertRequestInfo certificateRequestInfo = e.getCertificateRequestInfo();
                if (certificateRequestInfo != null) {
                    validationResult.addInfo(CLIENT_CERTIFICATE_REQUESTED_PROPERTY, certificateRequestInfo);
                }
            }
            catch (UntrustedServerCertificateException e) {
                this.processUntrustedCertificateException(e, hubHomeUrl, validationResult, propertyName);
            }
            catch (HubUrlValidationException e) {
                validationResult.addInfo(propertyName, e.getStatus().getMessage() + ": " + e.getMessage());
            }
        }
        catch (Exception e) {
            validationResult.addInfo(propertyName, "Hub URL is not valid. Please, see logs for details.");
        }
        return false;
    }

    public String validate(@NotNull String hubUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName, boolean checkAdditionalUrls) {
        String resultUrl = hubUrl;
        this.validate(hubUrl, validationResult, propertyName);
        if (checkAdditionalUrls && validationResult.hasErrorForField(propertyName)) {
            resultUrl = this.tryAdditionalHubPath(hubUrl, validationResult, propertyName);
        }
        this.validateUrlScheme(resultUrl, validationResult, propertyName);
        return resultUrl;
    }

    public void validateLicense(@NotNull HubClient hubClient, @NotNull ServiceClient serviceClient, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        ServiceJSON serviceData = serviceClient.getService(HubUtil.getHubServiceId(hubClient), new FieldPartial((BaseField[])new Partial.Service[]{Partial.Service.LICENSE_SETTINGS((Partial.License[])new Partial.License[]{Partial.License.LICENSE_KEY, Partial.License.LICENSE_NAME})}));
        if (serviceData == null || serviceData.getLicenseSettings() == null || serviceData.getLicenseSettings().getLicenseKey() == null || serviceData.getLicenseSettings().getLicenseKey().isEmpty()) {
            validationResult.addError(ValidationResult.Error.HUB_SERVICE_HAS_NO_LICENSE, propertyName, "The Hub service at this address does not have its own license and is most likely the built-in Hub service for an existing product. Please enter the URL of your external Hub service. ");
        }
    }

    public void checkServicesAreRegisteredInHub(@NotNull String hubUrl, @NotNull Map<String, String> servicesInHubWithSecrets, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        HashSet<String> validServices = new HashSet<String>();
        HashSet<String> notExistingServices = new HashSet<String>();
        HashSet<String> servicesWithNotMatchingSecrets = new HashSet<String>();
        HashSet<String> notVerifiedServices = new HashSet<String>();
        HashSet<String> invalidServices = new HashSet<String>();
        HashSet<String> uncheckedServices = new HashSet<String>();
        block5: for (String serviceId : servicesInHubWithSecrets.keySet()) {
            BaseAccountsClient accountsClient = this.myHubClientProvider.getHubClient(hubUrl).getAccountsClient(serviceId, servicesInHubWithSecrets.get(serviceId), new String[0]);
            HubServiceCheckResult checkResult = HubUtil.checkService(accountsClient);
            Boolean canBeUsed = checkResult.canBeUsed();
            if (canBeUsed == null) {
                uncheckedServices.add(serviceId);
                continue;
            }
            if (canBeUsed.booleanValue()) {
                validServices.add(serviceId);
                continue;
            }
            switch (checkResult.getStatus()) {
                case EXISTS_WRONG_SECRET: {
                    servicesWithNotMatchingSecrets.add(serviceId);
                    continue block5;
                }
                case EXISTS_NOT_VERIFIED: {
                    notVerifiedServices.add(serviceId);
                    continue block5;
                }
                case NOT_EXISTS: {
                    notExistingServices.add(serviceId);
                    continue block5;
                }
            }
            invalidServices.add(serviceId);
        }
        if (validServices.size() != servicesInHubWithSecrets.size()) {
            StringBuilder sb = new StringBuilder();
            if (!notExistingServices.isEmpty()) {
                sb.append("not exist: ").append(notExistingServices);
            }
            if (!servicesWithNotMatchingSecrets.isEmpty()) {
                sb.append(sb.length() != 0 ? ", " : "").append("not matching secret: ").append(servicesWithNotMatchingSecrets);
            }
            if (!notVerifiedServices.isEmpty()) {
                sb.append(sb.length() != 0 ? ", " : "").append("not trusted: ").append(notVerifiedServices);
            }
            if (!invalidServices.isEmpty()) {
                sb.append(sb.length() != 0 ? ", " : "").append("invalid: ").append(invalidServices);
            }
            if (!uncheckedServices.isEmpty()) {
                sb.append(sb.length() != 0 ? ", " : "").append("failed to check: ").append(uncheckedServices);
            }
            validationResult.addError(ValidationResult.Error.SERVICES_ARE_NOT_REGISTERERD, propertyName, String.format("One or more services that are registered in %s are not valid in the target Hub installation. The following problems were detected: %s. The target Hub installation must contain all data from the external Hub that was previously integrated with %s. If you entered the URL of an empty Hub installation, use a backup copy of your previous database to restore the Hub instance to its previous state and then continue. If you experience problems restoring your Hub database, please contact support.", this.myProductName, sb.toString(), this.myProductName));
        }
    }

    @NotNull
    private String tryAdditionalHubPath(@NotNull String hubUrl, @NotNull ValidationResult validationResult, @NotNull String propertyName) {
        Object oldRedirectInfo = validationResult.getAdditionalInfo().get(REDIRECTION_INFO_PROPERTY);
        ArrayList<String> additionalUrls = new ArrayList<String>();
        if (oldRedirectInfo instanceof RedirectInfo) {
            additionalUrls.add(((RedirectInfo)validationResult.getAdditionalInfo().get(REDIRECTION_INFO_PROPERTY)).getRedirectUrl());
        }
        ArrayList<String> additionalUrlsWithSuffix = new ArrayList<String>();
        for (String additionalUrl : additionalUrls) {
            this.appendSuffixIfNeeded(additionalUrl, additionalUrlsWithSuffix);
        }
        this.appendSuffixIfNeeded(hubUrl, additionalUrlsWithSuffix);
        additionalUrls.addAll(additionalUrlsWithSuffix);
        String bestHubUrl = this.findBestAdditionalHubUrl(validationResult, propertyName, additionalUrls);
        if (bestHubUrl == null) {
            return hubUrl;
        }
        return bestHubUrl;
    }

    @Nullable
    private String findBestAdditionalHubUrl(@NotNull ValidationResult validationResult, @NotNull String propertyName, ArrayList<String> additionalUrls) {
        String bestHubUrl = null;
        ValidationResult bestHubUrlValidationResult = null;
        for (String additionalUrl : additionalUrls) {
            ValidationResult checkResult = new ValidationResult();
            this.validate(additionalUrl, checkResult, propertyName);
            if (!checkResult.hasErrorForField(propertyName)) {
                bestHubUrl = additionalUrl;
                bestHubUrlValidationResult = checkResult;
                break;
            }
            if (!checkResult.getAdditionalInfo().containsKey(UNTRUSTED_CERTIFICATE_PROPERTY) || bestHubUrlValidationResult != null) continue;
            bestHubUrl = additionalUrl;
            bestHubUrlValidationResult = checkResult;
        }
        if (bestHubUrlValidationResult != null) {
            this.clearErrorInfo(validationResult, propertyName);
            validationResult.updateFrom(bestHubUrlValidationResult);
        }
        return bestHubUrl;
    }

    private void clearErrorInfo(@NotNull ValidationResult validationResult, @NotNull String propertyName) {
        validationResult.removeErrorForField(propertyName);
        for (String property : HUB_URL_RELATED_ADDITIONAL_PROPERTIES) {
            validationResult.getAdditionalInfo().remove(property);
        }
    }

    private void appendSuffixIfNeeded(String url, ArrayList<String> additionalUrlsWithSuffix) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (!url.endsWith("/hub/")) {
            additionalUrlsWithSuffix.add(UrlUtil.combineUrls((String)url, (String)HUB_ADDITIONAL_PATH));
        }
    }

    @Nullable
    private String getRedirectTargetLocation(String hubUrl) {
        try {
            URL url = new URL(hubUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            switch (conn.getResponseCode()) {
                case 301: 
                case 302: {
                    String location = conn.getHeaderField(LOCATION_HEADER);
                    URL redirectUrl = new URL(url, location);
                    return redirectUrl.toString();
                }
            }
            return null;
        }
        catch (Exception e) {
            this.LOG.info("Exception during redirect check for url " + hubUrl + ": " + e.getMessage());
            return null;
        }
    }
}

