/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.ScopeUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nB;\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\rB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000fB5\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0010BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\"\u001a\u00020\u0005J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010&\u001a\u00020\fH\u0016J\b\u0010'\u001a\u00020\u0005H\u0016R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001b\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/intellij/hub/auth/oauth2/token/AccessTokenData;", "", "expiration", "Ljava/util/Date;", "client", "", "user", "idToken", "target", "", "(Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "timeToLiveSeconds", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "scope", "(Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "(ILjava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "ttlSeconds", "(Ljava/util/Date;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "bytes", "", "getBytes", "()[B", "getClient", "()Ljava/lang/String;", "getExpiration", "()Ljava/util/Date;", "getIdToken", "getScope", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getTtlSeconds", "()I", "getUser", "encode", "equals", "", "other", "hashCode", "toString", "Companion", "com.intellij.hub.auth"})
public final class AccessTokenData {
    @NotNull
    private final Date expiration;
    private final int ttlSeconds;
    @NotNull
    private final String client;
    @Nullable
    private final String user;
    @Nullable
    private final String idToken;
    @NotNull
    private final String[] scope;
    private static final String DELIMITER = ".";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] getBytes() {
        String string = this.encode();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public final String encode() {
        String string = this.user;
        StringBuilder stringBuilder = new StringBuilder().append(this.expiration.getTime()).append('.').append(this.client).append('.');
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        return stringBuilder.append(string3).append('.').append(ScopeUtil.INSTANCE.encodeScope(this.scope)).toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        AccessTokenData tokenData = (AccessTokenData)other;
        return Intrinsics.areEqual((Object)this.client, (Object)tokenData.client) && Arrays.equals(this.scope, tokenData.scope) && Intrinsics.areEqual((Object)this.expiration, (Object)tokenData.expiration);
    }

    public int hashCode() {
        int result = this.expiration.hashCode();
        result = 31 * result + this.client.hashCode();
        result = 31 * result + Arrays.hashCode(this.scope);
        return result;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{expiration=" + this.expiration + ", client=" + this.client + ", user=" + this.user + ", scope=" + ArraysKt.toList((Object[])this.scope) + '}';
    }

    @NotNull
    public final Date getExpiration() {
        return this.expiration;
    }

    public final int getTtlSeconds() {
        return this.ttlSeconds;
    }

    @NotNull
    public final String getClient() {
        return this.client;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getIdToken() {
        return this.idToken;
    }

    @NotNull
    public final String[] getScope() {
        return this.scope;
    }

    private AccessTokenData(Date expiration, int ttlSeconds, String client, String user, String idToken, String[] scope) {
        this.expiration = expiration;
        this.ttlSeconds = ttlSeconds;
        this.client = client;
        this.user = user;
        this.idToken = idToken;
        this.scope = scope;
    }

    public AccessTokenData(@NotNull Date expiration, @NotNull String client, @Nullable String user, @Nullable String idToken, @NotNull String[] target) {
        Intrinsics.checkParameterIsNotNull((Object)expiration, (String)"expiration");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this(expiration, AccessTokenData.Companion.toTTL(expiration), client, user, idToken, target);
    }

    public AccessTokenData(int timeToLiveSeconds, @NotNull String client, @Nullable String user, @Nullable String idToken, @NotNull String[] target) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this(AccessTokenData.Companion.fromTTL(timeToLiveSeconds), timeToLiveSeconds, client, user, idToken, target);
    }

    public AccessTokenData(@NotNull Date expiration, @NotNull String client, @Nullable String user, String ... scope) {
        Intrinsics.checkParameterIsNotNull((Object)expiration, (String)"expiration");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this(expiration, client, user, (String)null, scope);
    }

    public AccessTokenData(int timeToLiveSeconds, @NotNull String client, @Nullable String user, String ... target) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this(timeToLiveSeconds, client, user, (String)null, target);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/hub/auth/oauth2/token/AccessTokenData$Companion;", "", "()V", "DELIMITER", "", "decode", "Lcom/intellij/hub/auth/oauth2/token/AccessTokenData;", "data", "fromTTL", "Ljava/util/Date;", "", "toTTL", "com.intellij.hub.auth"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AccessTokenData decode(@NotNull String data) {
            AccessTokenData accessTokenData;
            void client;
            void user;
            long l;
            List list;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            List parts2 = StringsKt.split$default((CharSequence)data, (String[])new String[]{AccessTokenData.DELIMITER}, (boolean)false, (int)0, (int)6, null);
            if (parts2.size() != 4) {
                throw (Throwable)InvalidTokenException.Companion.malformedTokenData();
            }
            List list2 = list = parts2;
            String string = (String)list2.get(0);
            list2 = list;
            String string2 = (String)list2.get(1);
            list2 = list;
            String string3 = (String)list2.get(2);
            list2 = list;
            String scope = (String)list2.get(3);
            try {
                void expirationString;
                void var9_10 = expirationString;
                l = Long.parseLong((String)var9_10);
            }
            catch (NumberFormatException e) {
                throw (Throwable)InvalidTokenException.Companion.malformedTokenExpiration(e);
            }
            long expiration = l;
            void var9_12 = user;
            void var16_15 = client;
            Date date = new Date(expiration);
            AccessTokenData accessTokenData2 = accessTokenData;
            AccessTokenData accessTokenData3 = accessTokenData;
            void it = var9_12;
            CharSequence charSequence = (CharSequence)it;
            String string4 = charSequence.length() > 0 ? var9_12 : null;
            String[] stringArray = ScopeUtil.INSTANCE.decodeScope(scope);
            accessTokenData2(date, (String)var16_15, string4, Arrays.copyOf(stringArray, stringArray.length));
            return accessTokenData3;
        }

        private final int toTTL(@NotNull Date $receiver) {
            return (int)((System.currentTimeMillis() - $receiver.getTime()) / (long)1000);
        }

        private final Date fromTTL(int $receiver) {
            return new Date(System.currentTimeMillis() + (long)($receiver * 1000));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

