/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/hub/auth/oauth2/token/GuestToken;", "Lcom/intellij/hub/auth/AuthToken;", "()V", "HEADER", "", "VALUE", "type", "getType", "()Ljava/lang/String;", "decode", "data", "decodeHeader", "header", "encode", "encodeHeader", "isGuestTokenHeader", "", "toString", "com.intellij.hub.auth"})
public final class GuestToken
implements AuthToken {
    private static final String VALUE = "guest:anonymous";
    private static final String HEADER = "Bearer guest:anonymous";
    public static final GuestToken INSTANCE;

    @Override
    @NotNull
    public String getType() {
        return "Bearer";
    }

    @NotNull
    public String toString() {
        return "guest";
    }

    @Override
    @NotNull
    public String encode() {
        return VALUE;
    }

    @JvmStatic
    @NotNull
    public static final GuestToken decode(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (!StringsKt.equals((String)data, (String)VALUE, (boolean)true)) {
            throw (Throwable)InvalidTokenException.Companion.notGuestToken();
        }
        return INSTANCE;
    }

    @JvmStatic
    public static final boolean isGuestTokenHeader(@Nullable String header) {
        return StringsKt.equals((String)HEADER, (String)header, (boolean)true);
    }

    @JvmStatic
    @NotNull
    public static final String encodeHeader() {
        return HEADER;
    }

    @JvmStatic
    @NotNull
    public static final GuestToken decodeHeader(@NotNull String header) throws InvalidTokenException {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        if (!StringsKt.startsWith$default((String)header, (String)"Bearer ", (boolean)false, (int)2, null)) {
            throw (Throwable)InvalidTokenException.Companion.bearerAuthHeaderTypeExpected();
        }
        return GuestToken.decode(StringsKt.removePrefix((String)header, (CharSequence)"Bearer "));
    }

    private GuestToken() {
    }

    static {
        GuestToken guestToken;
        INSTANCE = guestToken = new GuestToken();
    }
}

