/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u0003H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/hub/auth/oauth2/token/PermanentToken;", "Lcom/intellij/hub/auth/AuthToken;", "username", "", "name", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSecret", "type", "getType", "getUsername", "encode", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "com.intellij.hub.auth"})
public final class PermanentToken
implements AuthToken {
    @NotNull
    private final String username;
    @NotNull
    private final String name;
    @NotNull
    private final String secret;
    private static final Regex tokenPattern;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getType() {
        return "Bearer";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PermanentToken)) {
            return false;
        }
        PermanentToken that = (PermanentToken)other;
        return Intrinsics.areEqual((Object)this.username, (Object)that.username) && Intrinsics.areEqual((Object)this.secret, (Object)that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.secret);
    }

    @NotNull
    public String toString() {
        return "perm{" + this.username + "}.{" + this.name + '}';
    }

    @Override
    @NotNull
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = this.username;
        Object object = Charsets.UTF_8;
        Base64.Encoder encoder2 = encoder;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String usernameBase64 = encoder2.encodeToString(byArray2);
        object = this.name;
        Charset charset = Charsets.UTF_8;
        encoder2 = encoder;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = ((String)object2).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        String nameBase64 = encoder2.encodeToString(byArray2);
        return "perm:" + usernameBase64 + '.' + nameBase64 + '.' + this.secret;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    public PermanentToken(@NotNull String username, @NotNull String name, @NotNull String secret) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        this.username = username;
        this.name = name;
        this.secret = secret;
    }

    static {
        Companion = new Companion(null);
        tokenPattern = new Regex("perm:([^.]+)\\.([^.]+)\\.(.+)");
    }

    @JvmStatic
    @NotNull
    public static final PermanentToken decode(@NotNull String data) {
        return Companion.decode(data);
    }

    @JvmStatic
    @NotNull
    public static final String encodeHeader(@NotNull PermanentToken token) {
        return Companion.encodeHeader(token);
    }

    @JvmStatic
    public static final boolean isPermanentTokenHeader(@Nullable String header) {
        return Companion.isPermanentTokenHeader(header);
    }

    @JvmStatic
    @NotNull
    public static final PermanentToken decodeHeader(@NotNull String header) throws InvalidTokenException {
        return Companion.decodeHeader(header);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/hub/auth/oauth2/token/PermanentToken$Companion;", "", "()V", "tokenPattern", "Lkotlin/text/Regex;", "decode", "Lcom/intellij/hub/auth/oauth2/token/PermanentToken;", "data", "", "decodeHeader", "header", "encodeHeader", "token", "isPermanentTokenHeader", "", "com.intellij.hub.auth"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final PermanentToken decode(@NotNull String data) {
            Object object;
            Object object2;
            MatchResult.Destructured destructured;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            MatchResult matchResult = tokenPattern.matchEntire((CharSequence)data);
            if (matchResult == null) {
                throw (Throwable)InvalidTokenException.Companion.malformedPermanentToken();
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured2 = destructured = matchResult2.getDestructured();
            String string = (String)destructured2.getMatch().getGroupValues().get(1);
            destructured2 = destructured;
            String string2 = (String)destructured2.getMatch().getGroupValues().get(2);
            destructured2 = destructured;
            String secret = (String)destructured2.getMatch().getGroupValues().get(3);
            Base64.Decoder decoder = Base64.getDecoder();
            try {
                void usernameBase64;
                byte[] byArray = decoder.decode((String)usernameBase64);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decoder.decode(usernameBase64)");
                object2 = byArray;
                object = Charsets.UTF_8;
                object2 = new String((byte[])object2, (Charset)object);
            }
            catch (Exception e) {
                throw (Throwable)InvalidTokenException.Companion.malformedPermanentTokenUsername(e);
            }
            Object username = object2;
            try {
                void nameBase64;
                byte[] byArray = decoder.decode((String)nameBase64);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decoder.decode(nameBase64)");
                object = byArray;
                Charset charset = Charsets.UTF_8;
                object = new String((byte[])object, charset);
            }
            catch (Exception e) {
                throw (Throwable)InvalidTokenException.Companion.malformedPermanentTokenName(e);
            }
            Object name = object;
            return new PermanentToken((String)username, (String)name, secret);
        }

        @JvmStatic
        @NotNull
        public final String encodeHeader(@NotNull PermanentToken token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            return "Bearer " + token.encode();
        }

        @JvmStatic
        public final boolean isPermanentTokenHeader(@Nullable String header) {
            return header != null && StringsKt.startsWith$default((String)header, (String)"Bearer ", (boolean)false, (int)2, null) && tokenPattern.matchEntire((CharSequence)StringsKt.removePrefix((String)header, (CharSequence)"Bearer ")) != null;
        }

        @JvmStatic
        @NotNull
        public final PermanentToken decodeHeader(@NotNull String header) throws InvalidTokenException {
            Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
            if (!this.isPermanentTokenHeader(header)) {
                throw (Throwable)InvalidTokenException.Companion.bearerAuthHeaderTypeExpected();
            }
            return this.decode(StringsKt.removePrefix((String)header, (CharSequence)"Bearer "));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

