/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.ScopeUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001b\u0010\u000e\u001a\u00020\u00042\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/hub/auth/oauth2/token/ScopeUtil;", "", "()V", "SCOPE_DELIMITER", "", "getSCOPE_DELIMITER", "()Ljava/lang/String;", "decode", "scopeItem", "decodeScope", "", "scope", "(Ljava/lang/String;)[Ljava/lang/String;", "encode", "encodeScope", "([Ljava/lang/String;)Ljava/lang/String;", "com.intellij.hub.auth"})
public final class ScopeUtil {
    @NotNull
    private static final String SCOPE_DELIMITER = " ";
    public static final ScopeUtil INSTANCE;

    @NotNull
    public final String getSCOPE_DELIMITER() {
        return SCOPE_DELIMITER;
    }

    @NotNull
    public final String encodeScope(@NotNull String[] scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        String[] stringArray = scope;
        if (stringArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("Scope can't be empty array");
        }
        return ArraysKt.joinToString$default((Object[])scope, (CharSequence)SCOPE_DELIMITER, null, null, (int)0, null, (Function1)encodeScope.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String[] decodeScope(@NotNull String scope) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        List parts2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)scope, (String[])new String[]{SCOPE_DELIMITER}, (boolean)false, (int)0, (int)6, null)), (Function1)decodeScope.parts.1.INSTANCE), (Function1)decodeScope.parts.2.INSTANCE));
        if (parts2.isEmpty()) {
            throw (Throwable)InvalidTokenException.Companion.malformedTokenScope();
        }
        Collection collection = $receiver$iv = (Collection)parts2;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @NotNull
    public final String encode(@NotNull String scopeItem) {
        Intrinsics.checkParameterIsNotNull((Object)scopeItem, (String)"scopeItem");
        String string = URLEncoder.encode(scopeItem, Charsets.UTF_8.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(scopeI\u2026m, Charsets.UTF_8.name())");
        return string;
    }

    @NotNull
    public final String decode(@NotNull String scopeItem) {
        Intrinsics.checkParameterIsNotNull((Object)scopeItem, (String)"scopeItem");
        String string = URLDecoder.decode(scopeItem, Charsets.UTF_8.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(scopeI\u2026m, Charsets.UTF_8.name())");
        return string;
    }

    private ScopeUtil() {
    }

    static {
        ScopeUtil scopeUtil;
        INSTANCE = scopeUtil = new ScopeUtil();
        SCOPE_DELIMITER = SCOPE_DELIMITER;
    }
}

