/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.openidConnect;

import com.intellij.hub.auth.openidConnect.SignatureCalculator;
import java.security.PrivateKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/hub/auth/openidConnect/AsymmetricKeySignatureCalculator;", "Lcom/intellij/hub/auth/openidConnect/SignatureCalculator;", "algorithm", "", "keyId", "javaAlgorithm", "key", "Ljava/security/PrivateKey;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/security/PrivateKey;)V", "getAlgorithm", "()Ljava/lang/String;", "getKeyId", "signature", "Ljava/security/Signature;", "calculateSignature", "", "data", "com.intellij.hub.auth"})
public final class AsymmetricKeySignatureCalculator
implements SignatureCalculator {
    private final Signature signature;
    @NotNull
    private final String algorithm;
    @NotNull
    private final String keyId;

    @Override
    @NotNull
    public byte[] calculateSignature(@NotNull byte[] data) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Signature $receiver = signature = this.signature;
        $receiver.update(data);
        byte[] byArray = $receiver.sign();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sign()");
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"signature.run {\n        \u2026ata)\n        sign()\n    }");
        return byArray;
    }

    @Override
    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @NotNull
    public String getKeyId() {
        return this.keyId;
    }

    public AsymmetricKeySignatureCalculator(@NotNull String algorithm, @NotNull String keyId, @NotNull String javaAlgorithm, @NotNull PrivateKey key) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)keyId, (String)"keyId");
        Intrinsics.checkParameterIsNotNull((Object)javaAlgorithm, (String)"javaAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.algorithm = algorithm;
        this.keyId = keyId;
        Signature signature2 = Signature.getInstance(javaAlgorithm);
        AsymmetricKeySignatureCalculator asymmetricKeySignatureCalculator = this;
        Signature $receiver = signature2;
        $receiver.initSign(key);
        Signature signature3 = signature = signature2;
        Intrinsics.checkExpressionValueIsNotNull((Object)signature3, (String)"Signature.getInstance(ja\u2026      initSign(key)\n    }");
        asymmetricKeySignatureCalculator.signature = signature3;
    }
}

