/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.openidConnect;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.intellij.hub.auth.openidConnect.DateSerializer;
import com.intellij.hub.auth.openidConnect.JoseHeader;
import com.intellij.hub.auth.openidConnect.OpenidConnectUtilKt;
import com.intellij.hub.auth.openidConnect.SignatureCalculator;
import com.intellij.hub.auth.openidConnect.UserInfo;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001Bm\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u0012\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\b\u0012\n\b\u0003\u0010\u000e\u001a\u0004\u0018\u00010\b\u0012\n\b\u0003\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/intellij/hub/auth/openidConnect/IdToken;", "", "userInfo", "Lcom/intellij/hub/auth/openidConnect/UserInfo;", "issuer", "Ljava/net/URI;", "audience", "", "", "expirationTime", "Ljava/util/Date;", "issuedAt", "authenticationTime", "nonce", "accessTokenHash", "codeHash", "(Lcom/intellij/hub/auth/openidConnect/UserInfo;Ljava/net/URI;[Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessTokenHash", "()Ljava/lang/String;", "getAudience", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getAuthenticationTime", "()Ljava/util/Date;", "getCodeHash", "getExpirationTime", "getIssuedAt", "getIssuer", "()Ljava/net/URI;", "getNonce", "getUserInfo", "()Lcom/intellij/hub/auth/openidConnect/UserInfo;", "signAndEncode", "signatureCalculator", "Lcom/intellij/hub/auth/openidConnect/SignatureCalculator;", "toJsonString", "com.intellij.hub.auth"})
public final class IdToken {
    @NotNull
    private final UserInfo userInfo;
    @NotNull
    private final URI issuer;
    @NotNull
    private final String[] audience;
    @NotNull
    private final Date expirationTime;
    @NotNull
    private final Date issuedAt;
    @Nullable
    private final Date authenticationTime;
    @Nullable
    private final String nonce;
    @Nullable
    private final String accessTokenHash;
    @Nullable
    private final String codeHash;

    @NotNull
    public final String toJsonString() {
        String string = OpenidConnectUtilKt.getMapper().writeValueAsString((Object)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapper.writeValueAsString(this)");
        return string;
    }

    @NotNull
    public final String signAndEncode(@NotNull SignatureCalculator signatureCalculator) {
        String headerAndPayload;
        Intrinsics.checkParameterIsNotNull((Object)signatureCalculator, (String)"signatureCalculator");
        String header = OpenidConnectUtilKt.toBase64URL(new JoseHeader(signatureCalculator.getAlgorithm(), signatureCalculator.getKeyId()).toJsonString());
        String payload = OpenidConnectUtilKt.toBase64URL(this.toJsonString());
        String string = headerAndPayload = header + '.' + payload;
        SignatureCalculator signatureCalculator2 = signatureCalculator;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String signature = OpenidConnectUtilKt.toBase64URL(signatureCalculator2.calculateSignature(byArray2));
        return headerAndPayload + '.' + signature;
    }

    @NotNull
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public final URI getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final String[] getAudience() {
        return this.audience;
    }

    @NotNull
    public final Date getExpirationTime() {
        return this.expirationTime;
    }

    @NotNull
    public final Date getIssuedAt() {
        return this.issuedAt;
    }

    @Nullable
    public final Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    @Nullable
    public final String getNonce() {
        return this.nonce;
    }

    @Nullable
    public final String getAccessTokenHash() {
        return this.accessTokenHash;
    }

    @Nullable
    public final String getCodeHash() {
        return this.codeHash;
    }

    public IdToken(@JsonUnwrapped @NotNull UserInfo userInfo, @JsonProperty(value="iss") @NotNull URI issuer, @JsonProperty(value="aud") @NotNull String[] audience, @JsonProperty(value="exp") @JsonSerialize(using=DateSerializer.class) @NotNull Date expirationTime, @JsonProperty(value="iat") @JsonSerialize(using=DateSerializer.class) @NotNull Date issuedAt, @JsonProperty(value="auth_time") @JsonSerialize(using=DateSerializer.class) @Nullable Date authenticationTime, @Nullable String nonce, @JsonProperty(value="at_hash") @Nullable String accessTokenHash, @JsonProperty(value="c_hash") @Nullable String codeHash) {
        Intrinsics.checkParameterIsNotNull((Object)userInfo, (String)"userInfo");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)audience, (String)"audience");
        Intrinsics.checkParameterIsNotNull((Object)expirationTime, (String)"expirationTime");
        Intrinsics.checkParameterIsNotNull((Object)issuedAt, (String)"issuedAt");
        this.userInfo = userInfo;
        this.issuer = issuer;
        this.audience = audience;
        this.expirationTime = expirationTime;
        this.issuedAt = issuedAt;
        this.authenticationTime = authenticationTime;
        this.nonce = nonce;
        this.accessTokenHash = accessTokenHash;
        this.codeHash = codeHash;
    }

    public /* synthetic */ IdToken(UserInfo userInfo, URI uRI, String[] stringArray, Date date, Date date2, Date date3, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            date3 = null;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        if ((n & 0x80) != 0) {
            string2 = null;
        }
        if ((n & 0x100) != 0) {
            string3 = null;
        }
        this(userInfo, uRI, stringArray, date, date2, date3, string, string2, string3);
    }
}

