/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;
import jetbrains.mps.webr.runtime.converter.NullConvertException;

public class ByteConverter
extends FixedClassConverter {
    public ByteConverter() {
        super(Byte.TYPE);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Byte)value);
    }

    private String doToString(byte value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if (valueAsString == null) {
            throw new NullConvertException(typeName);
        }
        try {
            return Byte.parseByte(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.byte_converter_format_exception", valueAsString);
        }
    }
}

