/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.debug;

import jetbrains.mps.webr.runtime.servlet.FileUtil;
import jetbrains.mps.webr.runtime.servlet.ResourceWrapper;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import jetbrains.mps.webr.runtime.uri.Path;
import jetbrains.mps.webr.runtime.uri.hash.HashFileNameUtil;
import webr.framework.controller.BaseApplication;

public final class DebugFileUtil {
    private DebugFileUtil() {
    }

    private static String getDebugFile(String resourcePath, String suffix) {
        String res;
        Path path = Path.newPath(resourcePath);
        path.appendToShortName("-" + suffix);
        String pathStr = path.toPathStr();
        ResourceWrapper resource = ServletUtil.getResourceWrapper(pathStr);
        String string = res = FileUtil.exists(resource) ? pathStr : resourcePath;
        if (resource != null) {
            resource.close();
        }
        return res;
    }

    public static String getDebugFile(String resourcePath) {
        String debugFile = resourcePath;
        if (resourcePath.endsWith(".js") || resourcePath.endsWith(".css")) {
            String suffix = DebugFileUtil.isDebug() ? "debug" : "min";
            debugFile = DebugFileUtil.getDebugFile(resourcePath, suffix);
        }
        return HashFileNameUtil.getHashPath(debugFile, false);
    }

    public static boolean isDebug() {
        return BaseApplication.getCentralManager().isAppDebugMode();
    }
}

