/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.freemarker.ftlInclude;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.webr.runtime.freemarker.ftlInclude.FtlIncludeContext;
import jetbrains.mps.webr.runtime.freemarker.ftlInclude.FtlIncludeThreadLocal;
import jetbrains.mps.webr.runtime.freemarker.ftlInclude.FtlWriter;
import jetbrains.mps.webr.runtime.freemarker.ftlInclude.IncludeHtmlTemplateMethod;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import webr.framework.controller.BaseApplication;
import webr.framework.textBuilder.TBuilderContext;

public class FtlIncludeUtil {
    private static final Map<String, Object> ROOT_MAP = new HashMap<String, Object>();

    private FtlIncludeUtil() {
    }

    private static Map<String, Object> createRootMap(Map<String, Object> templateParameters) {
        HashMap<String, Object> rootMap = new HashMap<String, Object>(ROOT_MAP);
        rootMap.put("includeHtmlTemplate", new IncludeHtmlTemplateMethod(templateParameters));
        return rootMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeFtlFile(TBuilderContext builderContext, String filePath, Map<String, Object> templateParameters) {
        try (FtlWriter writer = new FtlWriter(builderContext);){
            Template template = BaseApplication.getCentralManager().getFreemarkerConfiguration().getTemplate(filePath);
            TemplateComponent currentTemplateComponent = builderContext.getCurrentTemplateComponent();
            FtlIncludeThreadLocal ftlIncludeThreadLocal = FtlIncludeThreadLocal.getInstance();
            FtlIncludeContext ftlIncludeContext = new FtlIncludeContext(currentTemplateComponent, builderContext);
            ftlIncludeThreadLocal.set(ftlIncludeContext);
            Map<String, Object> rootMap = FtlIncludeUtil.createRootMap(templateParameters);
            try {
                template.process(rootMap, (Writer)writer);
            }
            finally {
                ftlIncludeThreadLocal.remove();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void putInRootMap(String key, String value) {
        ROOT_MAP.put(key, value);
    }
}

