/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.plaintext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.webr.runtime.plaintext.PlainTextUtil;
import jetbrains.mps.webr.runtime.plaintext.TableCell;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Node;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;

public class TableRenderer {
    private static final Log log = LogFactory.getLog(TableRenderer.class);
    private static final String COLUMN_SEPARATOR = " ";
    private List<List<TableCell>> myRows = new ArrayList<List<TableCell>>();
    private static final String ROW_SEPARATOR = "%n";

    public TableRenderer(TableTag tableTag) {
        for (TableRow tableRow : tableTag.getRows()) {
            ArrayList<TableCell> row = new ArrayList<TableCell>();
            this.myRows.add(row);
            for (Node node : tableRow.getChildrenAsNodeArray()) {
                if (!(node instanceof TableColumn) && !(node instanceof TableHeader)) continue;
                CompositeTag compositeTag = (CompositeTag)node;
                String cellContent = PlainTextUtil.toPlainText(compositeTag.getChildrenHTML());
                TableCell cell = new TableCell(cellContent != null ? cellContent : "");
                row.add(cell);
            }
        }
    }

    public void print(Appendable appendable) {
        int columnCount = this.getColumnCount();
        int[] widths = new int[columnCount];
        for (int column = 0; column < columnCount; ++column) {
            widths[column] = this.getWidth(column);
        }
        for (List<TableCell> row : this.myRows) {
            int height = this.getHeight(row);
            for (int lineNumber = 0; lineNumber < height; ++lineNumber) {
                for (int column = 0; column < columnCount; ++column) {
                    TableCell cell = column < row.size() ? row.get(column) : null;
                    this.printLine(appendable, cell, lineNumber, widths[column]);
                    this.printColumnSeparator(appendable);
                }
                this.printRowSeparator(appendable);
            }
        }
    }

    private int getWidth(int column) {
        int width = 0;
        for (List<TableCell> row : this.myRows) {
            if (column >= row.size()) continue;
            width = Math.max(width, row.get(column).getWidth());
        }
        return width;
    }

    private int getHeight(List<TableCell> row) {
        int height = 0;
        for (TableCell tableCell : row) {
            height = Math.max(height, tableCell.getHeight());
        }
        return height;
    }

    private int getColumnCount() {
        int columnCount = 0;
        for (List<TableCell> row : this.myRows) {
            columnCount = Math.max(columnCount, row.size());
        }
        return columnCount;
    }

    protected void printLine(Appendable appendable, TableCell tableCell, int lineNumber, int width) {
        try {
            int lineWidth = 0;
            if (tableCell != null && lineNumber < tableCell.getHeight()) {
                String line = tableCell.getLine(lineNumber);
                lineWidth = line.length();
                appendable.append(line);
            }
            for (int i = lineWidth; i < width; ++i) {
                appendable.append(COLUMN_SEPARATOR);
            }
        }
        catch (IOException e) {
            log.error((Object)"Can't append line", (Throwable)e);
        }
    }

    protected void printColumnSeparator(Appendable appendable) {
        try {
            appendable.append(COLUMN_SEPARATOR);
        }
        catch (IOException e) {
            log.error((Object)"Can't append column separator", (Throwable)e);
        }
    }

    private void printRowSeparator(Appendable appendable) {
        try {
            appendable.append(String.format(ROW_SEPARATOR, new Object[0]));
        }
        catch (IOException e) {
            log.error((Object)"Can't append column separator", (Throwable)e);
        }
    }
}

