/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceWrapper {
    private static Log log = LogFactory.getLog(ResourceWrapper.class);
    private final InputStream stream;
    private final String name;
    private final File file;

    ResourceWrapper(ClassLoader cl, String fileName) throws IllegalArgumentException {
        URL url;
        if (fileName != null && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if ((url = cl.getResource(fileName)) != null) {
            File resourceFile = null;
            FileInputStream resourceStream = null;
            if (!ServletUtil.isJarURL(url)) {
                try {
                    resourceFile = new File(url.toURI());
                    resourceStream = new FileInputStream(resourceFile);
                }
                catch (URISyntaxException e) {
                    log.warn((Object)("Can't convert to uri [" + url + "]"), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)("File note found [" + resourceFile + "]"), (Throwable)e);
                }
            }
            if (resourceStream == null) {
                this.file = null;
                this.stream = cl.getResourceAsStream(fileName);
            } else {
                this.file = resourceFile;
                this.stream = resourceStream;
            }
        } else {
            throw new IllegalArgumentException("Resource for given name not found by ClassLoader: " + fileName);
        }
        this.name = fileName;
    }

    public InputStream inputStream() {
        return this.stream;
    }

    public long lastModified() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.lastModified();
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        if (this.file == null) {
            return true;
        }
        return this.file.exists();
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            log.error((Object)("Error on closing resource stream [" + this.getName() + "]"));
        }
    }
}

