/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.util.StringBuilderSpinAllocator;
import jetbrains.exodus.util.StringHashMap;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.htmlComponent.runtime.HtmlComponentUtil;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.runtime.component.HtmlTemplate;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.BoundValue;
import jetbrains.mps.webr.runtime.templateComponent.DoNothingException;
import jetbrains.mps.webr.runtime.templateComponent.ExceptionHandlingUtil;
import jetbrains.mps.webr.runtime.templateComponent.ITemplateComponent;
import jetbrains.mps.webr.runtime.templateComponent.ITemplateFactory;
import jetbrains.mps.webr.runtime.templateComponent.IWrapper;
import jetbrains.mps.webr.runtime.templateComponent.InputValue;
import jetbrains.mps.webr.runtime.templateComponent.LayoutComponent;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.templateComponent.TemplateActionController;
import jetbrains.mps.webr.runtime.templateComponent.TemplateActionHandler;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponentProvider;
import jetbrains.mps.webr.runtime.templateComponent.TemplateDependencyManager;
import jetbrains.mps.webr.runtime.templateComponent.TemplateEventHandler;
import jetbrains.mps.webr.runtime.templateComponent.Widget;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.textBuilder.PopulateParameters;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.url.UrlUtil;

public abstract class TemplateComponent
implements Serializable,
ITemplateComponent {
    private static final boolean DO_NOT_USE_PARAMS_STRING_MAP = Boolean.getBoolean("jetbrains.mps.webr.runtime.doNotUseParamsStringMap");
    protected static Log log = LogFactory.getLog(TemplateComponent.class);
    protected String templateName;
    protected String refName;
    protected Object callParam;
    protected TemplateComponent parentTemplateComponent;
    protected final TemplateActionController templateActionController;
    private String refreshElementId;
    private Map<String, TemplateComponent> childrenTemplateComponents;
    private Map<String, Object> templateParameters;
    private Set<String> jsDependencies;
    private transient Map<String, List<TemplateEventHandler>> eventHandlers;
    protected transient _FunctionTypes._void_P1_E0<? super TBuilderContext> beforeRenderHandler;
    private Map<String, Widget> widgets;
    private volatile ConcurrentLinkedQueue<JsCommandResponse> deferredCommands;
    private List<BoundValue> boundValues;
    protected IWrapper wrapper;
    private Boolean templateNotLoaded = null;
    private int statusCode = 200;

    protected TemplateComponent(TemplateActionController templateActionController, TemplateComponent parentTemplateComponent, String templateName) {
        this.templateActionController = templateActionController == null && parentTemplateComponent != null ? parentTemplateComponent.templateActionController : templateActionController;
        this.init(parentTemplateComponent, templateName);
        this.templateParameters = this.initTemplateParameters();
        this.onEnter();
    }

    protected TemplateComponent(TemplateActionController templateActionController, TemplateComponent parentTemplateComponent, String templateName, Map<String, Object> templateParameters) {
        this.templateActionController = templateActionController == null && parentTemplateComponent != null ? parentTemplateComponent.templateActionController : templateActionController;
        this.init(parentTemplateComponent, templateName);
        this.templateParameters = templateParameters == null ? this.initTemplateParameters() : templateParameters;
        this.initTemplateProperties();
        this.onEnter();
    }

    protected final void init(TemplateComponent parentTemplateComponent, String templateName) {
        this.parentTemplateComponent = parentTemplateComponent;
        this.templateName = StringInterner.intern((String)templateName);
    }

    void setWrapper(IWrapper wrapper) {
        this.wrapper = wrapper;
    }

    protected Map<String, Object> initTemplateParameters() {
        return null;
    }

    @Deprecated
    protected void createExecutor() {
        throw new UnsupportedOperationException("Executors are not supported anymore");
    }

    public void setRefName(String shortName) {
        this.refName = StringInterner.intern((String)shortName);
    }

    public String getRefName() {
        return this.refName;
    }

    public Object getCallParam() {
        return this.callParam;
    }

    public int getResponseStatusCode() {
        return this.statusCode;
    }

    public void setResponseStatusCode(int code) {
        this.statusCode = code;
    }

    public void setCallParam(Object refParam) {
        this.callParam = refParam instanceof String ? StringInterner.intern((String)((String)refParam)) : refParam;
    }

    protected void initEventHandlers() {
    }

    protected void onEnter() {
    }

    protected void onDestroy() {
    }

    public final Map<String, Widget> getWidgets() {
        if (this.widgets == null) {
            this.widgets = new StringHashMap();
        }
        return this.widgets;
    }

    @Override
    public Widget getWidget(String widgetId) {
        Map<String, Widget> widgets = this.getWidgets();
        Widget w = widgets.get(widgetId);
        if (w == null) {
            w = new Widget(this, widgetId);
            widgets.put(widgetId, w);
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommandResponse(JsCommandResponse cr) {
        if (cr != null) {
            if (this.deferredCommands == null) {
                TemplateComponent templateComponent = this;
                synchronized (templateComponent) {
                    if (this.deferredCommands == null) {
                        this.deferredCommands = new ConcurrentLinkedQueue();
                    }
                }
            }
            if (BaseApplication.isInsideRequestProcessing() && TemplateComponent.eq_27ll1d_a0a0b0a0p(BaseApplication.getCurrentWindowId(), this.templateActionController.getWindowId()) && this.templateActionController.isDeferredCommandsPrebuilding()) {
                throw new IllegalStateException("Can't add deferred command while prebuilding them.");
            }
            this.deferredCommands.add(cr);
        }
    }

    private Map<String, List<TemplateEventHandler>> getEventHandlers() {
        if (this.eventHandlers == null) {
            this.eventHandlers = new StringHashMap();
            this.initEventHandlers();
        }
        return this.eventHandlers;
    }

    private Iterable<TemplateEventHandler> getEventHandlers(String eventName) {
        List<TemplateEventHandler> res = this.getEventHandlers().get(eventName);
        return res == null ? null : ListSequence.fromList(res).where((_FunctionTypes._return_P1_E0)new IWhereFilter<TemplateEventHandler>(){

            public boolean accept(TemplateEventHandler it) {
                return !(it instanceof TemplateActionHandler);
            }
        });
    }

    private Iterable<TemplateEventHandler> getTemplateActionHandlers(String actionName) {
        List<TemplateEventHandler> list = this.getEventHandlers().get(actionName);
        return list == null ? null : ListSequence.fromList(list).where((_FunctionTypes._return_P1_E0)new IWhereFilter<TemplateEventHandler>(){

            public boolean accept(TemplateEventHandler it) {
                return it instanceof TemplateActionHandler;
            }
        });
    }

    protected void addEventHandler(TemplateEventHandler eventHandler) {
        String eventName;
        Map<String, List<TemplateEventHandler>> handlers = this.getEventHandlers();
        List<TemplateEventHandler> list = handlers.get(eventName = eventHandler.getEventName());
        if (list == null) {
            list = Collections.singletonList(eventHandler);
            handlers.put(eventName, list);
        } else {
            if (!(list instanceof ArrayList)) {
                TemplateEventHandler firstHandler = list.get(0);
                list = new ArrayList<TemplateEventHandler>(2);
                list.add(firstHandler);
                handlers.put(eventName, list);
            }
            list.add(eventHandler);
        }
    }

    public <T> T registerInputValue(InputValue<T> inputValue, String parameterName, boolean commaSeparated) {
        if (inputValue instanceof BoundValue) {
            BoundValue boundValue = (BoundValue)inputValue;
            boundValue.setParameterName(parameterName);
            boundValue.setCommaSeparated(commaSeparated);
            if (this.boundValues == null) {
                this.boundValues = Collections.singletonList(boundValue);
            } else {
                if (!(this.boundValues instanceof ArrayList)) {
                    BoundValue fisrtValue = this.boundValues.get(0);
                    this.boundValues = new ArrayList<BoundValue>(2);
                    this.boundValues.add(fisrtValue);
                }
                this.boundValues.add(boundValue);
            }
        }
        T value = null;
        if (inputValue != null) {
            value = inputValue.get();
        }
        return value;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public TemplateActionController getTemplateActionController() {
        return this.templateActionController == null && this.getParentTemplateComponent() != null ? this.getParentTemplateComponent().getTemplateActionController() : this.templateActionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTemplatePath() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            this.getTemplatePath(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private void getTemplatePath(StringBuilder builder) {
        TemplateComponent parent = this.parentTemplateComponent;
        if (parent == null) {
            builder.append(this.templateName);
        } else {
            parent.getTemplatePath(builder);
            builder.append('.');
            builder.append(this.templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRefPath() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            this.getRefPath(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public void getRefPath(StringBuilder builder) {
        TemplateComponent parent = this.parentTemplateComponent;
        if (parent == null) {
            builder.append(this.refName);
        } else {
            parent.getRefPath(builder);
            builder.append('.');
            builder.append(this.refName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventPath(String eventName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            this.getTemplatePath(builder);
            builder.append(':');
            builder.append(eventName);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRefPath(String componentShortName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            this.getRefPath(builder);
            builder.append('.');
            builder.append(componentShortName);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullLabeledInputName(String shortLabeledInputName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            String string = this.getFullLabeledInputName(builder, shortLabeledInputName);
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    protected String getFullLabeledInputName(StringBuilder builder, String shortLabeledInputName) {
        this.getTemplatePath(builder);
        builder.append('.');
        builder.append(shortLabeledInputName);
        return builder.toString();
    }

    public TemplateComponent getRootTemplateComponent() {
        TemplateComponent currentTemplateComponent = this;
        while (currentTemplateComponent.getParentTemplateComponent() != null) {
            currentTemplateComponent = currentTemplateComponent.getParentTemplateComponent();
        }
        return currentTemplateComponent;
    }

    protected boolean isRootComponent() {
        if (this.parentTemplateComponent == null) {
            return true;
        }
        return this.parentTemplateComponent instanceof LayoutComponent;
    }

    public TemplateComponent getParentTemplateComponent() {
        return this.parentTemplateComponent;
    }

    private void setParentTemplateComponent(TemplateComponent parentTemplateComponent) {
        this.parentTemplateComponent = parentTemplateComponent;
    }

    public void addChildTemplateComponent(String templateName, TemplateComponent childTemplateComponent) {
        if (this.childrenTemplateComponents == null) {
            this.childrenTemplateComponents = new StringHashMap();
        }
        this.childrenTemplateComponents.put(templateName, childTemplateComponent);
        childTemplateComponent.setParentTemplateComponent(this);
    }

    @NotNull
    public Map<String, TemplateComponent> getChildrenTemplateComponents() {
        return this.childrenTemplateComponents != null ? this.childrenTemplateComponents : Collections.EMPTY_MAP;
    }

    public Map<String, Object> getTemplateParameters() {
        if (this.templateParameters == null) {
            throw new RuntimeException("No template parameters passed to child. Try to regenerate " + this.parentTemplateComponent);
        }
        return this.templateParameters;
    }

    public void setTemplateParameters(Map<String, Object> newTemplateParameters) {
        if (this.templateParameters == null) {
            this.templateParameters = newTemplateParameters;
        } else {
            this.templateParameters.putAll(newTemplateParameters);
        }
    }

    public void render(TBuilderContext builderContext) {
        this.renderTemplate(builderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString() {
        TBuilderContext builderContext = new TBuilderContext();
        builderContext.pushCurrentTemplateComponent(this);
        builderContext.setCurrentLayoutName(null);
        builderContext.setCurrentTemplateName(this.getTemplateName());
        BuilderThreadContext.initNonLocalBuilderThreadContext();
        String content = null;
        try {
            this.render(builderContext);
            content = builderContext.getText();
        }
        finally {
            BuilderThreadContext.close();
        }
        builderContext.popCurrentTemplateComponent();
        return content;
    }

    public String getRefreshContent() {
        this.clearNotLoadedProperties();
        TBuilderContext builderContext = new TBuilderContext();
        builderContext.setSkipScriptIncludes(false);
        builderContext.setWindowId(this.getTemplateActionController().getWindowId());
        this.render(builderContext);
        HtmlComponentUtil.addTemplatePaths((TBuilderContext)builderContext, (TemplateComponent)this);
        HtmlComponentUtil.addResponseTimeJs((TBuilderContext)builderContext);
        LinkUtil.addScriptDependencies(builderContext, (Iterable<String>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("<script type=\"text/javascript\"");
        builderContext.append(LinkUtil.DEFER_STRING);
        builderContext.append(">");
        builderContext.appendIndent();
        LinkUtil.addScriptDependencies(builderContext, (Iterable<String>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.mps.webr.jquery.jquery"}));
        builderContext.appendIndent();
        builderContext.append("$(document).ready(function () {");
        builderContext.appendNewLine();
        builderContext.increaseIndent();
        builderContext.appendIndent();
        builderContext.addContentPlaceholder("__JAVASCRIPT_CONTENT__");
        builderContext.appendNewLine();
        builderContext.decreaseIndent();
        builderContext.appendIndent();
        builderContext.append("});");
        builderContext.appendNewLine();
        builderContext.appendNewLine();
        builderContext.append("</script>");
        builderContext.appendNewLine();
        return builderContext.getText();
    }

    private void clearNotLoadedProperties() {
        if (this.childrenTemplateComponents != null) {
            for (TemplateComponent child : this.childrenTemplateComponents.values()) {
                child.templateNotLoaded = null;
                child.clearNotLoadedProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTemplate(TBuilderContext builderContext) {
        block11: {
            this.jsDependencies = null;
            this.boundValues = null;
            builderContext.pushCurrentTemplateComponent(this);
            try {
                this.getEventHandlers();
                if (this.beforeRenderHandler != null) {
                    this.beforeRenderHandler.invoke((Object)builderContext);
                }
                this.doBeforeRender(builderContext);
                Map<String, TemplateComponent> oldChildrenTemplateComponents = this.clearOldChildrenTemplateComponents();
                builderContext.pushOldChildrenTemplateComponents(oldChildrenTemplateComponents);
                try {
                    this.renderTemplate(this.templateParameters, builderContext);
                    for (TemplateComponent component : oldChildrenTemplateComponents.values()) {
                        component.destroy();
                    }
                }
                finally {
                    builderContext.popOldChildrenTemplateComponents();
                }
            }
            catch (EntityRemovedInDatabaseException e) {
                if (this.isRootComponent()) {
                    Widget.addCommandResponseSafe(builderContext.getCurrentTemplateComponent(), TemplateComponent.redirectToRemovedOnRender(e, this.templateParameters, this.templateActionController));
                    break block11;
                }
                throw e;
            }
            finally {
                builderContext.popCurrentTemplateComponent();
            }
        }
    }

    protected void doBeforeRender(TBuilderContext builderContext) {
    }

    protected void initTemplateProperties() {
    }

    protected abstract void renderTemplate(Map<String, Object> var1, TBuilderContext var2);

    void rebuildRootComponent() {
        TBuilderContext builderContext = new TBuilderContext();
        this.getRootTemplateComponent().buildComponentTree(builderContext);
    }

    private void buildComponentTree(TBuilderContext builderContext) {
        builderContext.pushCurrentTemplateComponent(this);
        Map<String, TemplateComponent> oldChildrenTemplateComponents = this.clearOldChildrenTemplateComponents();
        builderContext.pushOldChildrenTemplateComponents(oldChildrenTemplateComponents);
        this.doBuildComponentTree(this.getTemplateParameters(), builderContext);
        builderContext.popOldChildrenTemplateComponents();
        builderContext.popCurrentTemplateComponent();
    }

    protected void doBuildComponentTree(Map<String, Object> templateParameters, TBuilderContext builderContext) {
    }

    private void populateBindingsNew(PopulateParameters populateParameters) {
        if (populateParameters.hasParameters(this.getTemplatePath())) {
            for (TemplateComponent child : this.getChildrenTemplateComponents().values()) {
                child.populateBindingsNew(populateParameters);
            }
            if (this.boundValues != null) {
                TemplateComponentProvider templateComponentProvider = new TemplateComponentProvider(this);
                for (BoundValue boundValue : this.boundValues) {
                    boundValue.populate(populateParameters, templateComponentProvider);
                }
            }
        }
    }

    protected void prebuildCompositeCommandsContent(TemplateActionController actionController) {
        for (TemplateComponent child : this.getChildrenTemplateComponents().values()) {
            child.prebuildCompositeCommandsContent(actionController);
        }
        if (this.deferredCommands != null) {
            JsCommandResponse command;
            int maxSize = this.deferredCommands.size();
            LinkedHashSet set = new LinkedHashSet(6, 2.0f);
            for (int i = 0; i < maxSize && (command = this.deferredCommands.poll()) != null; ++i) {
                set.add(command);
            }
            for (JsCommandResponse command2 : set) {
                if (command2.isRequiresRebuildTemplateParameters()) {
                    actionController.rebuildRootIfNeeded();
                }
                command2.prebuildContent();
                BaseApplication.getCompositeCommand().addCommand(command2, this);
            }
        }
    }

    public ResponseAction newHandleEvent(String eventName, PopulateParameters populateParameters) {
        try {
            this.populateBindingsNew(populateParameters);
            ResponseAction ra = this.newHandleByActionHandlers(eventName);
            if (ra == null) {
                this.newHandleByEventHandlers(eventName);
            }
            return ra;
        }
        catch (DoNothingException e) {
            return null;
        }
    }

    private void newHandleByEventHandlers(String eventName) {
        for (TemplateComponent child : this.getChildrenTemplateComponents().values()) {
            child.newHandleByEventHandlers(eventName);
        }
        this.doNewHandleEvent(eventName);
    }

    private ResponseAction newHandleByActionHandlers(String actionName) {
        for (TemplateComponent child : this.getChildrenTemplateComponents().values()) {
            ResponseAction ra = child.newHandleByActionHandlers(actionName);
            if (ra == null) continue;
            return ra;
        }
        return this.doNewHandleAction(actionName);
    }

    private void doNewHandleEvent(String eventName) {
        Iterable<TemplateEventHandler> teh = this.getEventHandlers(eventName);
        if (teh != null && Sequence.fromIterable(teh).isNotEmpty()) {
            for (TemplateEventHandler eh : Sequence.fromIterable(teh)) {
                if (eh instanceof TemplateActionHandler) {
                    throw new IllegalArgumentException("Template action handler among event handlers for event: " + eventName);
                }
                eh.handle();
            }
        }
    }

    public void destroy() {
        block3: {
            for (TemplateComponent child : this.getChildrenTemplateComponents().values()) {
                child.destroy();
            }
            try {
                this.onDestroy();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Exception while destroying template", (Throwable)e);
            }
        }
    }

    private ResponseAction doNewHandleAction(String actionName) {
        Iterable<TemplateEventHandler> tah = this.getTemplateActionHandlers(actionName);
        if (tah != null && Sequence.fromIterable(tah).isNotEmpty()) {
            for (TemplateEventHandler eh : tah) {
                if (!(eh instanceof TemplateActionHandler)) {
                    throw new IllegalArgumentException("Template event handler among action handlers for action: " + actionName);
                }
                eh.handle();
                if (((TemplateActionHandler)eh).getResponseAction() == null) continue;
                return ((TemplateActionHandler)eh).getResponseAction();
            }
        }
        return null;
    }

    public void fillTemplateParameters(Map<String, Object> templateParameters, TBuilderContext builderContext) {
        this.fillLayoutParameters(templateParameters, builderContext);
    }

    public void fillLayoutParameters(Map<String, Object> templateParameters, TBuilderContext builderContext) {
        if (this.templateActionController != null) {
            this.templateActionController.fillParameters(templateParameters, builderContext);
        }
    }

    public boolean hasAccess(TBuilderContext builderContext) {
        return this.doHasAccess(builderContext);
    }

    public boolean doHasAccess(TBuilderContext builderContext) {
        if (this.templateActionController != null) {
            return this.templateActionController.hasAccess(this.templateParameters, builderContext);
        }
        return true;
    }

    protected Map<String, TemplateComponent> clearOldChildrenTemplateComponents() {
        Map<String, TemplateComponent> oldChildrenTemplateComponents = this.getChildrenTemplateComponents();
        this.childrenTemplateComponents = null;
        return oldChildrenTemplateComponents;
    }

    public Set<String> getJsDependencies() {
        TemplateComponent root = this.getRootTemplateComponent();
        return root.jsDependencies != null ? root.jsDependencies : Collections.EMPTY_SET;
    }

    public void addJsDependencies(Iterable<String> dependencies) {
        TemplateComponent root = this.getRootTemplateComponent();
        if (root.jsDependencies == null) {
            root.jsDependencies = new HashSet(Sequence.fromIterable(dependencies).count(), 3.0f);
        }
        for (String dep : dependencies) {
            root.jsDependencies.add(StringInterner.intern((String)dep));
        }
    }

    public ResponseAction getDefaultResponse() {
        return ResponseFactory.getInstance().getDefaultResponse();
    }

    public String getRefreshElementId() {
        return this.refreshElementId != null ? this.refreshElementId : "";
    }

    public void setRefreshElementId(String refreshElementId) {
        this.refreshElementId = StringInterner.intern((String)refreshElementId);
    }

    @Override
    public TemplateComponent getChild(String name) {
        return this.childrenTemplateComponents == null ? null : this.childrenTemplateComponents.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryRenderHidden(Map<String, Object> rootMap, TBuilderContext builderContext, String id) {
        Boolean isNotLoadedInitially = this.templateNotLoaded;
        IWrapper wrapper = this.wrapper;
        if (wrapper != null) {
            if (isNotLoadedInitially == null) {
                try {
                    builderContext.popCurrentTemplateComponent();
                    isNotLoadedInitially = !wrapper.shouldRenderUnWrapped(builderContext);
                }
                finally {
                    builderContext.pushCurrentTemplateComponent(this);
                    this.templateNotLoaded = isNotLoadedInitially;
                }
            }
            if (isNotLoadedInitially.booleanValue()) {
                wrapper.renderTemplate(rootMap, builderContext, id);
                return true;
            }
            return false;
        }
        this.templateNotLoaded = false;
        return false;
    }

    public Boolean isTemplateNotLoaded() {
        return this.templateNotLoaded;
    }

    public void setTemplateNotLoaded(Boolean value) {
        this.templateNotLoaded = value;
    }

    public TemplateComponent getNestedTemplateComponent() {
        TemplateComponent result = null;
        TemplateComponent parentTemplateComponent = this.getParentTemplateComponent();
        if (parentTemplateComponent != null) {
            result = parentTemplateComponent.getNestedTemplateComponent();
        }
        return result;
    }

    @Deprecated
    public void setExecutor(Object executor) {
        throw new UnsupportedOperationException("Executors are not supported. Please, regenerate your code.");
    }

    protected void handleEventException(Throwable e, boolean transactional) {
        if (ExceptionHandlingUtil.handleException(e)) {
            if (transactional) {
                TransientStoreUtil.abort((TransientStoreSession)DnqUtils.getCurrentTransientSession());
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initEventHandlers();
    }

    public static Map<String, TemplateComponent> getChildrenTemplateComponents(TemplateComponent instance) {
        if (instance == null) {
            return Collections.EMPTY_MAP;
        }
        return instance.childrenTemplateComponents != null ? instance.childrenTemplateComponents : Collections.EMPTY_MAP;
    }

    public static TemplateComponent getChildTemplateComponent(TemplateComponent instance, String name) {
        return instance == null ? null : instance.getChild(name);
    }

    public static Widget getWidget(TemplateComponent instance, String widgetName) {
        return instance == null ? null : instance.getWidget(widgetName);
    }

    protected static void buildComponentTree(TemplateComponent instance, TBuilderContext builderContext) {
        instance.buildComponentTree(builderContext);
    }

    public static void buildTemplateComponent(TemplateComponent instance, TBuilderContext builderContext) {
        instance.renderTemplate(builderContext);
    }

    public static Map<String, Object> newParamsMap() {
        if (DO_NOT_USE_PARAMS_STRING_MAP) {
            return new HashMap();
        }
        return new StringHashMap();
    }

    public static TemplateComponent create(String templateName) {
        TemplateDependencyManager manager = (TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager");
        ITemplateFactory templateFactory = manager.getTemplateFactory(templateName);
        if (templateFactory != null) {
            return templateFactory.create();
        }
        try {
            Class<?> templateClazz = Thread.currentThread().getContextClassLoader().loadClass(manager.getTemplateClassName(templateName));
            return (TemplateComponent)templateClazz.newInstance();
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1.getCause());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static TemplateComponent create(String templateName, TemplateComponent parentTemplateComponent, String refTemplateName, Map<String, Object> templateParameters) {
        TemplateDependencyManager manager = (TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager");
        ITemplateFactory templateFactory = manager.getTemplateFactory(templateName);
        if (templateFactory != null) {
            return templateFactory.create(parentTemplateComponent, refTemplateName, templateParameters);
        }
        try {
            Class<?> templateClazz = Thread.currentThread().getContextClassLoader().loadClass(((TemplateDependencyManager)ServiceLocator.getBean((String)"templateDependencyManager")).getTemplateClassName(templateName));
            return (TemplateComponent)templateClazz.getConstructor(TemplateComponent.class, String.class, Map.class).newInstance(parentTemplateComponent, refTemplateName, templateParameters);
        }
        catch (InvocationTargetException e0) {
            Throwable cause = e0.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1.getCause());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static JsCommandResponse redirectToRemovedOnRender(EntityRemovedInDatabaseException e, Map<String, ?> templateParams, TemplateActionController templateActionController) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Exception on showing something removed.", (Throwable)e);
        }
        QueryParameter[] parameters = new QueryParameter[MapSequence.fromMap(templateParams).count()];
        int i = 0;
        for (IMapping parameter : MapSequence.fromMap(templateParams).mappingsSet()) {
            parameters[i++] = new QueryParameter((String)parameter.key(), parameter.value(), (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager"));
        }
        String thisTemplateUri = UrlUtil.getHtmlTemplateUri(templateActionController.getActionName(), "", parameters);
        TemplateComponent fakeComponent = new TemplateComponent(null, null, null){

            @Override
            protected void renderTemplate(Map<String, Object> templateParameters, TBuilderContext builderContext) {
            }
        };
        return HtmlTemplate.redirect(fakeComponent, UrlUtil.getHtmlTemplateUri("RemovedOnRender", "", new QueryParameter[0]));
    }

    private static boolean eq_27ll1d_a0a0b0a0p(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

