/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.io.Serializable;
import jetbrains.exodus.util.StringBuilderSpinAllocator;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.webr.runtime.templateComponent.IComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.runtime.response.JsCommandResponse;

public class Widget
implements IComponent,
Serializable {
    protected static Log log = LogFactory.getLog(Widget.class);
    private TemplateComponent templateComponent;
    protected String widgetId;

    Widget(TemplateComponent templateComponent, String widgetId) {
        this.templateComponent = templateComponent;
        this.widgetId = StringInterner.intern((String)widgetId);
    }

    protected Widget() {
    }

    public TemplateComponent getTemplateComponent() {
        return this.templateComponent;
    }

    public String getWidgetId() {
        return this.templateComponent.getFullLabeledInputName(this.widgetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventName(Object eventName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            this.templateComponent.getFullLabeledInputName(builder, this.widgetId);
            builder.append(':');
            builder.append(eventName);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public void addCommandResponse(JsCommandResponse commandResponse) {
        this.templateComponent.addCommandResponse(commandResponse);
    }

    public static void addCommandResponseSafe(IComponent c, JsCommandResponse commandResponse) {
        if (c != null && commandResponse != null) {
            c.addCommandResponse(commandResponse);
        } else if (c == null && commandResponse != null && log.isWarnEnabled()) {
            log.warn((Object)"Try to add commandResponse for null component.");
        }
    }

    public static String getWidgetId(Widget widget) {
        return widget == null ? "" : widget.getWidgetId();
    }
}

