/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.uri;

import jetbrains.exodus.database.TransientEntity;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public final class QueryParameter {
    private final String myName;
    private final Object myValue;
    private final boolean myEncoded;

    public QueryParameter(String name, Object value) {
        this.myName = name;
        this.myValue = value;
        this.myEncoded = true;
    }

    public QueryParameter(String name, Object value, TypeConvertManager typeConvertManager) {
        this(name, value, typeConvertManager, true);
    }

    public QueryParameter(String name, Object value, TypeConvertManager typeConvertManager, boolean encoded) {
        this(name, value, typeConvertManager, encoded, true);
    }

    private QueryParameter(String name, Object value, TypeConvertManager typeConvertManager, boolean encoded, boolean checkIsNew) {
        this.myName = name;
        this.myEncoded = encoded;
        if (checkIsNew && value instanceof TransientEntity && ((TransientEntity)value).isNew()) {
            throw new IllegalArgumentException("Webr application design problem: attempt to pass not saved transient entity as an argument to the action");
        }
        this.myValue = typeConvertManager.toString(value);
    }

    public String getName() {
        return this.myName;
    }

    public Object getValue() {
        return this.myValue;
    }

    public boolean isEncoded() {
        return this.myEncoded;
    }

    public static QueryParameter newQueryParameter(String name, Object value) {
        return new QueryParameter(name, value, (TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager"));
    }
}

