/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.uri.hash;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.mps.webr.runtime.debug.DebugFileUtil;
import jetbrains.mps.webr.runtime.servlet.FileUtil;
import jetbrains.mps.webr.runtime.servlet.ResourceWrapper;
import jetbrains.mps.webr.runtime.servlet.ServletUtil;
import jetbrains.mps.webr.runtime.uri.Path;
import jetbrains.mps.webr.runtime.uri.hash.CacheEntry;
import jetbrains.mps.webr.runtime.uri.hash.DigestUtil;
import org.apache.commons.io.IOUtils;

public final class HashFileNameUtil {
    private static final Map<String, CacheEntry> CACHE_ENTRY_MAP = new ConcurrentHashMap<String, CacheEntry>();
    private static final String HASH_PREFIX = "-h-";

    private HashFileNameUtil() {
    }

    private static String getHash(ResourceWrapper wrapper, boolean shouldCheckIsDebug) {
        String hash = "";
        try {
            InputStream inputStream = wrapper.inputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            hash = shouldCheckIsDebug ? DigestUtil.digest(bytes, DebugFileUtil.isDebug()) : DigestUtil.digest(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHashPath(String path, boolean shouldCheckIsDebug) {
        long lastModified;
        String result = path;
        File file = ServletUtil.getFile(path);
        long l = lastModified = file != null ? file.lastModified() : 0L;
        if (FileUtil.exists(file)) {
            CacheEntry cacheEntry = CACHE_ENTRY_MAP.get(path);
            if (cacheEntry != null && lastModified == cacheEntry.getLastModified()) {
                result = cacheEntry.getHashPath();
            } else {
                try (ResourceWrapper wrapper = null;){
                    wrapper = ServletUtil.getResourceWrapper(path);
                    result = HashFileNameUtil.getHashPath(path, HashFileNameUtil.getHash(wrapper, shouldCheckIsDebug));
                    CACHE_ENTRY_MAP.put(path, new CacheEntry(lastModified, result));
                }
            }
        }
        return result;
    }

    public static String getPath(String hashPath) {
        Path path;
        String shortName;
        int index;
        if (hashPath != null && hashPath.startsWith("/")) {
            hashPath = hashPath.substring(1);
        }
        if ((index = (shortName = (path = Path.newPath(hashPath)).getShortName()).indexOf(HASH_PREFIX)) >= 0) {
            shortName = shortName.substring(0, index);
            path.setShortName(shortName);
        }
        return path.toPathStr();
    }

    private static String getHashPath(String pathStr, String hash) {
        Path path = Path.newPath(pathStr);
        path.appendToShortName(HASH_PREFIX + hash);
        return path.toPathStr();
    }
}

