/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.url;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.runtime.url.StringUtils;

public class RequestUri {
    private String shortUri;
    private String contextPath;
    private int[] slashIndeces;

    public RequestUri(String shortUri) {
        this.shortUri = shortUri;
        if (shortUri != null && shortUri.length() > 0) {
            int len = shortUri.length();
            IListSequence slashIndeces = ListSequence.fromList(new ArrayList());
            if (shortUri.charAt(0) != '/') {
                ListSequence.fromList((List)slashIndeces).addElement((Object)-1);
            }
            int i = 0;
            while (i < len) {
                int slashIndex = shortUri.indexOf(47, i);
                if (slashIndex != -1) {
                    i = slashIndex + 1;
                    ListSequence.fromList((List)slashIndeces).addElement((Object)slashIndex);
                    continue;
                }
                i = len;
            }
            ListSequence.fromList((List)slashIndeces).addElement((Object)shortUri.length());
            this.slashIndeces = ArrayUtils.toIntArray((ISequence)ListSequence.fromList((List)slashIndeces));
        }
    }

    public RequestUri(String contextPath, String shortUri) {
        this(shortUri);
        this.contextPath = contextPath;
    }

    public String getElement(int i) {
        if (RequestUri.isEmpty_gsh16m_a0a0a0a(this.shortUri) || i < 0 || i >= this.slashIndeces.length - 1) {
            return null;
        }
        if (this.slashIndeces[i] + 1 < this.slashIndeces[i + 1]) {
            return StringUtils.substring(this.shortUri, this.slashIndeces[i] + 1, this.slashIndeces[i + 1]);
        }
        return null;
    }

    public String getTail(int skipElements) {
        return this.getTail(skipElements, true);
    }

    public String getTail(int skipElements, boolean leadingSlash) {
        if (RequestUri.isEmpty_gsh16m_a0a0a2(this.shortUri) || skipElements >= this.slashIndeces.length - 1) {
            return null;
        }
        if (skipElements < 0) {
            return this.shortUri;
        }
        return StringUtils.substring(this.shortUri, Math.max(0, this.slashIndeces[skipElements] + (leadingSlash ? 0 : 1)));
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getShortUri() {
        return this.shortUri;
    }

    public String getFullUri() {
        return this.contextPath + this.shortUri;
    }

    public String toString() {
        return this.shortUri;
    }

    public static boolean isEmpty_gsh16m_a0a0a0a(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_gsh16m_a0a0a2(String str) {
        return str == null || str.length() == 0;
    }
}

