/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.util;

import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class ParameterUtil {
    public static final String NON_EMPTY_PASSWORD = "Password is defined";

    private ParameterUtil() {
    }

    public static String getHtmlComponentId(String name, Object ... parameters) {
        return "id_" + ParameterUtil.getParameterString(name, parameters);
    }

    public static String getParameterStringWithPost(String name, boolean post, Object ... parameters) {
        return post ? ParameterUtil.getParameterString(name, parameters) : "-" + ParameterUtil.getParameterString(name, parameters);
    }

    public static String getParameterStringWithPostDirect(String name, Object ... parameters) {
        return ParameterUtil.getParameterString(name, parameters);
    }

    public static String getParameterString(String name, Object ... parameter) {
        StringBuilder builder = new StringBuilder(name);
        for (Object p : parameter) {
            if (p == null) continue;
            ParameterUtil.appendSingleElement(builder, p);
        }
        return builder.toString();
    }

    private static void appendSingleElement(StringBuilder builder, Object parameter) {
        builder.append("_");
        String asString = ((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).toString(parameter);
        ParameterUtil.appendSafeString(builder, asString);
    }

    private static void appendSafeString(StringBuilder builder, String str) {
        if (str.indexOf(45) == -1) {
            builder.append(str);
        } else {
            builder.append(str.replace('-', '_'));
        }
    }

    public static Object wrapPasswordValue(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String && ParameterUtil.isEmpty_3gwj9x_a0a1a6((String)value)) {
            return value;
        }
        return NON_EMPTY_PASSWORD;
    }

    public static boolean isEmpty_3gwj9x_a0a1a6(String str) {
        return str == null || str.length() == 0;
    }
}

