/*
 * Decompiled with CFR 0.152.
 */
package webr.dnq;

import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.runtime.record.RecordManager;

public final class DNQRecordManager
implements RecordManager {
    private static final Log log = LogFactory.getLog(DNQRecordManager.class);

    @Override
    public boolean isRecord(Object object) {
        return object instanceof Entity;
    }

    @Override
    public String toIdString(Object object) {
        assert (object instanceof Entity);
        return ((Entity)object).toIdString();
    }

    @Override
    public boolean isRecordClassName(String className) {
        Class<?> aClass;
        try {
            aClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Entity.class.isAssignableFrom(aClass);
    }

    @Override
    public Object toRecord(String idString) {
        TransientStoreSession session = ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession();
        if (session == null) {
            throw new IllegalStateException("There's no current transient session.");
        }
        try {
            EntityId id = session.toEntityId(idString);
            return session.getEntity(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

