/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import webr.framework.controller.BaseApplication;

public final class ErrorMessageManager {
    private static final String ERROR_MESSAGES = ErrorMessageManager.class + ".ERROR_MESSAGES";

    private ErrorMessageManager() {
    }

    public static void addMessage(Serializable message, Severity severity, String input) {
        ErrorMessageManager.getMessages().add(new Message(message, severity, input));
    }

    public static boolean isEmpty() {
        return ErrorMessageManager.getMessages().isEmpty();
    }

    public static void clearMessages() {
        ErrorMessageManager.getMessages().clear();
    }

    public static Collection<Message> getMessages() {
        ArrayList errorMessages = (ArrayList)BaseApplication.getSessionField(ERROR_MESSAGES);
        if (errorMessages == null) {
            errorMessages = new ArrayList();
            BaseApplication.setSessionField(ERROR_MESSAGES, errorMessages);
        }
        return errorMessages;
    }

    public static class Message
    implements Serializable {
        private Serializable myMessage;
        private Severity mySeverity;
        private String myInputName;
        private String propertyName;

        public Message(Serializable message, Severity severity, String inputName) {
            this.myMessage = message;
            this.mySeverity = severity;
            this.myInputName = inputName;
        }

        public Message(Serializable message, Severity severity, String inputName, String propertyName) {
            this(message, severity, inputName);
            this.propertyName = propertyName;
        }

        public Serializable getMessage() {
            return this.myMessage;
        }

        public Severity getSeverity() {
            return this.mySeverity;
        }

        public String getInputName() {
            return this.myInputName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static enum Severity implements Serializable
    {
        INFO("infoSeverity"),
        ERROR("errorSeverity");

        private String myStyleClass;

        private Severity(String styleClass) {
            this.myStyleClass = styleClass;
        }

        public String getStyleClass() {
            return this.myStyleClass;
        }
    }
}

