/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.http.response;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonErrorUnmarshaller;
import software.amazon.awssdk.awscore.internal.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.internal.http.JsonErrorResponseHandler;
import software.amazon.awssdk.core.internal.protocol.json.ErrorMessageParser;
import software.amazon.awssdk.core.internal.protocol.json.JsonContent;
import software.amazon.awssdk.core.internal.protocol.json.JsonErrorUnmarshaller;

@SdkInternalApi
public final class AwsJsonErrorResponseHandler
extends JsonErrorResponseHandler<AwsServiceException> {
    private final List<AwsJsonErrorUnmarshaller> unmarshallers;
    private final ErrorCodeParser errorCodeParser;
    private final ErrorMessageParser errorMessageParser;
    private final JsonFactory jsonFactory;

    public AwsJsonErrorResponseHandler(List<AwsJsonErrorUnmarshaller> errorUnmarshallers, ErrorCodeParser errorCodeParser, ErrorMessageParser errorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = errorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public AwsServiceException handle(HttpResponse response, ExecutionAttributes executionAttributes) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent((HttpResponse)response, (JsonFactory)this.jsonFactory);
        String errorCode = this.errorCodeParser.parseErrorCode(response, jsonContent);
        AwsServiceException.Builder exception = this.createException(errorCode, jsonContent).toBuilder();
        AwsErrorDetails.Builder errorDetails = AwsErrorDetails.builder().errorCode(errorCode).serviceName((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME)).sdkHttpResponse(response);
        if (jsonContent.getRawContent() != null) {
            errorDetails.rawResponse(SdkBytes.fromByteArray((byte[])jsonContent.getRawContent()));
        }
        if (exception.awsErrorDetails() == null || exception.awsErrorDetails().errorMessage() == null) {
            errorDetails.errorMessage(this.errorMessageParser.parseErrorMessage(response, jsonContent.getJsonNode()));
        }
        exception.awsErrorDetails(errorDetails.build());
        exception.statusCode(response.getStatusCode());
        exception.requestId(this.getRequestIdFromHeaders(response.getHeaders()));
        return exception.build();
    }

    private AwsServiceException createException(String errorCode, JsonContent jsonContent) {
        return this.unmarshallers.stream().filter(u -> u.matchErrorCode(errorCode)).findFirst().map(u -> (AwsServiceException)this.safeUnmarshall(jsonContent, (JsonErrorUnmarshaller)u)).orElseGet(this::createUnknownException);
    }

    protected AwsServiceException createUnknownException() {
        return AwsServiceException.builder().message("Unable to unmarshall exception response with the unmarshallers provided").build();
    }
}

