/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.ReadonlyTransaction;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0012R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/exodus/env/HubEnvironment;", "Ljetbrains/exodus/env/EnvironmentImpl;", "log", "Ljetbrains/exodus/log/Log;", "ec", "Ljetbrains/exodus/env/EnvironmentConfig;", "(Ljetbrains/exodus/log/Log;Ljetbrains/exodus/env/EnvironmentConfig;)V", "migrationInProgress", "", "beginGCTransaction", "Ljetbrains/exodus/env/ReadWriteTransaction;", "beginTransaction", "Ljetbrains/exodus/env/TransactionBase;", "beginHook", "Ljava/lang/Runnable;", "exclusive", "cloneMeta", "close", "", "endMigration", "success", "isReadOnlyDuringImport", "startMigration", "Companion", "jetbrains.jetpass.hub2hub.common"})
public final class HubEnvironment
extends EnvironmentImpl {
    private volatile boolean migrationInProgress;
    private static final String HIGH_ADDRESS_STORE_NAME = "migrationHighAddressStore";
    private static final ArrayByteIterable HIGH_ADDRESS_KEY;
    @NotNull
    private static final ThreadLocal<Boolean> MIGRATION_THREAD;
    public static final Companion Companion;

    @NotNull
    protected TransactionBase beginTransaction(@Nullable Runnable beginHook, boolean exclusive, boolean cloneMeta) {
        TransactionBase transactionBase;
        if (this.isReadOnlyDuringImport()) {
            transactionBase = (TransactionBase)new ReadonlyTransaction((EnvironmentImpl)this, exclusive, beginHook);
        } else {
            TransactionBase transactionBase2 = super.beginTransaction(beginHook, exclusive, cloneMeta);
            transactionBase = transactionBase2;
            Intrinsics.checkExpressionValueIsNotNull((Object)transactionBase2, (String)"super.beginTransaction(b\u2026ok, exclusive, cloneMeta)");
        }
        return transactionBase;
    }

    public final void startMigration() {
        this.suspendGC();
        this.migrationInProgress = true;
    }

    @NotNull
    public ReadWriteTransaction beginGCTransaction() {
        if (this.migrationInProgress) {
            throw (Throwable)new IllegalStateException("Attempt to acquire GC transaction whereas migration is in-progress.");
        }
        ReadWriteTransaction readWriteTransaction = super.beginGCTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)readWriteTransaction, (String)"super.beginGCTransaction()");
        return readWriteTransaction;
    }

    public final void endMigration(boolean success) {
        if (success) {
            this.migrationInProgress = false;
            this.resumeGC();
        }
    }

    public static /* bridge */ /* synthetic */ void endMigration$default(HubEnvironment hubEnvironment, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        hubEnvironment.endMigration(bl);
    }

    public final boolean isReadOnlyDuringImport() {
        if (Intrinsics.areEqual((Object)MIGRATION_THREAD.get(), (Object)true)) {
            return false;
        }
        return this.migrationInProgress;
    }

    public void close() {
        if (this.migrationInProgress) {
            this.migrationInProgress = false;
        }
        super.close();
    }

    public HubEnvironment(@NotNull Log log, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)ec, (String)"ec");
        super(log, ec);
    }

    static {
        Companion = new Companion(null);
        HIGH_ADDRESS_STORE_NAME = HIGH_ADDRESS_STORE_NAME;
        HIGH_ADDRESS_KEY = StringBinding.stringToEntry((String)"highAddress");
        MIGRATION_THREAD = new ThreadLocal();
    }

    @NotNull
    public static final /* synthetic */ String access$getHIGH_ADDRESS_STORE_NAME$cp() {
        return HIGH_ADDRESS_STORE_NAME;
    }

    public static final /* synthetic */ ArrayByteIterable access$getHIGH_ADDRESS_KEY$cp() {
        return HIGH_ADDRESS_KEY;
    }

    @JvmStatic
    public static final void setHighAddress(@NotNull Environment env, long highAddress2) {
        Companion.setHighAddress(env, highAddress2);
    }

    @JvmStatic
    @NotNull
    public static final HubEnvironment createEnvironment(@NotNull Log log, @NotNull EnvironmentConfig envConfig) {
        return Companion.createEnvironment(log, envConfig);
    }

    @JvmStatic
    @NotNull
    public static final HubEnvironment createEnvironment(@NotNull LogConfig logConfig, @NotNull EnvironmentConfig envConfig) {
        return Companion.createEnvironment(logConfig, envConfig);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001aH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Ljetbrains/exodus/env/HubEnvironment$Companion;", "Lmu/KLogging;", "()V", "HIGH_ADDRESS_KEY", "Ljetbrains/exodus/ArrayByteIterable;", "kotlin.jvm.PlatformType", "HIGH_ADDRESS_STORE_NAME", "", "MIGRATION_THREAD", "Ljava/lang/ThreadLocal;", "", "getMIGRATION_THREAD", "()Ljava/lang/ThreadLocal;", "clearHighAddress", "", "env", "Ljetbrains/exodus/env/Environment;", "createEnvironment", "Ljetbrains/exodus/env/HubEnvironment;", "log", "Ljetbrains/exodus/log/Log;", "envConfig", "Ljetbrains/exodus/env/EnvironmentConfig;", "logConfig", "Ljetbrains/exodus/log/LogConfig;", "loadHighAddress", "", "openStore", "Ljetbrains/exodus/env/Store;", "setHighAddress", "highAddress", "jetbrains.jetpass.hub2hub.common"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final ThreadLocal<Boolean> getMIGRATION_THREAD() {
            return MIGRATION_THREAD;
        }

        private final Store openStore(Environment env) {
            Object object = env.computeInTransaction((TransactionalComputable)new TransactionalComputable<Store>(env){
                final /* synthetic */ Environment $env;

                @NotNull
                public final Store compute(@NotNull Transaction txn) {
                    Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                    Store store = this.$env.openStore(HubEnvironment.access$getHIGH_ADDRESS_STORE_NAME$cp(), StoreConfig.WITHOUT_DUPLICATES, txn);
                    Intrinsics.checkExpressionValueIsNotNull((Object)store, (String)"env.openStore(HubEnviron\u2026.WITHOUT_DUPLICATES, txn)");
                    return store;
                }
                {
                    this.$env = environment;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"env.computeInTransaction\u2026UPLICATES, txn)\n        }");
            return (Store)object;
        }

        @JvmStatic
        public final void setHighAddress(@NotNull Environment env, long highAddress2) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            this.getLogger().warn((Function0)new Function0<String>(highAddress2){
                final /* synthetic */ long $highAddress;

                @NotNull
                public final String invoke() {
                    return "Saved high-address: " + this.$highAddress;
                }
                {
                    this.$highAddress = l;
                    super(0);
                }
            });
            Store store = Companion.openStore(env);
            env.executeInTransaction(new TransactionalExecutable(highAddress2, store){
                final /* synthetic */ long $highAddress;
                final /* synthetic */ Store $store;

                public final void execute(@NotNull Transaction txn) {
                    Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                    if (this.$highAddress <= 0L) {
                        this.$store.delete(txn, (ByteIterable)HubEnvironment.access$getHIGH_ADDRESS_KEY$cp());
                    } else {
                        this.$store.putRight(txn, (ByteIterable)HubEnvironment.access$getHIGH_ADDRESS_KEY$cp(), (ByteIterable)LongBinding.longToEntry((long)this.$highAddress));
                    }
                }
                {
                    this.$highAddress = l;
                    this.$store = store;
                }
            });
        }

        public final void clearHighAddress(@NotNull Environment env) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            this.setHighAddress(env, -1L);
        }

        public final long loadHighAddress(@NotNull Environment env) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            Store store = Companion.openStore(env);
            Long highAddress2 = (Long)env.computeInReadonlyTransaction((TransactionalComputable)new TransactionalComputable<Long>(store){
                final /* synthetic */ Store $store;

                @Nullable
                public final Long compute(@NotNull Transaction txn) {
                    Long l;
                    Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                    ByteIterable byteIterable = this.$store.get(txn, (ByteIterable)HubEnvironment.access$getHIGH_ADDRESS_KEY$cp());
                    if (byteIterable != null) {
                        ByteIterable byteIterable2;
                        ByteIterable it = byteIterable2 = byteIterable;
                        l = LongBinding.entryToLong((ByteIterable)it);
                    } else {
                        l = null;
                    }
                    return l;
                }
                {
                    this.$store = store;
                }
            });
            if (highAddress2 != null) {
                this.getLogger().warn((Function0)new Function0<String>(highAddress2){
                    final /* synthetic */ Long $highAddress;

                    @NotNull
                    public final String invoke() {
                        return "Loaded high-address: " + this.$highAddress;
                    }
                    {
                        this.$highAddress = l;
                        super(0);
                    }
                });
            }
            return highAddress2 == null ? -1L : highAddress2;
        }

        @JvmStatic
        @NotNull
        public final HubEnvironment createEnvironment(@NotNull Log log, @NotNull EnvironmentConfig envConfig) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)envConfig, (String)"envConfig");
            HubEnvironment env = new HubEnvironment(log, envConfig);
            env.getGC().getUtilizationProfile().load();
            return env;
        }

        @JvmStatic
        @NotNull
        public final HubEnvironment createEnvironment(@NotNull LogConfig logConfig, @NotNull EnvironmentConfig envConfig) {
            Intrinsics.checkParameterIsNotNull((Object)logConfig, (String)"logConfig");
            Intrinsics.checkParameterIsNotNull((Object)envConfig, (String)"envConfig");
            Log log = Environments.newLogInstance((LogConfig)logConfig, (EnvironmentConfig)envConfig);
            Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"Environments.newLogInstance(logConfig, envConfig)");
            return this.createEnvironment(log, envConfig);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

