/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.hub2hub;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.jetpass.hub2hub.ConsistencyChecker;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdEnumEntity;
import kotlinx.dnq.XdModel;
import kotlinx.dnq.link.VectorLink;
import kotlinx.dnq.link.XdLink;
import kotlinx.dnq.link.XdManyChildrenToMultiParentLink;
import kotlinx.dnq.link.XdManyChildrenToParentLink;
import kotlinx.dnq.link.XdManyToManyLink;
import kotlinx.dnq.link.XdManyToOneOptionalLink;
import kotlinx.dnq.link.XdManyToOneRequiredLink;
import kotlinx.dnq.link.XdOneChildToMultiParentLink;
import kotlinx.dnq.link.XdOneChildToParentLink;
import kotlinx.dnq.link.XdOneToManyLink;
import kotlinx.dnq.link.XdOneToOneOptionalLink;
import kotlinx.dnq.link.XdOneToOneRequiredLink;
import kotlinx.dnq.link.XdParentToManyChildrenLink;
import kotlinx.dnq.link.XdParentToOneOptionalChildLink;
import kotlinx.dnq.link.XdParentToOneRequiredChildLink;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.XdHierarchyNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J,\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J<\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00162\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J<\u0010\u001a\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J<\u0010\u001c\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J<\u0010\u001d\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\f2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u00030\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001a\u0010\u001f\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Ljetbrains/jetpass/hub2hub/ConsistencyChecker;", "Lmu/KLogging;", "()V", "check", "", "shouldThrow", "", "checkBrokenLinks", "node", "Lkotlinx/dnq/util/XdHierarchyNode;", "requiredLinks", "", "Lkotlinx/dnq/util/XdHierarchyNode$LinkProperty;", "violations", "", "", "checkNodeConsistency", "links", "isOppositeDelegateContainsLinkToThis", "thisRef", "Lkotlinx/dnq/XdEntity;", "oppositeField", "Lkotlin/reflect/KProperty1;", "oppositeDelegate", "Lkotlinx/dnq/link/XdLink;", "oppositeRef", "checkToManyLink", "link", "checkToOneOptionalLink", "checkToOneRequiredLink", "getLinkName", "reportInconsistency", "message", "jetbrains.jetpass.hub2hub.common"})
public final class ConsistencyChecker
extends KLogging {
    public static final ConsistencyChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void check(boolean shouldThrow) {
        Object nodeLinks2;
        Object it;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        List violations = new ArrayList();
        this.getLogger().debug((Function0)check.1.INSTANCE);
        List ignoredTypes = CollectionsKt.listOf((Object)XdEnumEntity.Companion);
        Collection collection = XdModel.INSTANCE.getHierarchy().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"XdModel.hierarchy.values");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (XdHierarchyNode)element$iv$iv;
            Class<?> clazz = it.getEntityType().getClass().getEnclosingClass();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"it.entityType.javaClass.enclosingClass");
            if (!(!Modifier.isAbstract(clazz.getModifiers()) && !CollectionsKt.contains((Iterable)ignoredTypes, (Object)it.getEntityType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            XdHierarchyNode.LinkProperty it2;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv2;
            XdHierarchyNode node = (XdHierarchyNode)element$iv;
            nodeLinks2 = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Object)node, (Function1)check.3.nodeLinks.1.INSTANCE), (Function1)check.3.nodeLinks.2.INSTANCE));
            XdHierarchyNode xdHierarchyNode = node;
            Intrinsics.checkExpressionValueIsNotNull((Object)xdHierarchyNode, (String)"node");
            it = (Iterable)nodeLinks2;
            XdHierarchyNode $i$a$2$filter = xdHierarchyNode;
            ConsistencyChecker $i$f$filterTo = INSTANCE;
            void $i$f$filter = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                it2 = (XdHierarchyNode.LinkProperty)element$iv$iv;
                if (!SetsKt.setOf((Object[])new AssociationEndCardinality[]{AssociationEndCardinality._1, AssociationEndCardinality._1_n}).contains(it2.getDelegate().getCardinality())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            $i$f$filterTo.checkBrokenLinks($i$a$2$filter, list, violations);
            $receiver$iv2 = (Iterable)nodeLinks2;
            $i$a$2$filter = node;
            $i$f$filterTo = INSTANCE;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                it2 = (XdHierarchyNode.LinkProperty)element$iv$iv;
                if (!(it2.getDelegate().getOppositeField() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
            $i$f$filterTo.checkNodeConsistency($i$a$2$filter, list, violations);
        }
        $receiver$iv = violations;
        if (!$receiver$iv.isEmpty() && shouldThrow) {
            StringBuilder stringBuilder;
            Object object;
            Object object2;
            Iterable list$iv$iv;
            Object value$iv$iv$iv;
            Object $receiver$iv$iv3;
            Object element$iv;
            Object $receiver$iv3 = violations;
            element$iv = $receiver$iv3;
            Map destination$iv$iv3 = new LinkedHashMap();
            nodeLinks2 = $receiver$iv$iv3.iterator();
            while (nodeLinks2.hasNext()) {
                Object object3;
                Map $receiver$iv$iv$iv = destination$iv$iv3;
                Object element$iv$iv = nodeLinks2.next();
                String it3 = (String)element$iv$iv;
                String key$iv$iv = StringsKt.substringBefore$default((String)it3, (String)":", null, (int)2, null);
                value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            $receiver$iv$iv3 = $receiver$iv3 = (Map)MapsKt.toSortedMap((Map)destination$iv$iv3);
            destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv3.size()));
            Object $receiver$iv$iv$iv = $receiver$iv$iv3.entrySet();
            Object object4 = $receiver$iv$iv$iv.iterator();
            while (object4.hasNext()) {
                void $receiver$iv$iv4;
                void it4;
                void it$iv$iv;
                Object element$iv$iv$iv = object4.next();
                Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
                object2 = destination$iv$iv3;
                object = it$iv$iv.getKey();
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = object;
                Map map = object2;
                Object v = it4.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                Iterable $receiver$iv4 = (Iterable)v;
                list$iv$iv = $receiver$iv4;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv4) {
                    void it5;
                    String $i$f$filter = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv4;
                    String string = StringsKt.substringAfter$default((String)it5, (String)":", null, (int)2, null);
                    collection2.add(string);
                }
                List list = CollectionsKt.sorted((Iterable)((List)destination$iv$iv4));
                map.put(k, list);
            }
            Map grouped = destination$iv$iv3;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            $receiver$iv$iv$iv = $receiver;
            object4 = "Found " + grouped.size() + " consistency violations over properties:";
            StringBuilder stringBuilder2 = ((StringBuilder)$receiver$iv$iv$iv).append((String)object4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Iterable $receiver$iv5 = grouped.keySet();
            for (Object element$iv2 : $receiver$iv5) {
                String it6 = (String)element$iv2;
                object2 = $receiver;
                StringBuilder stringBuilder3 = new StringBuilder().append('\t');
                String string = it6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                object = stringBuilder3.append(StringsKt.trim((String)string, (char[])new char[]{'[', ']'})).toString();
                StringBuilder stringBuilder4 = ((StringBuilder)object2).append((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
            }
            StringBuilder stringBuilder5 = $receiver;
            object4 = "Found " + violations.size() + " violations in total:";
            StringBuilder stringBuilder6 = stringBuilder5.append((String)object4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
            grouped.forEach((BiConsumer)new BiConsumer<String, List<? extends String>>($receiver){
                final /* synthetic */ StringBuilder receiver$0;

                public final void accept(String key, @NotNull List<String> violations) {
                    Intrinsics.checkParameterIsNotNull(violations, (String)"violations");
                    StringBuilder stringBuilder = this.receiver$0;
                    String string = key + " (" + violations.size() + "):";
                    StringBuilder stringBuilder2 = stringBuilder.append(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                    Iterable $receiver$iv = violations;
                    for (E element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        StringBuilder stringBuilder3 = this.receiver$0;
                        String string2 = '\t' + it;
                        StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                        StringsKt.appendln((StringBuilder)stringBuilder4);
                    }
                }
                {
                    this.receiver$0 = stringBuilder;
                }
            });
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String output2 = string;
            throw (Throwable)((Object)new AssertionError((Object)("Consistency violations discovered!\n" + output2)));
        }
        if (violations.isEmpty()) {
            this.getLogger().info((Function0)check.4.INSTANCE);
        }
    }

    public static /* bridge */ /* synthetic */ void check$default(ConsistencyChecker consistencyChecker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        consistencyChecker.check(bl);
    }

    private final void checkBrokenLinks(XdHierarchyNode node, List<XdHierarchyNode.LinkProperty> requiredLinks, List<String> violations) {
        this.getLogger().debug((Function0)new Function0<String>(node, requiredLinks){
            final /* synthetic */ XdHierarchyNode $node;
            final /* synthetic */ List $requiredLinks;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void var3_4;
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = this.$requiredLinks;
                StringBuilder stringBuilder = new StringBuilder().append("Broken required links check for ").append(this.$node.getEntityType().getEntityType());
                void var2_3 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    XdHierarchyNode.LinkProperty linkProperty = (XdHierarchyNode.LinkProperty)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getProperty().getName();
                    collection.add(string);
                }
                collection = (List)var3_4;
                return stringBuilder.append(collection).toString();
            }
            {
                this.$node = xdHierarchyNode;
                this.$requiredLinks = list;
                super(0);
            }
        });
        XdEntityType entityType = node.getEntityType();
        QueryEngine queryEngine = entityType.getEntityStore().getQueryEngine();
        Iterable $receiver$iv = requiredLinks;
        for (Object element$iv : $receiver$iv) {
            TreeKeepingEntityIterable entities;
            XdHierarchyNode.LinkProperty link = (XdHierarchyNode.LinkProperty)element$iv;
            TreeKeepingEntityIterable treeKeepingEntityIterable = entities = queryEngine.query(entityType.getEntityType(), (NodeBase)new LinkEqual(link.getDbPropertyName(), null));
            Intrinsics.checkExpressionValueIsNotNull((Object)treeKeepingEntityIterable, (String)"entities");
            int count = CollectionsKt.count((Iterable)((Iterable)treeKeepingEntityIterable));
            if (count <= 0) continue;
            INSTANCE.reportInconsistency(violations, "Property " + entityType.getEntityType() + "::" + link.getDbPropertyName() + " is required but there are " + count + " null values");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNodeConsistency(XdHierarchyNode node, List<XdHierarchyNode.LinkProperty> links, List<String> violations) {
        this.getLogger().debug((Function0)new Function0<String>(node, links){
            final /* synthetic */ XdHierarchyNode $node;
            final /* synthetic */ List $links;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void var3_4;
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = this.$links;
                StringBuilder stringBuilder = new StringBuilder().append("Consistency check for ").append(this.$node.getEntityType().getEntityType());
                void var2_3 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    XdHierarchyNode.LinkProperty linkProperty = (XdHierarchyNode.LinkProperty)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getProperty().getName();
                    collection.add(string);
                }
                collection = (List)var3_4;
                return stringBuilder.append(collection).toString();
            }
            {
                this.$node = xdHierarchyNode;
                this.$links = list;
                super(0);
            }
        });
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)node.getEntityType().all());
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterator oppositeField;
            Object element$iv22;
            XdEntity xd = (XdEntity)element$iv;
            Iterable $receiver$iv2 = links;
            for (Object element$iv22 : $receiver$iv2) {
                XdHierarchyNode.LinkProperty link = (XdHierarchyNode.LinkProperty)element$iv22;
                if (link.getDelegate().getOppositeField() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KProperty1<kotlinx.dnq.XdEntity, *>");
                }
                XdLink xdLink = link.getDelegate();
                if (xdLink instanceof XdManyToManyLink || xdLink instanceof XdParentToManyChildrenLink || xdLink instanceof XdOneToManyLink) {
                    INSTANCE.checkToManyLink(xd, node, link, (KProperty1<XdEntity, ?>)oppositeField, violations);
                    continue;
                }
                if (xdLink instanceof XdManyToOneRequiredLink || xdLink instanceof XdOneChildToParentLink || xdLink instanceof XdOneToOneRequiredLink || xdLink instanceof XdParentToOneRequiredChildLink || xdLink instanceof XdManyChildrenToParentLink) {
                    INSTANCE.checkToOneRequiredLink(xd, node, link, (KProperty1<XdEntity, ?>)oppositeField, violations);
                    continue;
                }
                if (!(xdLink instanceof XdManyToOneOptionalLink) && !(xdLink instanceof XdManyChildrenToMultiParentLink) && !(xdLink instanceof XdParentToOneOptionalChildLink) && !(xdLink instanceof XdOneToOneOptionalLink) && !(xdLink instanceof XdOneChildToMultiParentLink)) continue;
                INSTANCE.checkToOneOptionalLink(xd, node, link, (KProperty1<XdEntity, ?>)oppositeField, violations);
            }
            Iterable $receiver$iv3 = links;
            element$iv22 = $receiver$iv3;
            Iterable destination$iv$iv = new ArrayList();
            oppositeField = $receiver$iv$iv2.iterator();
            while (oppositeField.hasNext()) {
                Object element$iv$iv = oppositeField.next();
                XdHierarchyNode.LinkProperty it = (XdHierarchyNode.LinkProperty)element$iv$iv;
                if (!(it.getDelegate() instanceof XdManyChildrenToMultiParentLink || it.getDelegate() instanceof XdOneChildToMultiParentLink)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List multiParentLinks = (List)destination$iv$iv;
            $receiver$iv3 = multiParentLinks;
            if (!(!$receiver$iv3.isEmpty())) continue;
            Iterable $receiver$iv4 = multiParentLinks;
            destination$iv$iv = $receiver$iv4;
            Collection destination$iv$iv2 = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                XdEntity xdEntity;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                XdHierarchyNode.LinkProperty it = (XdHierarchyNode.LinkProperty)element$iv$iv;
                XdLink xdLink = it.getDelegate();
                if (xdLink == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.properties.ReadWriteProperty<kotlinx.dnq.XdEntity, kotlinx.dnq.XdEntity?>");
                }
                if ((XdEntity)((ReadWriteProperty)xdLink).getValue((Object)xd, (KProperty)it.getProperty()) == null) continue;
                XdEntity it$iv$iv = xdEntity;
                destination$iv$iv2.add(it$iv$iv);
            }
            List parents = (List)destination$iv$iv2;
            if (parents.size() == 1) continue;
            INSTANCE.reportInconsistency(violations, "" + '[' + xd.getEntityId() + "] is supposed to have a single parent but has " + parents);
        }
    }

    private final String getLinkName(@NotNull XdHierarchyNode $receiver, XdHierarchyNode.LinkProperty link) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = $receiver.getEntityType().getClass().getEnclosingClass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"entityType.javaClass.enclosingClass");
        return stringBuilder.append(clazz.getSimpleName()).append('.').append(link.getProperty().getName()).toString();
    }

    private final void checkToManyLink(@NotNull XdEntity $receiver, XdHierarchyNode node, XdHierarchyNode.LinkProperty link, KProperty1<XdEntity, ?> oppositeField, List<String> violations) {
        XdLink xdLink = link.getDelegate();
        if (xdLink == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.properties.ReadOnlyProperty<kotlinx.dnq.XdEntity, kotlinx.dnq.query.XdMutableQuery<kotlinx.dnq.XdEntity>>");
        }
        XdMutableQuery oppositeEntities = (XdMutableQuery)((ReadOnlyProperty)xdLink).getValue((Object)$receiver, (KProperty)link.getProperty());
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)oppositeEntities));
        for (Object element$iv : $receiver$iv) {
            XdEntity oppXd = (XdEntity)element$iv;
            Object object = oppositeField.getDelegate((Object)oppXd);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.dnq.link.XdLink<kotlinx.dnq.XdEntity, *>");
            }
            XdLink oppositeDelegate = (XdLink)object;
            if (INSTANCE.isOppositeDelegateContainsLinkToThis($receiver, oppositeField, oppositeDelegate, oppXd)) continue;
            INSTANCE.reportInconsistency(violations, '[' + INSTANCE.getLinkName(node, link) + "]: link of [" + $receiver.getEntity() + "] is set but the opposite end of [" + oppXd.getEntity() + "] is empty");
        }
    }

    private final void checkToOneRequiredLink(@NotNull XdEntity $receiver, XdHierarchyNode node, XdHierarchyNode.LinkProperty link, KProperty1<XdEntity, ?> oppositeField, List<String> violations) {
        XdLink xdLink = link.getDelegate();
        if (xdLink == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.dnq.link.XdLink<kotlinx.dnq.XdEntity, *>");
        }
        if (xdLink.isDefined((Object)$receiver, (KProperty)link.getProperty())) {
            XdLink xdLink2 = link.getDelegate();
            if (xdLink2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.properties.ReadWriteProperty<kotlinx.dnq.XdEntity, kotlinx.dnq.XdEntity?>");
            }
            XdEntity oppXd = (XdEntity)((ReadWriteProperty)xdLink2).getValue((Object)$receiver, (KProperty)link.getProperty());
            if (oppXd != null) {
                Object object = oppositeField.getDelegate((Object)oppXd);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.dnq.link.XdLink<kotlinx.dnq.XdEntity, *>");
                }
                XdLink oppositeDelegate = (XdLink)object;
                if (!this.isOppositeDelegateContainsLinkToThis($receiver, oppositeField, oppositeDelegate, oppXd)) {
                    this.reportInconsistency(violations, '[' + this.getLinkName(node, link) + "]: link of [" + $receiver.getEntity() + "] is set but the opposite end of [" + oppXd.getEntity() + "] is empty");
                }
            }
        } else {
            this.reportInconsistency(violations, '[' + this.getLinkName(node, link) + "]: required link of [" + $receiver.getEntity() + "] is empty");
        }
    }

    private final void checkToOneOptionalLink(@NotNull XdEntity $receiver, XdHierarchyNode node, XdHierarchyNode.LinkProperty link, KProperty1<XdEntity, ?> oppositeField, List<String> violations) {
        XdLink xdLink = link.getDelegate();
        if (xdLink == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.properties.ReadWriteProperty<kotlinx.dnq.XdEntity, kotlinx.dnq.XdEntity?>");
        }
        XdEntity oppXd = (XdEntity)((ReadWriteProperty)xdLink).getValue((Object)$receiver, (KProperty)link.getProperty());
        if (oppXd != null) {
            Object object = oppositeField.getDelegate((Object)oppXd);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.dnq.link.XdLink<kotlinx.dnq.XdEntity, *>");
            }
            XdLink oppositeDelegate = (XdLink)object;
            if (!this.isOppositeDelegateContainsLinkToThis($receiver, oppositeField, oppositeDelegate, oppXd)) {
                this.reportInconsistency(violations, '[' + this.getLinkName(node, link) + "]: link of [" + $receiver.getEntity() + "] is set but the opposite end of [" + oppXd.getEntity() + "] is empty");
            }
        }
    }

    private final boolean isOppositeDelegateContainsLinkToThis(XdEntity thisRef, KProperty1<XdEntity, ?> oppositeField, XdLink<? super XdEntity, ?> oppositeDelegate, XdEntity oppositeRef) {
        boolean bl;
        if (!oppositeDelegate.isDefined((Object)oppositeRef, (KProperty)oppositeField)) {
            bl = false;
        } else if (oppositeDelegate instanceof VectorLink) {
            XdMutableQuery values = (XdMutableQuery)((VectorLink)oppositeDelegate).getValue((Object)oppositeRef, (KProperty)oppositeField);
            bl = XdQueryKt.contains((XdQuery)((XdQuery)values), (XdEntity)thisRef);
        } else {
            XdLink<? super XdEntity, ?> xdLink = oppositeDelegate;
            if (xdLink == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.properties.ReadWriteProperty<kotlinx.dnq.XdEntity, *>");
            }
            bl = Intrinsics.areEqual((Object)((ReadWriteProperty)xdLink).getValue((Object)oppositeRef, (KProperty)oppositeField), (Object)thisRef);
        }
        return bl;
    }

    private final void reportInconsistency(@NotNull List<String> $receiver, String message) {
        this.getLogger().error((Function0)new Function0<String>(message){
            final /* synthetic */ String $message;

            @NotNull
            public final String invoke() {
                return this.$message;
            }
            {
                this.$message = string;
                super(0);
            }
        });
        $receiver.add(message);
    }

    private ConsistencyChecker() {
    }

    static {
        ConsistencyChecker consistencyChecker;
        INSTANCE = consistencyChecker = new ConsistencyChecker();
    }
}

