/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.eclipse.jetty.alpn.ALPN;
import sun.security.ssl.ALPNExtension;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SSLTransport;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureAndHashAlgorithm;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;
    private static final boolean enableSNIExtension = Debug.getBooleanProperty((String)"jsse.enableSNIExtension", (boolean)true);
    private static final boolean allowUnsafeServerCertChange = Debug.getBooleanProperty((String)"jdk.tls.allowUnsafeServerCertChange", (boolean)false);
    private List<SNIServerName> requestedServerNames = Collections.emptyList();
    private boolean serverNamesAccepted = false;
    private X509Certificate[] reservedServerCerts = null;

    ClientHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(socket, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    ClientHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(engine, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    void processMessage(byte type, int messageLen) throws IOException {
        if (this.state >= type && type != 0) {
            throw new SSLProtocolException("Handshake message sequence violation, " + type);
        }
        block4 : switch (type) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, messageLen));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA_EXPORT: {
                        if (this.serverKey == null) {
                            throw new SSLProtocolException("Server did not send certificate message");
                        }
                        if (!(this.serverKey instanceof RSAPublicKey)) {
                            throw new SSLProtocolException("Protocol violation: the certificate type must be appropriate for the selected cipher suite's key exchange algorithm");
                        }
                        if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                            throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange) + " when the public key in the server certificate" + " is less than or equal to 512 bits in length");
                        }
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException((String)"Server key", (Throwable)e);
                        }
                        break block4;
                    }
                    case K_DH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException((String)"Server key", (Throwable)e);
                        }
                        break block4;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, messageLen, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException((String)"Server key", (Throwable)e);
                        }
                        break block4;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.localSupportedSignAlgs, this.protocolVersion));
                        }
                        catch (GeneralSecurityException e) {
                            ClientHandshaker.throwSSLException((String)"Server key", (Throwable)e);
                        }
                        break block4;
                    }
                    case K_RSA: 
                    case K_DH_RSA: 
                    case K_DH_DSS: 
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchangemessage for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input, this.protocolVersion);
                if (debug != null && Debug.isOn((String)"handshake")) {
                    this.certRequest.print(System.out);
                }
                if (this.protocolVersion.v < ProtocolVersion.TLS12.v) break;
                Collection peerSignAlgs = this.certRequest.getSignAlgorithms();
                if (peerSignAlgs == null || peerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No peer supported signature algorithms");
                }
                Collection supportedPeerSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms((Collection)peerSignAlgs);
                if (supportedPeerSignAlgs.isEmpty()) {
                    throw new SSLHandshakeException("No supported signature and hash algorithm in common");
                }
                this.setPeerSupportedSignAlgs(supportedPeerSignAlgs);
                this.session.setPeerSupportedSignatureAlgorithms(supportedPeerSignAlgs);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                if (!this.receivedChangeCipherSpec()) {
                    this.fatalSE((byte)40, "Received Finished message before ChangeCipherSpec");
                }
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + type);
            }
        }
        if (this.state < type) {
            this.state = type;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (this.state < 1) {
            if (!this.secureRenegotiation && !allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                } else {
                    this.fatalSE((byte)40, "Renegotiation is not allowed");
                }
            } else {
                if (!this.secureRenegotiation && debug != null && Debug.isOn((String)"handshake")) {
                    System.out.println("Warning: continue with insecure renegotiation");
                }
                this.kickstart();
            }
        }
    }

    private void serverHello(HandshakeMessage.ServerHello mesg) throws IOException {
        ProtocolVersion mesgVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!this.isNegotiable(mesgVersion = mesg.protocolVersion)) {
            throw new SSLHandshakeException("Server chose " + (Object)((Object)mesgVersion) + ", but that protocol version is not enabled or not supported " + "by the client.");
        }
        this.handshakeHash.protocolDetermined(mesgVersion);
        this.setVersion(mesgVersion);
        RenegotiationInfoExtension serverHelloRI = (RenegotiationInfoExtension)mesg.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (serverHelloRI != null) {
            if (this.isInitialHandshake) {
                if (!serverHelloRI.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "Unexpected renegotiation indication extension");
                }
                byte[] verifyData = new byte[this.clientVerifyData.length + this.serverVerifyData.length];
                System.arraycopy(this.clientVerifyData, 0, verifyData, 0, this.clientVerifyData.length);
                System.arraycopy(this.serverVerifyData, 0, verifyData, this.clientVerifyData.length, this.serverVerifyData.length);
                if (!MessageDigest.isEqual(verifyData, serverHelloRI.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (this.isInitialHandshake) {
            if (!allowLegacyHelloMessages) {
                this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            this.secureRenegotiation = false;
            if (debug != null && Debug.isOn((String)"handshake")) {
                System.out.println("Warning: No renegotiation indication extension in ServerHello");
            }
        } else if (this.secureRenegotiation) {
            this.fatalSE((byte)40, "No renegotiation indication extension");
        }
        this.svr_random = mesg.svr_random;
        if (!this.isNegotiable(mesg.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected improper ciphersuite " + (Object)((Object)mesg.cipherSuite));
        }
        this.setCipherSuite(mesg.cipherSuite);
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.getPRFHashAlg());
        }
        if (mesg.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + mesg.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(mesg.sessionId)) {
                CipherSuite sessionSuite = this.session.getSuite();
                if (this.cipherSuite != sessionSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion sessionVersion = this.session.getProtocolVersion();
                if (this.protocolVersion != sessionVersion) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || sessionSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    Principal localPrincipal;
                    block38: {
                        localPrincipal = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Helper.getClientSubject((AccessControlContext)ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            subject = null;
                            if (debug == null || !Debug.isOn((String)"session")) break block38;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<Principal> principals = subject.getPrincipals(Principal.class);
                        if (!principals.contains(localPrincipal)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn((String)"session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn((String)"session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
            } else {
                this.session.invalidate();
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation is disabled");
                }
            }
        }
        if (this.resumingSession && this.session != null) {
            this.setHandshakeSessionSE(this.session);
            if (this.isInitialHandshake) {
                this.session.setAsSessionResumption(true);
                this.alpnSelected(mesg);
            }
            return;
        }
        for (HelloExtension ext : mesg.extensions.list()) {
            ExtensionType type = ext.type;
            if (type == ExtensionType.EXT_SERVER_NAME) {
                this.serverNamesAccepted = true;
                continue;
            }
            if (type == ExtensionType.EXT_ELLIPTIC_CURVES || type == ExtensionType.EXT_EC_POINT_FORMATS || type == ExtensionType.EXT_SERVER_NAME || type == ExtensionType.EXT_ALPN || type == ExtensionType.EXT_RENEGOTIATION_INFO) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + type);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.getLocalSupportedSignAlgs(), mesg.sessionId, this.getHostSE(), this.getPortSE());
        this.session.setRequestedServerNames(this.requestedServerNames);
        this.setHandshakeSessionSE(this.session);
        if (debug != null && Debug.isOn((String)"handshake")) {
            System.out.println("** " + (Object)((Object)this.cipherSuite));
        }
        if (this.isInitialHandshake) {
            this.alpnSelected(mesg);
        }
    }

    private void alpnSelected(HandshakeMessage.ServerHello mesg) throws IOException {
        SSLTransport ssl;
        ALPN.ClientProvider provider = (ALPN.ClientProvider)(this.conn != null ? ALPN.get(this.conn) : ALPN.get(this.engine));
        SSLTransport sSLTransport = ssl = this.conn != null ? this.conn : this.engine;
        if (provider != null) {
            ALPNExtension extension = (ALPNExtension)mesg.extensions.get(ExtensionType.EXT_ALPN);
            if (extension != null) {
                List<String> protocols = extension.getProtocols();
                try {
                    String protocol;
                    String string = protocol = protocols == null || protocols.isEmpty() ? null : protocols.get(0);
                    if (ALPN.debug) {
                        System.err.println("[C] ALPN protocol '" + protocol + "' selected by server for " + ssl);
                    }
                    provider.selected(protocol);
                }
                catch (Throwable x) {
                    this.fatalSE((byte)120, "Could not negotiate application protocol", x);
                }
            } else {
                if (ALPN.debug) {
                    System.err.println("[C] ALPN not supported by server for " + ssl);
                }
                provider.unsupported();
            }
        } else if (ALPN.debug) {
            System.err.println("[C] ALPN client provider not present for " + ssl);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange mesg) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!mesg.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = mesg.getPublicKey();
        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), this.ephemeralServerKey)) {
            throw new SSLHandshakeException("RSA ServerKeyExchange does not comply to algorithm constraints");
        }
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        this.dh = new DHCrypt(mesg.getModulus(), mesg.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = mesg.getServerPublicKey();
        this.dh.checkConstraints(this.algorithmConstraints, this.serverDH);
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange mesg) throws IOException {
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        ECPublicKey key = mesg.getPublicKey();
        this.ecdh = new ECDHCrypt(key.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = key;
        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), this.ephemeralServerKey)) {
            throw new SSLHandshakeException("ECDH ServerKeyExchange does not comply to algorithm constraints");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void serverHelloDone(HandshakeMessage.ServerHelloDone mesg) throws IOException {
        if (ClientHandshaker.debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        this.input.digestNow();
        signingKey = null;
        if (this.certRequest != null) {
            km = this.sslContext.getX509KeyManager();
            keytypesTmp = new ArrayList<String>(4);
            for (i = 0; i < this.certRequest.types.length; ++i) {
                switch (this.certRequest.types[i]) {
                    case 1: {
                        typeName = "RSA";
                        break;
                    }
                    case 2: {
                        typeName = "DSA";
                        break;
                    }
                    case 64: {
                        typeName = JsseJce.isEcAvailable() != false ? "EC" : null;
                        break;
                    }
                    default: {
                        typeName = null;
                    }
                }
                if (typeName == null || keytypesTmp.contains(typeName)) continue;
                keytypesTmp.add(typeName);
            }
            alias = null;
            keytypesTmpSize = keytypesTmp.size();
            if (keytypesTmpSize != 0) {
                keytypes = keytypesTmp.toArray(new String[keytypesTmpSize]);
                alias = this.conn != null ? km.chooseClientAlias(keytypes, this.certRequest.getAuthorities(), this.conn) : km.chooseEngineClientAlias(keytypes, this.certRequest.getAuthorities(), this.engine);
            }
            m1 = null;
            if (alias != null && (certs = km.getCertificateChain(alias)) != null && certs.length != 0) {
                publicKey = certs[0].getPublicKey();
                if (publicKey instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported((int)(index = SupportedEllipticCurvesExtension.getCurveIndex((ECParameterSpec)(params = ((ECPublicKey)publicKey).getParams()))))) {
                    publicKey = null;
                }
                if (publicKey != null) {
                    m1 = new HandshakeMessage.CertificateMsg(certs);
                    signingKey = km.getPrivateKey(alias);
                    this.session.setLocalPrivateKey((PrivateKey)signingKey);
                    this.session.setLocalCertificates(certs);
                }
            }
            if (m1 == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    m1 = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
                if (ClientHandshaker.debug != null && Debug.isOn((String)"handshake")) {
                    System.out.println("Warning: no suitable certificate found - continuing without client authentication");
                }
            }
            if (m1 != null) {
                if (ClientHandshaker.debug != null && Debug.isOn((String)"handshake")) {
                    m1.print(System.out);
                }
                m1.write(this.output);
            }
        }
        switch (2.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[this.keyExchange.ordinal()]) {
            case 1: 
            case 8: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof RSAPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an RSA key");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_RSA) {
                    key = this.serverKey;
                } else if (JsseJce.getRSAKeyLength(this.serverKey) <= 512) {
                    key = this.serverKey;
                } else {
                    if (this.ephemeralServerKey == null) {
                        throw new SSLProtocolException("Server did not send a RSA_EXPORT Server Key Exchange message");
                    }
                    key = this.ephemeralServerKey;
                }
                m2 = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), key);
                break;
            }
            case 9: 
            case 10: {
                m2 = new DHClientKeyExchange();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                m2 = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case 11: 
            case 12: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                params = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt(params, this.sslContext.getSecureRandom());
                m2 = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case 13: 
            case 14: {
                sniHostname = null;
                for (SNIServerName serverName : this.requestedServerNames) {
                    if (!(serverName instanceof SNIHostName)) continue;
                    sniHostname = ((SNIHostName)serverName).getAsciiName();
                    break;
                }
                kerberosMsg = null;
                if (sniHostname == null) ** GOTO lbl106
                try {
                    kerberosMsg = new KerberosClientKeyExchange(sniHostname, this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                }
                catch (IOException e) {
                    if (this.serverNamesAccepted) {
                        throw e;
                    }
                    if (ClientHandshaker.debug == null || !Debug.isOn((String)"handshake")) ** GOTO lbl106
                    System.out.println("Warning, cannot use Server Name Indication: " + e.getMessage());
                }
lbl106:
                // 4 sources

                if (kerberosMsg == null) {
                    hostname = this.getHostSE();
                    if (hostname == null) {
                        throw new IOException("Hostname is required to use Kerberos cipher suites");
                    }
                    kerberosMsg = new KerberosClientKeyExchange(hostname, this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                }
                this.session.setPeerPrincipal(kerberosMsg.getPeerPrincipal());
                this.session.setLocalPrincipal(kerberosMsg.getLocalPrincipal());
                m2 = kerberosMsg;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)this.keyExchange);
            }
        }
        if (ClientHandshaker.debug != null && Debug.isOn((String)"handshake")) {
            m2.print(System.out);
        }
        m2.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (2.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[this.keyExchange.ordinal()]) {
            case 1: 
            case 8: {
                preMasterSecret = ((RSAClientKeyExchange)m2).preMaster;
                break;
            }
            case 13: 
            case 14: {
                secretBytes = ((KerberosClientKeyExchange)m2).getUnencryptedPreMasterSecret();
                preMasterSecret = new SecretKeySpec(secretBytes, "TlsPremasterSecret");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                preMasterSecret = this.dh.getAgreedSecret(this.serverDH, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case 11: 
            case 12: {
                preMasterSecret = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)this.keyExchange);
            }
        }
        this.calculateKeys(preMasterSecret, null);
        if (signingKey != null) {
            try {
                preferableSignatureAlgorithm = null;
                if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    preferableSignatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm((Collection)this.peerSupportedSignAlgs, (String)signingKey.getAlgorithm(), (PrivateKey)signingKey);
                    if (preferableSignatureAlgorithm == null) {
                        throw new SSLHandshakeException("No supported signature algorithm");
                    }
                    hashAlg = SignatureAndHashAlgorithm.getHashAlgorithmName((SignatureAndHashAlgorithm)preferableSignatureAlgorithm);
                    if (hashAlg == null || hashAlg.length() == 0) {
                        throw new SSLHandshakeException("No supported hash algorithm");
                    }
                }
                m3 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, (PrivateKey)signingKey, this.session.getMasterSecret(), this.sslContext.getSecureRandom(), preferableSignatureAlgorithm);
            }
            catch (GeneralSecurityException e) {
                this.fatalSE((byte)40, "Error signing certificate verify", e);
                m3 = null;
            }
            if (ClientHandshaker.debug != null && Debug.isOn((String)"handshake")) {
                m3.print(System.out);
            }
            m3.write(this.output);
            this.output.doHashes();
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished mesg) throws IOException {
        boolean verified;
        if (debug != null && Debug.isOn((String)"handshake")) {
            mesg.print(System.out);
        }
        if (!(verified = mesg.verify(this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.serverVerifyData = mesg.getVerifyData();
        }
        if (!this.isInitialHandshake) {
            this.session.setAsSessionResumption(false);
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn((String)"session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean finishedTag) throws IOException {
        HandshakeMessage.Finished mesg = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(mesg, finishedTag);
        if (this.secureRenegotiation) {
            this.clientVerifyData = mesg.getVerifyData();
        }
        this.state = 19;
    }

    HandshakeMessage getKickstartMessage() throws SSLException {
        SessionId sessionId = SSLSessionImpl.nullSession.getSessionId();
        CipherSuiteList cipherSuites = this.getActiveCipherSuites();
        this.maxProtocolVersion = this.protocolVersion;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn((String)"session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null) {
            if (!allowUnsafeServerCertChange && this.session.isSessionResumption()) {
                try {
                    this.reservedServerCerts = (X509Certificate[])this.session.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            if (!this.session.isRejoinable()) {
                this.session = null;
            }
        }
        if (this.session != null) {
            CipherSuite sessionSuite = this.session.getSuite();
            ProtocolVersion sessionVersion = this.session.getProtocolVersion();
            if (!this.isNegotiable(sessionSuite)) {
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% can't resume, unavailable cipher");
                }
                this.session = null;
            }
            if (this.session != null && !this.isNegotiable(sessionVersion)) {
                if (debug != null && Debug.isOn((String)"session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn((String)"handshake") || Debug.isOn((String)"session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                sessionId = this.session.getSessionId();
                this.maxProtocolVersion = sessionVersion;
                this.setVersion(sessionVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLHandshakeException("Can't reuse existing SSL client session");
                }
                ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(2);
                cipherList.add(sessionSuite);
                if (!this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
                    cipherList.add(CipherSuite.C_SCSV);
                }
                cipherSuites = new CipherSuiteList(cipherList);
            }
        }
        if (this.session == null && !this.enableNewSession) {
            throw new SSLHandshakeException("No existing session to resume");
        }
        if (this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
            ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(cipherSuites.size() - 1);
            for (CipherSuite suite : cipherSuites.collection()) {
                if (suite == CipherSuite.C_SCSV) continue;
                cipherList.add(suite);
            }
            cipherSuites = new CipherSuiteList(cipherList);
        }
        boolean negotiable = false;
        for (CipherSuite suite : cipherSuites.collection()) {
            if (!this.isNegotiable(suite)) continue;
            negotiable = true;
            break;
        }
        if (!negotiable) {
            throw new SSLHandshakeException("No negotiable cipher suite");
        }
        HandshakeMessage.ClientHello clientHelloMessage = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.maxProtocolVersion, sessionId, cipherSuites);
        if (this.maxProtocolVersion.v >= ProtocolVersion.TLS12.v) {
            Collection localSignAlgs = this.getLocalSupportedSignAlgs();
            if (localSignAlgs.isEmpty()) {
                throw new SSLHandshakeException("No supported signature algorithm");
            }
            clientHelloMessage.addSignatureAlgorithmsExtension(localSignAlgs);
        }
        if (enableSNIExtension) {
            this.requestedServerNames = this.session != null ? this.session.getRequestedServerNames() : this.serverNames;
            if (!this.requestedServerNames.isEmpty()) {
                clientHelloMessage.addSNIExtension(this.requestedServerNames);
            }
        }
        this.clnt_random = clientHelloMessage.clnt_random;
        if (this.secureRenegotiation || !cipherSuites.contains(CipherSuite.C_SCSV)) {
            clientHelloMessage.addRenegotiationInfoExtension(this.clientVerifyData);
        }
        if (this.isInitialHandshake) {
            SSLTransport ssl;
            ALPN.ClientProvider provider = (ALPN.ClientProvider)(this.conn != null ? ALPN.get(this.conn) : ALPN.get(this.engine));
            SSLTransport sSLTransport = ssl = this.conn != null ? this.conn : this.engine;
            if (provider != null) {
                List<String> protocols = provider.protocols();
                if (protocols != null && !protocols.isEmpty()) {
                    if (ALPN.debug) {
                        System.err.println("[C] ALPN protocols " + protocols + " for " + ssl);
                    }
                    clientHelloMessage.extensions.add(new ALPNExtension(protocols));
                } else if (ALPN.debug) {
                    System.err.println("[C] ALPN not supported, no protocols for " + ssl);
                }
            } else if (ALPN.debug) {
                System.err.println("[C] ALPN client provider not present for " + ssl);
            }
        }
        return clientHelloMessage;
    }

    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription(description);
        if (debug != null && Debug.isOn((String)"handshake")) {
            System.out.println("SSL - handshake alert: " + message);
        }
        throw new SSLProtocolException("handshake alert:  " + message);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg mesg) throws IOException {
        X509Certificate[] peerCerts;
        block8: {
            String identityAlg;
            if (debug != null && Debug.isOn((String)"handshake")) {
                mesg.print(System.out);
            }
            if ((peerCerts = mesg.getCertificateChain()).length == 0) {
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if (!(this.reservedServerCerts == null || (identityAlg = this.getEndpointIdentificationAlgorithmSE()) != null && identityAlg.length() != 0 || ClientHandshaker.isIdentityEquivalent(peerCerts[0], this.reservedServerCerts[0]))) {
                this.fatalSE((byte)42, "server certificate change is restricted during renegotiation");
            }
            X509TrustManager tm = this.sslContext.getX509TrustManager();
            try {
                String keyExchangeString = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
                if (tm instanceof X509ExtendedTrustManager) {
                    if (this.conn != null) {
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])peerCerts.clone(), keyExchangeString, this.conn);
                    } else {
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])peerCerts.clone(), keyExchangeString, this.engine);
                    }
                    break block8;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException e) {
                this.fatalSE((byte)46, e);
            }
        }
        this.session.setPeerCertificates(peerCerts);
    }

    private static boolean isIdentityEquivalent(X509Certificate thisCert, X509Certificate prevCert) {
        Collection<List<?>> prevSubjectAltNames;
        Collection<List<?>> thisSubjectAltNames;
        block9: {
            block8: {
                if (thisCert.equals(prevCert)) {
                    return true;
                }
                thisSubjectAltNames = null;
                try {
                    thisSubjectAltNames = thisCert.getSubjectAlternativeNames();
                }
                catch (CertificateParsingException cpe) {
                    if (debug == null || !Debug.isOn((String)"handshake")) break block8;
                    System.out.println("Attempt to obtain subjectAltNames extension failed!");
                }
            }
            prevSubjectAltNames = null;
            try {
                prevSubjectAltNames = prevCert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException cpe) {
                if (debug == null || !Debug.isOn((String)"handshake")) break block9;
                System.out.println("Attempt to obtain subjectAltNames extension failed!");
            }
        }
        if (thisSubjectAltNames != null && prevSubjectAltNames != null) {
            Collection<String> thisSubAltIPAddrs = ClientHandshaker.getSubjectAltNames(thisSubjectAltNames, 7);
            Collection<String> prevSubAltIPAddrs = ClientHandshaker.getSubjectAltNames(prevSubjectAltNames, 7);
            if (thisSubAltIPAddrs != null && prevSubAltIPAddrs != null && ClientHandshaker.isEquivalent(thisSubAltIPAddrs, prevSubAltIPAddrs)) {
                return true;
            }
            Collection<String> thisSubAltDnsNames = ClientHandshaker.getSubjectAltNames(thisSubjectAltNames, 2);
            Collection<String> prevSubAltDnsNames = ClientHandshaker.getSubjectAltNames(prevSubjectAltNames, 2);
            if (thisSubAltDnsNames != null && prevSubAltDnsNames != null && ClientHandshaker.isEquivalent(thisSubAltDnsNames, prevSubAltDnsNames)) {
                return true;
            }
        }
        X500Principal thisSubject = thisCert.getSubjectX500Principal();
        X500Principal prevSubject = prevCert.getSubjectX500Principal();
        X500Principal thisIssuer = thisCert.getIssuerX500Principal();
        X500Principal prevIssuer = prevCert.getIssuerX500Principal();
        return !thisSubject.getName().isEmpty() && !prevSubject.getName().isEmpty() && thisSubject.equals(prevSubject) && thisIssuer.equals(prevIssuer);
    }

    private static Collection<String> getSubjectAltNames(Collection<List<?>> subjectAltNames, int type) {
        HashSet<String> subAltDnsNames = null;
        for (List<?> subjectAltName : subjectAltNames) {
            String subAltDnsName;
            int subjectAltNameType = (Integer)subjectAltName.get(0);
            if (subjectAltNameType != type || (subAltDnsName = (String)subjectAltName.get(1)) == null || subAltDnsName.isEmpty()) continue;
            if (subAltDnsNames == null) {
                subAltDnsNames = new HashSet<String>(subjectAltNames.size());
            }
            subAltDnsNames.add(subAltDnsName);
        }
        return subAltDnsNames;
    }

    private static boolean isEquivalent(Collection<String> thisSubAltNames, Collection<String> prevSubAltNames) {
        for (String thisSubAltName : thisSubAltNames) {
            for (String prevSubAltName : prevSubAltNames) {
                if (!thisSubAltName.equalsIgnoreCase(prevSubAltName)) continue;
                return true;
            }
        }
        return false;
    }
}

