/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import org.jetbrains.annotations.NotNull;

public abstract class BackupStrategy {
    public static final BackupStrategy EMPTY = new BackupStrategy(){

        @Override
        public Iterable<VirtualFileDescriptor> getContents() {
            return Collections.emptyList();
        }
    };

    public void beforeBackup() throws Exception {
    }

    public Iterable<VirtualFileDescriptor> getContents() {
        final Iterable<FileDescriptor> contents = this.listFiles();
        return new Iterable<VirtualFileDescriptor>(){

            @Override
            @NotNull
            public Iterator<VirtualFileDescriptor> iterator() {
                final Iterator sourceItr = contents.iterator();
                return new Iterator<VirtualFileDescriptor>(){

                    @Override
                    public boolean hasNext() {
                        return sourceItr.hasNext();
                    }

                    @Override
                    public VirtualFileDescriptor next() {
                        return (VirtualFileDescriptor)sourceItr.next();
                    }

                    @Override
                    public void remove() {
                        sourceItr.remove();
                    }
                };
            }
        };
    }

    @Deprecated
    public Iterable<FileDescriptor> listFiles() {
        return Collections.emptyList();
    }

    public void afterBackup() throws Exception {
    }

    public boolean isInterrupted() {
        return false;
    }

    public void onError(Throwable t) {
    }

    public long acceptFile(@NotNull VirtualFileDescriptor file) {
        return Long.MAX_VALUE;
    }

    @Deprecated
    public long acceptFile(@NotNull File file) {
        return Long.MAX_VALUE;
    }

    public static class FileDescriptor
    implements VirtualFileDescriptor {
        @NotNull
        private final File file;
        @NotNull
        private final String path;
        private final long fileSize;
        private final boolean canBeEncrypted;

        public FileDescriptor(@NotNull File file, @NotNull String path, long fileSize, boolean canBeEncrypted) {
            this.file = file;
            this.path = path;
            this.fileSize = fileSize;
            this.canBeEncrypted = canBeEncrypted;
        }

        public FileDescriptor(@NotNull File file, @NotNull String path, long fileSize) {
            this(file, path, fileSize, true);
        }

        public FileDescriptor(@NotNull File file, @NotNull String path) {
            this(file, path, file.length());
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public File getFile() {
            return this.file;
        }

        @Override
        public long getTimeStamp() {
            return this.file.lastModified();
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public boolean shouldCloseStream() {
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            return this.file.getName();
        }

        @Override
        public boolean hasContent() {
            return this.file.isFile();
        }

        @Override
        public long getFileSize() {
            return this.fileSize;
        }

        @Override
        public boolean canBeEncrypted() {
            return this.canBeEncrypted;
        }

        @Override
        public VirtualFileDescriptor copy(long acceptedSize) {
            return new FileDescriptor(this.file, this.path, acceptedSize, this.canBeEncrypted);
        }
    }
}

