/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import org.jetbrains.annotations.NotNull;

public class BindingUtils {
    private BindingUtils() {
    }

    public static short readShort(@NotNull ByteArrayInputStream stream) {
        return (short)(BindingUtils.readUnsignedShort(stream) ^ 0x8000);
    }

    public static int readInt(@NotNull ByteArrayInputStream stream) {
        return (int)(BindingUtils.readUnsignedInt(stream) ^ Integer.MIN_VALUE);
    }

    public static long readLong(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readUnsignedLong(stream) ^ Long.MIN_VALUE;
    }

    public static float readFloat(@NotNull ByteArrayInputStream stream) {
        return Float.intBitsToFloat((int)BindingUtils.readUnsignedInt(stream));
    }

    public static double readDouble(@NotNull ByteArrayInputStream stream) {
        return Double.longBitsToDouble(BindingUtils.readUnsignedLong(stream));
    }

    public static String readString(@NotNull ByteArrayInputStream stream) {
        int next = stream.read();
        if (next == 255) {
            next = stream.read();
            if (next == 0) {
                return null;
            }
            throw new IllegalArgumentException();
        }
        if (next == 0) {
            return "";
        }
        if (!(stream instanceof ByteArraySizedInputStream)) {
            throw new IllegalArgumentException("ByteArraySizedInputStream is expected");
        }
        ByteArraySizedInputStream sizedStream = (ByteArraySizedInputStream)stream;
        byte[] bytes = sizedStream.toByteArray();
        char[] chars = new char[sizedStream.size() - 1];
        int i = sizedStream.pos();
        int j = 0;
        do {
            int char2;
            if (next < 128) {
                chars[j++] = (char)next;
                continue;
            }
            int high = next >> 4;
            if (high == 12 || high == 13) {
                if (((char2 = bytes[i++] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalArgumentException();
                }
                chars[j++] = (char)((next & 0x1F) << 6 | char2 & 0x3F);
                continue;
            }
            if (high == 14) {
                char2 = bytes[i] & 0xFF;
                int char3 = bytes[i + 1] & 0xFF;
                i += 2;
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new IllegalArgumentException();
                }
                chars[j++] = (char)((next & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                continue;
            }
            throw new IllegalArgumentException();
        } while ((next = bytes[i++] & 0xFF) != 0);
        sizedStream.setPos(i);
        return new String(chars, 0, j);
    }

    private static int readUnsignedShort(@NotNull ByteArrayInputStream stream) {
        int c2;
        int c1 = stream.read();
        if ((c1 | (c2 = stream.read())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 8 | c2;
    }

    private static long readUnsignedInt(@NotNull ByteArrayInputStream stream) {
        long c4;
        long c3;
        long c2;
        long c1 = stream.read();
        if ((c1 | (c2 = (long)stream.read()) | (c3 = (long)stream.read()) | (c4 = (long)stream.read())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private static long readUnsignedLong(@NotNull ByteArrayInputStream stream) {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = stream.read();
        if ((c1 | (c2 = (long)stream.read()) | (c3 = (long)stream.read()) | (c4 = (long)stream.read()) | (c5 = (long)stream.read()) | (c6 = (long)stream.read()) | (c7 = (long)stream.read()) | (c8 = (long)stream.read())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }
}

