/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.hub.server.HubUrlDAO;
import jetbrains.hub.server.HubUrlDAO$getInviteUri$1;
import jetbrains.hub.server.HubUrlDAO$getPasswordRestoreUri$1;
import jetbrains.hub.server.verify.VerifyContactResource;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth.interactive.InviteSubresource;
import jetbrains.jetpass.oauth.interactive.KotlinUriBuilderExtentsionsKt;
import jetbrains.jetpass.oauth.interactive.Oauth2InteractiveResource;
import jetbrains.jetpass.oauth.interactive.RestorePasswordSubresource;
import jetbrains.jetpass.oauth2.server.UriBuilderUtilKt;
import jetbrains.jetpass.rest.api.ProjectDAOResource;
import jetbrains.jetpass.rest.api.avatar.AvatarResource;
import jetbrains.jetpass.rest.common.RequestContainerFilter;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.service.api.UrlDAO;
import jetbrains.jetpass.service.bean.JetPassMainAppImpl;
import jetbrains.jetpass.spring.LocalScope;
import jetbrains.jetpass.userManagement.persistence.UriConcatenator;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAvatar;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGravatar;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProfile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.controller.BaseApplication;

@LocalScope
@Component(value="urlDAO")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0002J)\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010!J*\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\bH\u0016J;\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\bH\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010\b2\b\u0010.\u001a\u0004\u0018\u00010\bH\u0016J3\u0010/\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u00020\b2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0012\u00104\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\bH\u0016J\u001e\u00108\u001a\u00020\u0013*\u00020\u00132\u0010\u00109\u001a\f\u0012\u0004\u0012\u00020;\u0012\u0002\b\u00030:H\u0002J\u001e\u0010<\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006@"}, d2={"Ljetbrains/hub/server/HubUrlDAO;", "Ljetbrains/jetpass/service/api/UrlDAO;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "(Ljetbrains/jetpass/service/api/JetPassMainApp;Ljetbrains/jetpass/service/api/HubPrincipalManager;)V", "defaultBaseURL", "", "getDefaultBaseURL", "()Ljava/lang/String;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "checkGravatarAndRemoveIfEmpty", "", "userId", "createApiRestUriBuilder", "Ljavax/ws/rs/core/UriBuilder;", "baseUrl", "getDefaultAvatar", "Ljava/net/URI;", "name", "size", "", "devicePixelRatio", "", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;)Ljava/net/URI;", "getEmailAvatar", "email", "getInfo", "Ljetbrains/jetpass/service/api/UrlDAO$AvatarInfo;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;)Ljetbrains/jetpass/service/api/UrlDAO$AvatarInfo;", "getInviteUri", "code", "serviceId", "getPasswordRestoreUri", "getProjectIconLink", "projectId", "etag", "requireDefault", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;Z)Ljava/lang/String;", "getServerBaseUrl", "getServiceRelativeUserGroupUri", "groupId", "getUserAvatarLink", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;)Ljava/lang/String;", "getUserGroupUrl", "group", "Ljetbrains/jetpass/api/authority/UserGroup;", "getUserProfileUrl", "user", "Ljetbrains/jetpass/api/authority/User;", "getVerifyContactURL", "oauth2InteractivePath", "property", "Lkotlin/reflect/KProperty1;", "Ljetbrains/jetpass/oauth/interactive/Oauth2InteractiveResource;", "queryParamUnlessNull", "value", "", "Companion", "jetbrains.jetpass.server"})
public class HubUrlDAO
implements UrlDAO {
    @NotNull
    private final JetPassMainApp jetPass;
    @NotNull
    private final HubPrincipalManager hubPrincipalManager;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getDefaultBaseURL() {
        StringBuilder stringBuilder = BaseApplication.getDefaultBaseURL();
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    @NotNull
    public String getUserProfileUrl(@Nullable User user) {
        String string;
        block5: {
            block4: {
                String string2;
                string = this.jetPass.getDefaultService().getUserUriPattern();
                if (string == null) break block4;
                String userUriPattern = string2 = string;
                Object object = user;
                if (object == null || (object = object.getId()) == null) {
                    object = "me";
                }
                Object userId = object;
                String userURI = StringsKt.replace$default((String)userUriPattern, (String)":id", (String)userId, (boolean)false, (int)4, null);
                String string3 = UriConcatenator.INSTANCE.concat(this.getDefaultBaseURL(), userURI).toASCIIString();
                string = string3;
                if (string3 != null) break block5;
            }
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public URI getDefaultAvatar(@NotNull String name, @Nullable Integer size, @Nullable Double devicePixelRatio) {
        void $receiver$iv;
        UriBuilder uriBuilder;
        UriBuilder uriBuilder2;
        UriBuilder uriBuilder3;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ArrayList<Object> parameters = new ArrayList<Object>(3);
        UriInfo uriInfo = RequestContainerFilter.Companion.getCurrentRequestContext().getUriInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"RequestContainerFilter.c\u2026entRequestContext.uriInfo");
        UriBuilder path = object = uriInfo.getBaseUriBuilder().path(AvatarResource.class).path(AvatarResource.class, "getDefaultAvatar");
        CharSequence charSequence = name;
        if (charSequence.length() > 0) {
            parameters.add(name);
            uriBuilder3 = path.queryParam("username", new Object[]{"{name}"});
        } else {
            uriBuilder3 = path;
        }
        path = object = uriBuilder3;
        if (size != null) {
            parameters.add(size);
            uriBuilder2 = path.queryParam("size", new Object[]{"{size}"});
        } else {
            uriBuilder2 = path;
        }
        path = object = uriBuilder2;
        if (devicePixelRatio != null) {
            parameters.add(devicePixelRatio);
            uriBuilder = path.queryParam("dpr", new Object[]{"{dpr}"});
        } else {
            uriBuilder = path;
        }
        object = parameters;
        UriBuilder uriBuilder4 = uriBuilder;
        void thisCollection$iv = $receiver$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        URI uRI = uriBuilder4.build(Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"RequestContainerFilter.c\u2026arameters.toTypedArray())");
        return uRI;
    }

    @NotNull
    public URI getEmailAvatar(@NotNull String email, @Nullable Integer size, @Nullable Double devicePixelRatio) {
        String avatarRedirectUrl2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        String p1 = string = (avatarRedirectUrl2 = (String)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(email, size, devicePixelRatio){
            final /* synthetic */ String $email;
            final /* synthetic */ Integer $size;
            final /* synthetic */ Double $devicePixelRatio;

            @NotNull
            public final String invoke(@NotNull TransientStoreSession it) {
                Integer n;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdGravatar.Companion companion = XdGravatar.Companion;
                String string = this.$email;
                Integer n2 = this.$size;
                if (n2 != null) {
                    Integer n3 = n2;
                    String string2 = string;
                    XdGravatar.Companion companion2 = companion;
                    int it2 = ((Number)n3).intValue();
                    Double d = this.$devicePixelRatio;
                    double d2 = (double)this.$size.intValue() * (d != null ? d : 2.0);
                    companion = companion2;
                    string = string2;
                    n = (int)d2;
                } else {
                    n = null;
                }
                return companion.getAvatarUrl(string, n);
            }
            {
                this.$email = string;
                this.$size = n;
                this.$devicePixelRatio = d;
                super(1);
            }
        }), (int)7, null));
        return new URI(p1);
    }

    @NotNull
    public String getUserAvatarLink(@NotNull String userId, @Nullable String etag, @Nullable Integer size, @Nullable Double devicePixelRatio) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        UriInfo uriInfo = RequestContainerFilter.Companion.getCurrentRequestContext().getUriInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"RequestContainerFilter.c\u2026entRequestContext.uriInfo");
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(AvatarResource.class).path(AvatarResource.class, "getUserAvatar");
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"RequestContainerFilter.c\u2026urce::getUserAvatar.name)");
        String string = this.queryParamUnlessNull(this.queryParamUnlessNull(this.queryParamUnlessNull(uriBuilder, "size", size), "dpr", devicePixelRatio), "etag", etag).build(new Object[]{userId}).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RequestContainerFilter.c\u2026         .toASCIIString()");
        return string;
    }

    @NotNull
    public String getProjectIconLink(@NotNull String projectId, @Nullable String etag, @Nullable Integer size, @Nullable Double devicePixelRatio, boolean requireDefault) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        UriInfo uriInfo = RequestContainerFilter.Companion.getCurrentRequestContext().getUriInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"RequestContainerFilter.c\u2026entRequestContext.uriInfo");
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(ProjectDAOResource.class).path(ProjectDAOResource.class, "byID").path(ProjectDAOResource.ProjectDAOEntitySubresource.class, "getIcon");
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"RequestContainerFilter.c\u2026ubresource::getIcon.name)");
        Boolean bl = requireDefault;
        String string = "default";
        UriBuilder uriBuilder2 = this.queryParamUnlessNull(this.queryParamUnlessNull(uriBuilder, "size", size), "dpr", devicePixelRatio);
        HubUrlDAO hubUrlDAO = this;
        HubUrlDAO hubUrlDAO2 = this;
        boolean it = bl;
        Boolean bl2 = it ? bl : null;
        String string2 = hubUrlDAO2.queryParamUnlessNull(hubUrlDAO.queryParamUnlessNull(uriBuilder2, string, bl2), "etag", etag).build(new Object[]{projectId}).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RequestContainerFilter.c\u2026         .toASCIIString()");
        return string2;
    }

    private final UriBuilder queryParamUnlessNull(@NotNull UriBuilder $receiver, String name, Object value) {
        UriBuilder uriBuilder;
        if (value != null) {
            UriBuilder uriBuilder2 = $receiver.queryParam(name, new Object[]{value.toString()});
            uriBuilder = uriBuilder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"this.queryParam(name, value.toString())");
        } else {
            uriBuilder = $receiver;
        }
        return uriBuilder;
    }

    @Nullable
    public UrlDAO.AvatarInfo getInfo(@NotNull String userId, @Nullable Integer size, @Nullable Double devicePixelRatio) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        this.checkGravatarAndRemoveIfEmpty(userId);
        return (UrlDAO.AvatarInfo)this.hubPrincipalManager.runAsRoot((Function0)new Function0<UrlDAO.AvatarInfo>(this, userId, size, devicePixelRatio){
            final /* synthetic */ HubUrlDAO this$0;
            final /* synthetic */ String $userId;
            final /* synthetic */ Integer $size;
            final /* synthetic */ Double $devicePixelRatio;

            @Nullable
            public final UrlDAO.AvatarInfo invoke() {
                return (UrlDAO.AvatarInfo)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, UrlDAO.AvatarInfo>(this){
                    final /* synthetic */ getInfo.1 this$0;

                    @Nullable
                    public final UrlDAO.AvatarInfo invoke(@NotNull TransientStoreSession it) {
                        UrlDAO.AvatarInfo avatarInfo;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdBaseUser xdBaseUser = (XdBaseUser)XdBaseUser.Companion.resolve(this.this$0.$userId);
                        if (xdBaseUser != null) {
                            Object object;
                            URI avatarURI;
                            URI uRI;
                            Object object2;
                            XdBaseUser xdBaseUser2 = xdBaseUser;
                            XdBaseUser user = xdBaseUser2;
                            XdBaseUser xdBaseUser3 = user;
                            if (!(xdBaseUser3 instanceof XdUser)) {
                                xdBaseUser3 = null;
                            }
                            if ((object2 = (XdUser)xdBaseUser3) == null || (object2 = object2.getVisibleName()) == null) {
                                object2 = "";
                            }
                            Object username = object2;
                            XdProfile xdProfile = user.getProfile();
                            Object avatar = xdProfile != null ? xdProfile.getAvatar() : null;
                            Object object3 = avatar;
                            if (object3 != null && (object3 = object3.getAvatarURL(this.this$0.$size, this.this$0.$devicePixelRatio)) != null) {
                                Object object4;
                                Object p1 = object4 = object3;
                                uRI = new URI((String)p1);
                            } else {
                                uRI = avatarURI = this.this$0.this$0.getDefaultAvatar((String)username, this.this$0.$size, this.this$0.$devicePixelRatio);
                            }
                            if ((object = avatar) == null || (object = object.getEntity()) == null || (object = object.getId()) == null || (object = object.toString()) == null) {
                                object = "00000000";
                            }
                            Object avatarID = object;
                            avatarInfo = new UrlDAO.AvatarInfo(avatarURI, (String)avatarID);
                        } else {
                            avatarInfo = null;
                        }
                        return avatarInfo;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)7, null);
            }
            {
                this.this$0 = hubUrlDAO;
                this.$userId = string;
                this.$size = n;
                this.$devicePixelRatio = d;
                super(0);
            }
        });
    }

    private final void checkGravatarAndRemoveIfEmpty(String userId) {
        this.hubPrincipalManager.runAsRoot((Function0)new Function0<Unit>(userId){
            final /* synthetic */ String $userId;

            public final void invoke() {
                try {
                    TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                        final /* synthetic */ checkGravatarAndRemoveIfEmpty.1 this$0;

                        public final void invoke(@NotNull TransientStoreSession txn) {
                            boolean isReadonly;
                            PersistentEntityStore persistentEntityStore;
                            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                            PersistentEntityStore persistentEntityStore2 = txn.getStore().getPersistentStore();
                            if (!(persistentEntityStore2 instanceof PersistentEntityStore)) {
                                persistentEntityStore2 = persistentEntityStore = null;
                            }
                            boolean bl = persistentEntityStore2 != null && (persistentEntityStore = persistentEntityStore.getEnvironment()) != null && (persistentEntityStore = persistentEntityStore.getEnvironmentConfig()) != null ? persistentEntityStore.getEnvIsReadonly() : (isReadonly = true);
                            if (!isReadonly) {
                                XdAvatar avatar;
                                XdBaseUser xdBaseUser = (XdBaseUser)XdBaseUser.Companion.resolve(this.this$0.$userId);
                                XdAvatar xdAvatar = xdBaseUser != null && (xdBaseUser = xdBaseUser.getProfile()) != null ? xdBaseUser.getAvatar() : (avatar = null);
                                if (avatar instanceof XdGravatar) {
                                    ((XdGravatar)avatar).getOrDeleteIfEmpty();
                                }
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)7, null);
                }
                catch (Exception e) {
                    HubUrlDAO.Companion.getLogger().warn((Function0)new Function0<String>(e){
                        final /* synthetic */ Exception $e;

                        @NotNull
                        public final String invoke() {
                            return "Cannot replace empty GRAvatar with a default icon: " + this.$e.getMessage();
                        }
                        {
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }
            {
                this.$userId = string;
                super(0);
            }
        });
    }

    @Nullable
    public String getServiceRelativeUserGroupUri(@Nullable String groupId) {
        String string;
        String groupUriPattern;
        String string2 = this.jetPass.getDefaultService().getGroupUriPattern();
        if (string2 == null) {
            JetPassMainAppImpl jetPassMainAppImpl;
            JetPassMainApp jetPassMainApp = this.jetPass;
            if (!(jetPassMainApp instanceof JetPassMainAppImpl)) {
                jetPassMainApp = null;
            }
            string2 = (jetPassMainAppImpl = (JetPassMainAppImpl)jetPassMainApp) != null && (jetPassMainAppImpl = jetPassMainAppImpl.getJetPassService()) != null ? jetPassMainAppImpl.getGroupUriPattern() : null;
        }
        String string3 = groupUriPattern = string2;
        if (string3 != null) {
            String string4 = groupId;
            if (string4 == null) {
                string4 = "";
            }
            string = StringsKt.replace$default((String)string3, (String)":id", (String)string4, (boolean)false, (int)4, null);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public String getUserGroupUrl(@Nullable UserGroup group) {
        String string;
        UserGroup userGroup = group;
        String groupURI = this.getServiceRelativeUserGroupUri(userGroup != null ? userGroup.getId() : null);
        if (groupURI != null) {
            String string2 = UriConcatenator.INSTANCE.concat(this.getDefaultBaseURL(), groupURI).toASCIIString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UriConcatenator.concat(d\u2026groupURI).toASCIIString()");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getServerBaseUrl() {
        StringBuilder stringBuilder = BaseApplication.getDefaultBaseURL();
        if (stringBuilder == null) {
            Intrinsics.throwNpe();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BaseApplication.getDefaultBaseURL()!!.toString()");
        return string;
    }

    @NotNull
    public URI getVerifyContactURL(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        UriBuilder uriBuilder = HubUrlDAO.createApiRestUriBuilder$default(this, null, 1, null).path(VerifyContactResource.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"createApiRestUriBuilder(\u2026tactResource::class.java)");
        URI uRI = KotlinUriBuilderExtentsionsKt.path((UriBuilder)uriBuilder, (KClass)Reflection.getOrCreateKotlinClass(VerifyContactResource.class), (KFunction)getVerifyContactURL.1.INSTANCE).build(new Object[]{code});
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"createApiRestUriBuilder(\u2026\n            .build(code)");
        return uRI;
    }

    @NotNull
    public URI getInviteUri(@NotNull String code, @NotNull String serviceId, @NotNull String userId, @Nullable String baseUrl2) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)serviceId, (String)"serviceId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        UriBuilder uriBuilder = KotlinUriBuilderExtentsionsKt.path((UriBuilder)this.oauth2InteractivePath(this.createApiRestUriBuilder(baseUrl2), HubUrlDAO$getInviteUri$1.INSTANCE), (KClass)Reflection.getOrCreateKotlinClass(InviteSubresource.class), (KFunction)getInviteUri.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"createApiRestUriBuilder(\u2026ce::checkCodeAndRedirect)");
        URI uRI = UriBuilderUtilKt.q((UriBuilder)UriBuilderUtilKt.q((UriBuilder)uriBuilder, (String)"client_id", (String)serviceId), (String)"userId", (String)userId).build(new Object[]{code});
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"createApiRestUriBuilder(\u2026\n            .build(code)");
        return uRI;
    }

    @NotNull
    public URI getPasswordRestoreUri(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        URI uRI = KotlinUriBuilderExtentsionsKt.path((UriBuilder)this.oauth2InteractivePath(HubUrlDAO.createApiRestUriBuilder$default(this, null, 1, null), HubUrlDAO$getPasswordRestoreUri$1.INSTANCE), (KClass)Reflection.getOrCreateKotlinClass(RestorePasswordSubresource.class), (KFunction)getPasswordRestoreUri.2.INSTANCE).build(new Object[]{code});
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"createApiRestUriBuilder(\u2026\n            .build(code)");
        return uRI;
    }

    private final UriBuilder createApiRestUriBuilder(String baseUrl2) {
        String string = baseUrl2;
        if (string == null) {
            string = this.getServerBaseUrl();
        }
        URI hubBaseUrl = URI.create(string);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)hubBaseUrl).path("api").path("rest");
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(hubBa\u2026            .path(\"rest\")");
        return uriBuilder;
    }

    static /* bridge */ /* synthetic */ UriBuilder createApiRestUriBuilder$default(HubUrlDAO hubUrlDAO, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createApiRestUriBuilder");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return hubUrlDAO.createApiRestUriBuilder(string);
    }

    private final UriBuilder oauth2InteractivePath(@NotNull UriBuilder $receiver, KProperty1<Oauth2InteractiveResource, ?> property) {
        UriBuilder uriBuilder = $receiver.path(Oauth2InteractiveResource.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"this.path(Oauth2InteractiveResource::class.java)");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path((UriBuilder)uriBuilder, (KClass)Reflection.getOrCreateKotlinClass(Oauth2InteractiveResource.class), (KProperty)((KProperty)property));
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"this.path(Oauth2Interact\u2026esource::class, property)");
        return uriBuilder2;
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return this.jetPass;
    }

    @NotNull
    public final HubPrincipalManager getHubPrincipalManager() {
        return this.hubPrincipalManager;
    }

    @Inject
    public HubUrlDAO(@NotNull JetPassMainApp jetPass, @NotNull HubPrincipalManager hubPrincipalManager) {
        Intrinsics.checkParameterIsNotNull((Object)jetPass, (String)"jetPass");
        Intrinsics.checkParameterIsNotNull((Object)hubPrincipalManager, (String)"hubPrincipalManager");
        this.jetPass = jetPass;
        this.hubPrincipalManager = hubPrincipalManager;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/hub/server/HubUrlDAO$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

