/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server;

import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.GuestToken;
import com.intellij.hub.auth.oauth2.token.PermanentToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JS\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020\u0003H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\""}, d2={"Ljetbrains/hub/server/RequestRepresentation;", "", "thread", "", "remoteAddr", "method", "request", "token", "user", "eventName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEventName", "()Ljava/lang/String;", "getMethod", "getRemoteAddr", "getRequest", "getThread", "getToken", "getUser", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "jetbrains.jetpass.server"})
public final class RequestRepresentation {
    @NotNull
    private final String thread;
    @NotNull
    private final String remoteAddr;
    @NotNull
    private final String method;
    @NotNull
    private final String request;
    @NotNull
    private final String token;
    @Nullable
    private final String user;
    @Nullable
    private final String eventName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        String string;
        String it = string = this.thread + '@' + this.method + '(' + this.token + '@' + this.remoteAddr + ") " + this.request;
        return this.eventName != null ? it + " [" + this.eventName + ']' : it;
    }

    @NotNull
    public final String getThread() {
        return this.thread;
    }

    @NotNull
    public final String getRemoteAddr() {
        return this.remoteAddr;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final String getRequest() {
        return this.request;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getEventName() {
        return this.eventName;
    }

    public RequestRepresentation(@NotNull String thread, @NotNull String remoteAddr, @NotNull String method, @NotNull String request, @NotNull String token, @Nullable String user, @Nullable String eventName) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddr, (String)"remoteAddr");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.thread = thread;
        this.remoteAddr = remoteAddr;
        this.method = method;
        this.request = request;
        this.token = token;
        this.user = user;
        this.eventName = eventName;
    }

    @NotNull
    public final String component1() {
        return this.thread;
    }

    @NotNull
    public final String component2() {
        return this.remoteAddr;
    }

    @NotNull
    public final String component3() {
        return this.method;
    }

    @NotNull
    public final String component4() {
        return this.request;
    }

    @NotNull
    public final String component5() {
        return this.token;
    }

    @Nullable
    public final String component6() {
        return this.user;
    }

    @Nullable
    public final String component7() {
        return this.eventName;
    }

    @NotNull
    public final RequestRepresentation copy(@NotNull String thread, @NotNull String remoteAddr, @NotNull String method, @NotNull String request, @NotNull String token, @Nullable String user, @Nullable String eventName) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddr, (String)"remoteAddr");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return new RequestRepresentation(thread, remoteAddr, method, request, token, user, eventName);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ RequestRepresentation copy$default(RequestRepresentation requestRepresentation, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string = requestRepresentation.thread;
        }
        if ((n & 2) != 0) {
            string2 = requestRepresentation.remoteAddr;
        }
        if ((n & 4) != 0) {
            string3 = requestRepresentation.method;
        }
        if ((n & 8) != 0) {
            string4 = requestRepresentation.request;
        }
        if ((n & 0x10) != 0) {
            string5 = requestRepresentation.token;
        }
        if ((n & 0x20) != 0) {
            string6 = requestRepresentation.user;
        }
        if ((n & 0x40) != 0) {
            string7 = requestRepresentation.eventName;
        }
        return requestRepresentation.copy(string, string2, string3, string4, string5, string6, string7);
    }

    public int hashCode() {
        String string = this.thread;
        String string2 = this.remoteAddr;
        String string3 = this.method;
        String string4 = this.request;
        String string5 = this.token;
        String string6 = this.user;
        String string7 = this.eventName;
        return ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RequestRepresentation)) break block3;
                RequestRepresentation requestRepresentation = (RequestRepresentation)object;
                if (!Intrinsics.areEqual((Object)this.thread, (Object)requestRepresentation.thread) || !Intrinsics.areEqual((Object)this.remoteAddr, (Object)requestRepresentation.remoteAddr) || !Intrinsics.areEqual((Object)this.method, (Object)requestRepresentation.method) || !Intrinsics.areEqual((Object)this.request, (Object)requestRepresentation.request) || !Intrinsics.areEqual((Object)this.token, (Object)requestRepresentation.token) || !Intrinsics.areEqual((Object)this.user, (Object)requestRepresentation.user) || !Intrinsics.areEqual((Object)this.eventName, (Object)requestRepresentation.eventName)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Ljetbrains/hub/server/RequestRepresentation$Companion;", "", "()V", "decodeUri", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "parseEventName", "parseRequest", "Ljetbrains/hub/server/RequestRepresentation;", "parseToken", "Lkotlin/Pair;", "jetbrains.jetpass.server"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RequestRepresentation parseRequest(@NotNull HttpServletRequest request) {
            void token;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (Intrinsics.areEqual((Object)"POST", (Object)request.getMethod())) {
                try {
                    request.setCharacterEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw (Throwable)new RuntimeException(uee);
                }
            }
            Pair<String, String> pair = this.parseToken(request);
            String uee = (String)pair.component1();
            String user = (String)pair.component2();
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            String string = thread.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Thread.currentThread().name");
            String string2 = request.getRemoteAddr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.remoteAddr");
            String string3 = request.getMethod();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"request.method");
            return new RequestRepresentation(string, string2, string3, this.decodeUri(request), (String)token, user, this.parseEventName(request));
        }

        private final Pair<String, String> parseToken(HttpServletRequest request) {
            Object object;
            String header = request.getHeader("Authorization");
            CharSequence charSequence = header;
            if (!(charSequence == null || charSequence.length() == 0)) {
                try {
                    Pair pair;
                    if (BasicAuthToken.Companion.isBasic(header)) {
                        String string = header;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                        String username = BasicAuthToken.Companion.decodeHeader(string).getUsername();
                        pair = TuplesKt.to((Object)("basic{" + username + '}'), (Object)username);
                    } else if (AccessToken.Companion.isBearer(header)) {
                        GuestToken token;
                        if (GuestToken.isGuestTokenHeader((String)header)) {
                            String string = header;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                            token = GuestToken.decodeHeader((String)string);
                            pair = TuplesKt.to((Object)token.toString(), null);
                        } else if (PermanentToken.Companion.isPermanentTokenHeader(header)) {
                            String string = header;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                            token = PermanentToken.Companion.decodeHeader(string);
                            pair = TuplesKt.to((Object)String.valueOf(token), (Object)token.getUsername());
                        } else {
                            String string = header;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header");
                            token = AccessToken.Companion.decodeHeader(string);
                            pair = TuplesKt.to((Object)String.valueOf(token.getData()), (Object)token.getUser());
                        }
                    } else {
                        pair = TuplesKt.to((Object)("unknown{" + header + '}'), null);
                    }
                    charSequence = pair;
                }
                catch (RuntimeException ex) {
                    charSequence = TuplesKt.to((Object)("invalid{" + header + '}'), null);
                }
                object = charSequence;
            } else {
                object = TuplesKt.to((Object)"anonymous", null);
            }
            return object;
        }

        private final String decodeUri(HttpServletRequest request) {
            String string;
            String it = string = request.getRequestURI();
            String queryString = request.getQueryString();
            it = string = queryString != null ? it + '?' + queryString : it;
            String string2 = URLDecoder.decode(it, "UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLDecoder.decode(it, \"UTF-8\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.requestURI.let {\u2026der.decode(it, \"UTF-8\") }");
            return string2;
        }

        private final String parseEventName(HttpServletRequest request) {
            String string;
            String string2 = request.getMethod();
            String it = string2;
            String string3 = Intrinsics.areEqual((Object)it, (Object)"POST") ? string2 : null;
            if (string3 != null) {
                it = string2 = string3;
                string = request.getParameter("event_");
            } else {
                string = null;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

