/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.cron;

import javax.servlet.ServletContext;
import jetbrains.hub.server.cron.ContainerAwareJob;
import jetbrains.hub.server.cron.HubScheduler;
import jetbrains.hub.server.cron.backup.RegularBackupJob;
import jetbrains.jetpass.service.api.JetPassMainApp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronExpression;
import org.quartz.Scheduler;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/hub/server/cron/HostedAwareHubScheduler;", "Ljetbrains/hub/server/cron/HubScheduler;", "scheduler", "Lorg/quartz/Scheduler;", "(Lorg/quartz/Scheduler;)V", "isHosted", "", "schedule", "", "J", "Ljetbrains/hub/server/cron/ContainerAwareJob;", "servletContext", "Ljavax/servlet/ServletContext;", "cronExpression", "Lorg/quartz/CronExpression;", "clazz", "Lkotlin/reflect/KClass;", "jetbrains.jetpass.server"})
public final class HostedAwareHubScheduler
extends HubScheduler {
    private final boolean isHosted;

    @Override
    public <J extends ContainerAwareJob> void schedule(@NotNull ServletContext servletContext, @NotNull CronExpression cronExpression, @NotNull KClass<J> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)servletContext, (String)"servletContext");
        Intrinsics.checkParameterIsNotNull((Object)cronExpression, (String)"cronExpression");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (!this.isHosted || !Intrinsics.areEqual(clazz, (Object)Reflection.getOrCreateKotlinClass(RegularBackupJob.class))) {
            super.schedule(servletContext, cronExpression, clazz);
        }
    }

    public HostedAwareHubScheduler(@NotNull Scheduler scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        super(scheduler);
        this.isHosted = Boolean.getBoolean(JetPassMainApp.Companion.getIS_JETPASS_HOSTED());
    }
}

