/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.cron;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import jetbrains.hub.server.cron.ContainerAwareJob;
import jetbrains.hub.server.cron.ServletContextAwareJobDetail;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.utils.Key;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010J0\u0010\u0011\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010H\u0016J&\u0010\u0012\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ljetbrains/hub/server/cron/HubScheduler;", "", "scheduler", "Lorg/quartz/Scheduler;", "(Lorg/quartz/Scheduler;)V", "getScheduler", "()Lorg/quartz/Scheduler;", "reschedule", "", "J", "Ljetbrains/hub/server/cron/ContainerAwareJob;", "servletContext", "Ljavax/servlet/ServletContext;", "cronExpression", "Lorg/quartz/CronExpression;", "clazz", "Lkotlin/reflect/KClass;", "schedule", "unschedule", "Companion", "jetbrains.jetpass.server"})
public class HubScheduler {
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private static final ConcurrentHashMap<Pair<ServletContext, KClass<? extends ContainerAwareJob>>, JobKey> jobKeys;
    public static final Companion Companion;

    public <J extends ContainerAwareJob> void schedule(@NotNull ServletContext servletContext, @NotNull CronExpression cronExpression, @NotNull KClass<J> clazz) {
        ServletContextAwareJobDetail servletContextAwareJobDetail;
        Intrinsics.checkParameterIsNotNull((Object)servletContext, (String)"servletContext");
        Intrinsics.checkParameterIsNotNull((Object)cronExpression, (String)"cronExpression");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        JobKey jobKey = new JobKey(Key.createUniqueName(null), clazz.getSimpleName());
        ServletContextAwareJobDetail $receiver = servletContextAwareJobDetail = new ServletContextAwareJobDetail(servletContext);
        $receiver.setJobClass(JvmClassMappingKt.getJavaClass(clazz));
        $receiver.setKey(jobKey);
        ServletContextAwareJobDetail jobDetail = servletContextAwareJobDetail;
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).build();
        this.scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        Map map = jobKeys;
        Pair pair = TuplesKt.to((Object)servletContext, clazz);
        JobKey jobKey2 = jobKey;
        map.put(pair, jobKey2);
    }

    public final <J extends ContainerAwareJob> void unschedule(@NotNull ServletContext servletContext, @NotNull KClass<J> clazz) {
        boolean deleted;
        Intrinsics.checkParameterIsNotNull((Object)servletContext, (String)"servletContext");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        JobKey jobKey = jobKeys.remove(TuplesKt.to((Object)servletContext, clazz));
        if (jobKey != null && !this.scheduler.isShutdown() && !(deleted = this.scheduler.deleteJob(jobKey))) {
            Companion.getLogger().info((Function0)new Function0<String>(jobKey){
                final /* synthetic */ JobKey $jobKey;

                @NotNull
                public final String invoke() {
                    return "Job " + this.$jobKey + " was not found on deletion attempt";
                }
                {
                    this.$jobKey = jobKey;
                    super(0);
                }
            });
        }
    }

    public final <J extends ContainerAwareJob> void reschedule(@NotNull ServletContext servletContext, @Nullable CronExpression cronExpression, @NotNull KClass<J> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)servletContext, (String)"servletContext");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Pair key = TuplesKt.to((Object)servletContext, clazz);
        JobKey jobKey = jobKeys.get(key);
        if (jobKey != null) {
            this.unschedule(servletContext, clazz);
        }
        if (cronExpression != null) {
            this.schedule(servletContext, cronExpression, clazz);
        }
    }

    @NotNull
    public final Scheduler getScheduler() {
        return this.scheduler;
    }

    public HubScheduler(@NotNull Scheduler scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        this.scheduler = scheduler;
    }

    static {
        Companion = new Companion(null);
        jobKeys = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R1\u0010\u0003\u001a\"\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0005\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/hub/server/cron/HubScheduler$Companion;", "Lmu/KLogging;", "()V", "jobKeys", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Ljavax/servlet/ServletContext;", "Lkotlin/reflect/KClass;", "Ljetbrains/hub/server/cron/ContainerAwareJob;", "Lorg/quartz/JobKey;", "getJobKeys", "()Ljava/util/concurrent/ConcurrentHashMap;", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final ConcurrentHashMap<Pair<ServletContext, KClass<? extends ContainerAwareJob>>, JobKey> getJobKeys() {
            return jobKeys;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

