/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.filter;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.hub.server.filter.FilterAdapter;
import jetbrains.hub.server.filter.KnownHeadersKt;
import jetbrains.hub.server.filter.XClientCertificateTokenMismatch;
import jetbrains.jetpass.auth.module.clientcert.dnq.xd.XdClientCertificateUserDetails;
import jetbrains.jetpass.core.security.cert.CertificateUtilsKt;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.spring.SpringUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\fH\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\fH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Ljetbrains/hub/server/filter/ClientCertificateFilter;", "Ljetbrains/hub/server/filter/FilterAdapter;", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "doFilter", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "searchByThumbprint", "", "certificate", "Ljava/security/cert/X509Certificate;", "getAccessToken", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "getClientCertificate", "Companion", "jetbrains.jetpass.server"})
public final class ClientCertificateFilter
implements FilterAdapter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty daoContainer$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ClientCertificateFilter.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;"))};
        Companion = new Companion(null);
    }

    private final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void doFilter(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        String string = request.getPathInfo();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        if (Intrinsics.areEqual((Object)StringsKt.trimStart((String)string2, (char[])new char[]{'/'}), (Object)"users/me")) {
            String foundUserId;
            X509Certificate certificate;
            String userId;
            AccessToken token = this.getAccessToken(request);
            AccessToken accessToken = token;
            String string3 = accessToken != null && (accessToken = accessToken.getData()) != null ? accessToken.getUser() : (userId = null);
            if (userId != null && (certificate = this.getClientCertificate(request)) != null && (foundUserId = this.searchByThumbprint(certificate)) != null && Intrinsics.areEqual((Object)foundUserId, (Object)userId) ^ true) {
                response.addHeader("access-control-expose-headers", XClientCertificateTokenMismatch.INSTANCE.getName());
                KnownHeadersKt.addHeader(response, XClientCertificateTokenMismatch.INSTANCE);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private final AccessToken getAccessToken(@NotNull HttpServletRequest $receiver) {
        AccessToken accessToken;
        String authorizationHeader = $receiver.getHeader("Authorization");
        if (authorizationHeader != null && AccessToken.Companion.isBearer(authorizationHeader)) {
            AccessToken accessToken2;
            try {
                accessToken2 = AccessToken.Companion.decodeHeader(authorizationHeader);
            }
            catch (InvalidTokenException ex) {
                Companion.getLogger().debug((Function0)new Function0<String>(ex){
                    final /* synthetic */ InvalidTokenException $ex;

                    @NotNull
                    public final String invoke() {
                        return "Failed to decode access token value: " + this.$ex.getMessage();
                    }
                    {
                        this.$ex = invalidTokenException;
                        super(0);
                    }
                });
                accessToken2 = null;
            }
            accessToken = accessToken2;
        } else {
            accessToken = null;
        }
        return accessToken;
    }

    private final X509Certificate getClientCertificate(@NotNull HttpServletRequest $receiver) {
        X509Certificate x509Certificate;
        try {
            x509Certificate = (X509Certificate)CollectionsKt.firstOrNull((List)jetbrains.jetpass.rest.common.certificates.CertificateUtilsKt.extractClientCertificates((HttpServletRequest)$receiver));
        }
        catch (DataAccessException ex) {
            x509Certificate = null;
        }
        return x509Certificate;
    }

    private final String searchByThumbprint(X509Certificate certificate) {
        return this.getDaoContainer().getJetPassFeatureDAO().isEnabledSafe("jetbrains.hub.auth.client.certificate.feature") ? (String)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(certificate){
            final /* synthetic */ X509Certificate $certificate;

            @Nullable
            public final String invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdClientCertificateUserDetails xdClientCertificateUserDetails = (XdClientCertificateUserDetails)XdQueryKt.firstOrNull((XdQuery)XdClientCertificateUserDetails.Companion.find$default((XdClientCertificateUserDetails.Companion)XdClientCertificateUserDetails.Companion, (String)CertificateUtilsKt.thumbprint((X509Certificate)this.$certificate), (boolean)false, null, (int)4, null));
                return xdClientCertificateUserDetails != null && (xdClientCertificateUserDetails = xdClientCertificateUserDetails.getUser()) != null ? xdClientCertificateUserDetails.getUuid() : null;
            }
            {
                this.$certificate = x509Certificate;
                super(1);
            }
        }), (int)7, null) : null;
    }

    public ClientCertificateFilter() {
        ReadOnlyProperty readOnlyProperty;
        ClientCertificateFilter clientCertificateFilter = this;
        String name$iv = null;
        clientCertificateFilter.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @Override
    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        FilterAdapter.DefaultImpls.doFilter(this, request, response, chain);
    }

    @Override
    public void init(@NotNull FilterConfig filterConfig) {
        Intrinsics.checkParameterIsNotNull((Object)filterConfig, (String)"filterConfig");
        FilterAdapter.DefaultImpls.init(this, filterConfig);
    }

    @Override
    public void destroy() {
        FilterAdapter.DefaultImpls.destroy(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/hub/server/filter/ClientCertificateFilter$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

