/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.filter;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.hub.server.RequestRepresentation;
import jetbrains.hub.server.filter.FilterAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Ljetbrains/hub/server/filter/LoggingFilter;", "Ljetbrains/hub/server/filter/FilterAdapter;", "()V", "afterRequest", "", "beforeRequest", "request", "Ljavax/servlet/http/HttpServletRequest;", "doFilter", "response", "Ljavax/servlet/http/HttpServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "Companion", "jetbrains.jetpass.server"})
public final class LoggingFilter
implements FilterAdapter {
    private static final ThreadLocal<String> THREAD_NAME;
    private static final String CURRENT_USER = "user";
    private static final String REMOTE_ADDR = "remoteAddr";
    private static final String CURRENT_REQUEST = "request";
    private static final String CURRENT_TOKEN = "token";
    private static final String DETAILED_LOG_ENABLED = "jetbrains.hub.log.detailed.enabled";
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)CURRENT_REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        try {
            this.beforeRequest(request);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.afterRequest();
        }
    }

    private final void beforeRequest(HttpServletRequest request) {
        String it;
        String string;
        RequestRepresentation requestPresentation = RequestRepresentation.Companion.parseRequest(request);
        MDC.put((String)REMOTE_ADDR, (String)requestPresentation.getRemoteAddr());
        MDC.put((String)CURRENT_TOKEN, (String)requestPresentation.getToken());
        MDC.put((String)CURRENT_REQUEST, (String)(requestPresentation.getMethod() + ' ' + requestPresentation.getRequest()));
        String string2 = requestPresentation.getUser();
        if (string2 != null) {
            it = string = string2;
            MDC.put((String)CURRENT_USER, (String)it);
        }
        String string3 = request.getServletContext().getInitParameter("domain");
        if (string3 != null) {
            it = string = string3;
            MDC.put((String)"domain", (String)it);
        }
        String string4 = request.getServletContext().getInitParameter(DETAILED_LOG_ENABLED);
        if (string4 != null) {
            it = string = string4;
            MDC.put((String)DETAILED_LOG_ENABLED, (String)it);
        }
        THREAD_NAME.set(requestPresentation.toString());
    }

    private final void afterRequest() {
        THREAD_NAME.remove();
        MDC.remove((String)CURRENT_USER);
        MDC.remove((String)CURRENT_REQUEST);
        MDC.remove((String)CURRENT_TOKEN);
        MDC.remove((String)REMOTE_ADDR);
        MDC.remove((String)"domain");
    }

    static {
        Companion = new Companion(null);
        THREAD_NAME = new ThreadLocal();
    }

    @Override
    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)CURRENT_REQUEST);
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        FilterAdapter.DefaultImpls.doFilter(this, request, response, chain);
    }

    @Override
    public void init(@NotNull FilterConfig filterConfig) {
        Intrinsics.checkParameterIsNotNull((Object)filterConfig, (String)"filterConfig");
        FilterAdapter.DefaultImpls.init(this, filterConfig);
    }

    @Override
    public void destroy() {
        FilterAdapter.DefaultImpls.destroy(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/hub/server/filter/LoggingFilter$Companion;", "", "()V", "CURRENT_REQUEST", "", "CURRENT_TOKEN", "CURRENT_USER", "DETAILED_LOG_ENABLED", "REMOTE_ADDR", "THREAD_NAME", "Ljava/lang/ThreadLocal;", "jetbrains.jetpass.server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

