/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.hub.server.feature.HubInternalConfigurationParameters;
import jetbrains.hub.server.filter.FilterAdapter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/hub/server/filter/SourceMapsFilter;", "Ljetbrains/hub/server/filter/FilterAdapter;", "()V", "extensions", "", "", "methods", "sourceMapUriPattern", "attachSourceMapsHeader", "", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "doFilter", "Ljavax/servlet/http/HttpServletRequest;", "Ljavax/servlet/http/HttpServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "init", "filterConfig", "Ljavax/servlet/FilterConfig;", "isFile", "", "uri", "Companion", "jetbrains.jetpass.server"})
public final class SourceMapsFilter
implements FilterAdapter {
    private List<String> methods = CollectionsKt.listOf((Object)"GET");
    private List<String> extensions = CollectionsKt.listOf((Object[])new String[]{"js", "css"});
    private String sourceMapUriPattern;
    private static final String METHODS_PARAM = "methods";
    private static final String FILE_EXTENSIONS_PARAM = "fileExtensions";
    private static final String PLACEHOLDER = "%fileName%";
    private static final String HEADER_NAME = "X-SourceMap";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull FilterConfig filterConfig) {
        Object object;
        Iterable it;
        String string;
        String string2;
        String it2;
        Collection collection;
        void $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)filterConfig, (String)"filterConfig");
        HubInternalConfigurationParameters config = new HubInternalConfigurationParameters(null, null, 3, null);
        this.sourceMapUriPattern = config.getSourceMapsUriPattern();
        Object object2 = filterConfig.getInitParameter(METHODS_PARAM);
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            Iterable iterable = $receiver$iv = (Iterable)object2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string3 = (String)item$iv$iv;
                collection = destination$iv$iv;
                string2 = it2;
                void v1 = string2;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string);
            }
            it = $receiver$iv = (List)destination$iv$iv;
            this.methods = it;
        }
        if ((object = filterConfig.getInitParameter(FILE_EXTENSIONS_PARAM)) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            it = $receiver$iv = (Iterable)object;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                String string4 = string2 = it2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                collection.add(string);
            }
            List list = (List)destination$iv$iv;
            it = list;
            this.extensions = it;
        }
        Companion.getLogger().debug((Function0)new Function0<StringBuilder>(this){
            final /* synthetic */ SourceMapsFilter this$0;

            @NotNull
            public final StringBuilder invoke() {
                StringBuilder stringBuilder = new StringBuilder("Init parameters:\n");
                String string = "\tmethods: " + SourceMapsFilter.access$getMethods$p(this.this$0);
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                stringBuilder = StringsKt.appendln((StringBuilder)stringBuilder2);
                string = "\tfileExtensions: " + SourceMapsFilter.access$getExtensions$p(this.this$0);
                StringBuilder stringBuilder3 = stringBuilder.append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                stringBuilder = StringsKt.appendln((StringBuilder)stringBuilder3);
                StringBuilder stringBuilder4 = new StringBuilder().append("\tURI pattern: ");
                String string2 = SourceMapsFilter.access$getSourceMapUriPattern$p(this.this$0);
                if (string2 == null) {
                    string2 = "empty";
                }
                string = stringBuilder4.append(string2).toString();
                StringBuilder stringBuilder5 = stringBuilder.append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder5);
            }
            {
                this.this$0 = sourceMapsFilter;
                super(0);
            }
        });
    }

    @Override
    public void doFilter(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        this.attachSourceMapsHeader((ServletRequest)request, (ServletResponse)response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private final void attachSourceMapsHeader(ServletRequest request, ServletResponse response) {
        String string = this.sourceMapUriPattern;
        if (string == null) {
            return;
        }
        String uriPattern = string;
        if (!StringsKt.contains$default((CharSequence)uriPattern, (CharSequence)PLACEHOLDER, (boolean)false, (int)2, null)) {
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            return;
        }
        if (!this.methods.contains(((HttpServletRequest)request).getMethod())) {
            return;
        }
        if (((HttpServletResponse)response).getStatus() != 200) {
            return;
        }
        try {
            String requestUri;
            String string2 = requestUri = ((HttpServletRequest)request).getRequestURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"requestUri");
            if (!this.isFile(string2)) {
                return;
            }
            String fileName = StringsKt.substringAfterLast$default((String)requestUri, (String)"/", null, (int)2, null);
            String fileExt = StringsKt.substringAfterLast$default((String)requestUri, (String)".", null, (int)2, null);
            if (!this.extensions.contains(fileExt)) {
                return;
            }
            ((HttpServletResponse)response).setHeader(HEADER_NAME, StringsKt.replace$default((String)uriPattern, (String)PLACEHOLDER, (String)fileName, (boolean)false, (int)4, null));
        }
        catch (Exception ex) {
            Companion.getLogger().debug((Throwable)ex, (Function0)new Function0<String>(request){
                final /* synthetic */ ServletRequest $request;

                @NotNull
                public final String invoke() {
                    return "Can't attach source maps header to the response on " + ((HttpServletRequest)this.$request).getRequestURI();
                }
                {
                    this.$request = servletRequest;
                    super(0);
                }
            });
        }
    }

    private final boolean isFile(String uri2) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)uri2, (String)".", (int)0, (boolean)false, (int)6, null);
        if (dotIndex <= 0) {
            return false;
        }
        int p = StringsKt.lastIndexOf$default((CharSequence)uri2, (String)"/", (int)0, (boolean)false, (int)6, null);
        return dotIndex > p;
    }

    @Override
    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        FilterAdapter.DefaultImpls.doFilter(this, request, response, chain);
    }

    @Override
    public void destroy() {
        FilterAdapter.DefaultImpls.destroy(this);
    }

    @NotNull
    public static final /* synthetic */ List access$getMethods$p(SourceMapsFilter $this) {
        return $this.methods;
    }

    public static final /* synthetic */ void access$setMethods$p(SourceMapsFilter $this, @NotNull List list) {
        $this.methods = list;
    }

    @NotNull
    public static final /* synthetic */ List access$getExtensions$p(SourceMapsFilter $this) {
        return $this.extensions;
    }

    public static final /* synthetic */ void access$setExtensions$p(SourceMapsFilter $this, @NotNull List list) {
        $this.extensions = list;
    }

    @Nullable
    public static final /* synthetic */ String access$getSourceMapUriPattern$p(SourceMapsFilter $this) {
        return $this.sourceMapUriPattern;
    }

    public static final /* synthetic */ void access$setSourceMapUriPattern$p(SourceMapsFilter $this, @Nullable String string) {
        $this.sourceMapUriPattern = string;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/hub/server/filter/SourceMapsFilter$Companion;", "Lmu/KLogging;", "()V", "FILE_EXTENSIONS_PARAM", "", "HEADER_NAME", "METHODS_PARAM", "PLACEHOLDER", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

