/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.maintenance.jmx;

import com.codahale.metrics.ObjectNameFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/hub/server/maintenance/jmx/HubJmxObjectNameFactory;", "Lcom/codahale/metrics/ObjectNameFactory;", "()V", "HUB_JMX_DOMAIN", "", "createName", "Ljavax/management/ObjectName;", "type", "domain", "beanName", "createNameUnsafe", "jetbrains.jetpass.server"})
public final class HubJmxObjectNameFactory
implements ObjectNameFactory {
    @NotNull
    public static final String HUB_JMX_DOMAIN = "jetbrains.hub";
    public static final HubJmxObjectNameFactory INSTANCE;

    @NotNull
    public ObjectName createName(@NotNull String type, @NotNull String domain, @NotNull String beanName) {
        ObjectName objectName;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)beanName, (String)"beanName");
        try {
            objectName = this.createNameUnsafe(domain, beanName);
        }
        catch (MalformedObjectNameException e) {
            String string = ObjectName.quote(beanName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ObjectName.quote(beanName)");
            objectName = this.createNameUnsafe(domain, string);
        }
        return objectName;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectName createNameUnsafe(String domain, String beanName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)beanName, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void i;
            void part;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                throw (Throwable)new ArithmeticException("Index overflow has happened.");
            }
            int n2 = n;
            String string2 = (String)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            String string3 = "%03d=" + (String)part;
            Object[] objectArray = new Object[]{(int)i};
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
            collection2.add(string);
        }
        String parts = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return new ObjectName(domain + ": " + parts);
    }

    private HubJmxObjectNameFactory() {
    }

    static {
        HubJmxObjectNameFactory hubJmxObjectNameFactory;
        INSTANCE = hubJmxObjectNameFactory = new HubJmxObjectNameFactory();
    }
}

