/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.maintenance.jmx;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import jetbrains.hub.server.maintenance.jmx.HubJmxObjectNameFactory;
import jetbrains.hub.server.maintenance.jmx.HubJmxObjectNameFactoryKt;
import jetbrains.jetpass.auth.module.dnq.metrics.AuthMetrics;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.LocalScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\f"}, d2={"Ljetbrains/hub/server/maintenance/jmx/JmxDropwizardBeans;", "", "()V", "authMetrics", "Ljetbrains/jetpass/auth/module/dnq/metrics/AuthMetrics;", "metricsRegistry", "Lcom/codahale/metrics/MetricRegistry;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "jmxReporter", "Lcom/codahale/metrics/JmxReporter;", "AuthMetricsFactory", "jetbrains.jetpass.server"})
public class JmxDropwizardBeans {
    @Bean
    @NotNull
    public MetricRegistry metricsRegistry() {
        return new MetricRegistry();
    }

    @Bean
    @NotNull
    public JmxReporter jmxReporter(@NotNull MetricRegistry metricsRegistry) {
        JmxReporter jmxReporter;
        Intrinsics.checkParameterIsNotNull((Object)metricsRegistry, (String)"metricsRegistry");
        JmxReporter $receiver = jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricsRegistry).inDomain("jetbrains.hub").createsObjectNamesWith((ObjectNameFactory)HubJmxObjectNameFactory.INSTANCE).build();
        $receiver.start();
        JmxReporter jmxReporter2 = jmxReporter;
        Intrinsics.checkExpressionValueIsNotNull((Object)jmxReporter2, (String)"JmxReporter.forRegistry(\u2026       .apply { start() }");
        return jmxReporter2;
    }

    @Bean
    @LocalScope
    @NotNull
    public AuthMetrics authMetrics(@NotNull MetricRegistry metricsRegistry, @NotNull JetPassMainApp jetPass) {
        Intrinsics.checkParameterIsNotNull((Object)metricsRegistry, (String)"metricsRegistry");
        Intrinsics.checkParameterIsNotNull((Object)jetPass, (String)"jetPass");
        return new AuthMetricsFactory(jetPass, metricsRegistry);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Ljetbrains/hub/server/maintenance/jmx/JmxDropwizardBeans$AuthMetricsFactory;", "Ljetbrains/jetpass/auth/module/dnq/metrics/AuthMetrics;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "metricsRegistry", "Lcom/codahale/metrics/MetricRegistry;", "(Ljetbrains/hub/server/maintenance/jmx/JmxDropwizardBeans;Ljetbrains/jetpass/service/api/JetPassMainApp;Lcom/codahale/metrics/MetricRegistry;)V", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "getMetricsRegistry", "()Lcom/codahale/metrics/MetricRegistry;", "incFailedLoginMeter", "", "authType", "", "incLoginMeter", "incPermanentTokenClientsUsage", "normalizeAuthType", "jetbrains.jetpass.server"})
    private final class AuthMetricsFactory
    implements AuthMetrics {
        @NotNull
        private final JetPassMainApp jetPass;
        @NotNull
        private final MetricRegistry metricsRegistry;

        public void incLoginMeter(@NotNull String authType) {
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
            this.metricsRegistry.meter(HubJmxObjectNameFactoryKt.getBeanName(this.jetPass, "Login." + this.normalizeAuthType(authType) + ".Total")).mark();
        }

        public void incFailedLoginMeter(@NotNull String authType) {
            Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
            this.metricsRegistry.meter(HubJmxObjectNameFactoryKt.getBeanName(this.jetPass, "Login." + this.normalizeAuthType(authType) + ".Failed")).mark();
        }

        public void incPermanentTokenClientsUsage() {
            this.metricsRegistry.meter(HubJmxObjectNameFactoryKt.getBeanName(this.jetPass, "PermanentToken.Clients.Usage")).mark();
        }

        private final String normalizeAuthType(String authType) {
            return StringsKt.replace$default((String)authType, (String)".", (String)"_", (boolean)false, (int)4, null);
        }

        @NotNull
        public final JetPassMainApp getJetPass() {
            return this.jetPass;
        }

        @NotNull
        public final MetricRegistry getMetricsRegistry() {
            return this.metricsRegistry;
        }

        public AuthMetricsFactory(@NotNull JetPassMainApp jetPass, MetricRegistry metricsRegistry) {
            Intrinsics.checkParameterIsNotNull((Object)jetPass, (String)"jetPass");
            Intrinsics.checkParameterIsNotNull((Object)metricsRegistry, (String)"metricsRegistry");
            this.jetPass = jetPass;
            this.metricsRegistry = metricsRegistry;
        }
    }
}

