/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.maintenance.logging;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.hub.server.maintenance.logging.Log4j2Factory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Plugin(name="MultiplexingFileAppender", category="Core", elementType="appender")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0016R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Ljetbrains/hub/server/maintenance/logging/MultiplexingFileAppender;", "Lorg/apache/logging/log4j/core/appender/AbstractAppender;", "name", "", "file", "enabledProperty", "filter", "Lorg/apache/logging/log4j/core/Filter;", "layout", "Lorg/apache/logging/log4j/core/layout/PatternLayout;", "config", "Lorg/apache/logging/log4j/core/config/Configuration;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/apache/logging/log4j/core/Filter;Lorg/apache/logging/log4j/core/layout/PatternLayout;Lorg/apache/logging/log4j/core/config/Configuration;)V", "appenders", "", "Lorg/apache/logging/log4j/core/appender/RollingFileAppender;", "getConfig", "()Lorg/apache/logging/log4j/core/config/Configuration;", "getFile", "()Ljava/lang/String;", "append", "", "event", "Lorg/apache/logging/log4j/core/LogEvent;", "createAppender", "domain", "isEnabled", "", "contextData", "Lorg/apache/logging/log4j/util/ReadOnlyStringMap;", "stop", "Companion", "RollingFileAppenderBuilder", "jetbrains.jetpass.server"})
public final class MultiplexingFileAppender
extends AbstractAppender {
    private final Map<String, RollingFileAppender> appenders;
    @NotNull
    private final String file;
    private final String enabledProperty;
    @NotNull
    private final Configuration config;
    public static final Companion Companion = new Companion(null);

    public void stop() {
        Iterable $receiver$iv = this.appenders.values();
        for (Object element$iv : $receiver$iv) {
            RollingFileAppender it = (RollingFileAppender)element$iv;
            it.stop();
        }
        this.appenders.clear();
    }

    public void append(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        ReadOnlyStringMap readOnlyStringMap = event.getContextData();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyStringMap, (String)"event.contextData");
        if (!this.isEnabled(readOnlyStringMap)) {
            return;
        }
        String string = (String)event.getContextData().getValue("domain");
        if (string == null) {
            string = "local";
        }
        String domain = string;
        RollingFileAppender appender = this.appenders.get(domain);
        if (appender == null) {
            appender = this.createAppender(domain);
        }
        appender.append(event);
    }

    private final RollingFileAppender createAppender(String domain) {
        String folder = StringsKt.replace$default((String)Log4j2Factory.INSTANCE.getLOG_FOLDER(), (String)"{domain}", (String)domain, (boolean)false, (int)4, null);
        String filePath = new File(folder, this.file).getAbsolutePath();
        RollingFileAppenderBuilder rollingFileAppenderBuilder = (RollingFileAppenderBuilder)((RollingFileAppenderBuilder)new RollingFileAppenderBuilder().withName(this.getName() + ".@" + domain)).withFileName(filePath);
        String string = filePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
        RollingFileAppender appender = ((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)((RollingFileAppenderBuilder)rollingFileAppenderBuilder.withFilePattern(Log4j2Factory.INSTANCE.filePattern(string))).withLayout(this.getLayout())).withFilter(this.getFilter())).withCreateOnDemand(true)).withPolicy(Log4j2Factory.INSTANCE.triggeringPolicy())).withStrategy(Log4j2Factory.INSTANCE.rolloverStrategy(folder, this.config))).build();
        Map<String, RollingFileAppender> map = this.appenders;
        RollingFileAppender rollingFileAppender = appender;
        Intrinsics.checkExpressionValueIsNotNull((Object)rollingFileAppender, (String)"appender");
        RollingFileAppender rollingFileAppender2 = rollingFileAppender;
        map.put(domain, rollingFileAppender2);
        return appender;
    }

    private final boolean isEnabled(ReadOnlyStringMap contextData) {
        boolean bl;
        if (this.enabledProperty == null) {
            bl = true;
        } else {
            String stringValue;
            String string = System.getProperty(this.enabledProperty);
            if (string == null) {
                string = (String)contextData.getValue(this.enabledProperty);
            }
            String string2 = stringValue = string;
            if (string2 != null) {
                String string3 = string2;
                bl = Boolean.parseBoolean(string3);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final Configuration getConfig() {
        return this.config;
    }

    public MultiplexingFileAppender(@NotNull String name, @NotNull String file, @Nullable String enabledProperty, @Nullable Filter filter2, @NotNull PatternLayout layout, @NotNull Configuration config) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(name, filter2, (Layout)layout);
        this.file = file;
        this.enabledProperty = enabledProperty;
        this.config = config;
        this.appenders = new ConcurrentHashMap();
    }

    @JvmStatic
    @PluginFactory
    @NotNull
    public static final MultiplexingFileAppender create(@PluginAttribute(value="name") @NotNull String name, @PluginAttribute(value="file") @NotNull String file, @PluginAttribute(value="enabledProperty") @Nullable String enabledProperty, @PluginElement(value="patternLayout") @NotNull PatternLayout layout, @PluginElement(value="filter") @Nullable Filter filter2, @PluginConfiguration @NotNull Configuration configuration) {
        return Companion.create(name, file, enabledProperty, layout, filter2, configuration);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/hub/server/maintenance/logging/MultiplexingFileAppender$RollingFileAppenderBuilder;", "Lorg/apache/logging/log4j/core/appender/RollingFileAppender$Builder;", "()V", "jetbrains.jetpass.server"})
    public static final class RollingFileAppenderBuilder
    extends RollingFileAppender.Builder<RollingFileAppenderBuilder> {
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Ljetbrains/hub/server/maintenance/logging/MultiplexingFileAppender$Companion;", "", "()V", "create", "Ljetbrains/hub/server/maintenance/logging/MultiplexingFileAppender;", "name", "", "file", "enabledProperty", "layout", "Lorg/apache/logging/log4j/core/layout/PatternLayout;", "filter", "Lorg/apache/logging/log4j/core/Filter;", "configuration", "Lorg/apache/logging/log4j/core/config/Configuration;", "jetbrains.jetpass.server"})
    public static final class Companion {
        @JvmStatic
        @PluginFactory
        @NotNull
        public final MultiplexingFileAppender create(@PluginAttribute(value="name") @NotNull String name, @PluginAttribute(value="file") @NotNull String file, @PluginAttribute(value="enabledProperty") @Nullable String enabledProperty, @PluginElement(value="patternLayout") @NotNull PatternLayout layout, @PluginElement(value="filter") @Nullable Filter filter2, @PluginConfiguration @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            return new MultiplexingFileAppender(name, file, enabledProperty, filter2, layout, configuration);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

