/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.migration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jetbrains.jetpass.userManagement.persistence.dnq.XdDefaultRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPermission;
import jetbrains.jetpass.userManagement.persistence.dnq.XdResource;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationImpl;
import jetbrains.jetpass.userManagement.persistence.migration.PluggedMigrationImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Ljetbrains/hub/server/migration/RemoveDoubledServiceChildren;", "Ljetbrains/jetpass/userManagement/persistence/migration/PluggedMigrationImpl;", "previousMigration", "Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;", "(Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;)V", "getPreviousMigration", "()Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;", "setPreviousMigration", "apply", "", "Companion", "DuplicateFinder", "jetbrains.jetpass.server"})
public final class RemoveDoubledServiceChildren
extends PluggedMigrationImpl {
    @NotNull
    private MigrationImpl previousMigration;
    public static final Companion Companion = new Companion(null);

    public void apply() {
        new DuplicateFinder<XdResource>((XdEntityType)XdResource.Companion){

            @NotNull
            public String getKey(@NotNull XdResource entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return entity.getService().getUuid() + '/' + entity.getKey();
            }

            public boolean contains(@NotNull XdResource entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return XdQueryKt.contains((XdQuery)((XdQuery)entity.getService().getResources()), (XdEntity)((XdEntity)entity));
            }
        }.find();
        new DuplicateFinder<XdPermission>((XdEntityType)XdPermission.Companion){

            @NotNull
            public String getKey(@NotNull XdPermission entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return entity.getService().getUuid() + '/' + entity.getKey();
            }

            public boolean contains(@NotNull XdPermission entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return XdQueryKt.contains((XdQuery)((XdQuery)entity.getService().getPermissions()), (XdEntity)((XdEntity)entity));
            }
        }.find();
        new DuplicateFinder<XdDefaultRole>((XdEntityType)XdDefaultRole.Companion){

            @NotNull
            public String getKey(@NotNull XdDefaultRole entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return entity.getService().getUuid() + '/' + entity.getKey();
            }

            public boolean contains(@NotNull XdDefaultRole entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return XdQueryKt.contains((XdQuery)((XdQuery)entity.getService().getDefaultRoles()), (XdEntity)((XdEntity)entity));
            }
        }.find();
    }

    @NotNull
    public MigrationImpl getPreviousMigration() {
        return this.previousMigration;
    }

    public void setPreviousMigration(@NotNull MigrationImpl migrationImpl) {
        Intrinsics.checkParameterIsNotNull((Object)migrationImpl, (String)"<set-?>");
        this.previousMigration = migrationImpl;
    }

    public RemoveDoubledServiceChildren(@NotNull MigrationImpl previousMigration) {
        Intrinsics.checkParameterIsNotNull((Object)previousMigration, (String)"previousMigration");
        this.previousMigration = previousMigration;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u00a6\u0002\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ljetbrains/hub/server/migration/RemoveDoubledServiceChildren$DuplicateFinder;", "XD", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;", "", "entityType", "Lkotlinx/dnq/XdEntityType;", "(Lkotlinx/dnq/XdEntityType;)V", "getEntityType", "()Lkotlinx/dnq/XdEntityType;", "contains", "", "entity", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;)Z", "find", "", "getKey", "", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;)Ljava/lang/String;", "print", "prefix", "resource", "(Ljava/lang/String;Ljetbrains/jetpass/userManagement/persistence/dnq/XdUUIDObject;)V", "validate", "jetbrains.jetpass.server"})
    public static abstract class DuplicateFinder<XD extends XdUUIDObject> {
        @NotNull
        private final XdEntityType<XD> entityType;

        public final void find() {
            HashMap duplicateMap = new HashMap();
            Iterator iterator = XdQueryKt.iterator((XdQuery)this.entityType.all());
            while (iterator.hasNext()) {
                XdUUIDObject resource = (XdUUIDObject)iterator.next();
                String key = this.getKey(resource);
                XdUUIDObject duplicate = (XdUUIDObject)duplicateMap.get(key);
                if (duplicate == null) {
                    Map map = duplicateMap;
                    XdUUIDObject xdUUIDObject = resource;
                    map.put(key, xdUUIDObject);
                    continue;
                }
                this.print("Found " + this.entityType.getEntityType() + " Duplicate", resource);
                this.print("Found " + this.entityType.getEntityType() + " Duplicate", duplicate);
                boolean isRealLink = this.validate(resource);
                boolean dupLinkIsReal = this.validate(duplicate);
                if (!dupLinkIsReal || !isRealLink) continue;
                this.print("Found " + this.entityType.getEntityType() + " equal duplicate. Removing by random.", duplicate);
                duplicate.delete();
            }
        }

        private final boolean validate(XD entity) {
            boolean bl;
            if (this.contains(entity)) {
                this.print("Has broken back ref -- leaving", entity);
                bl = true;
            } else {
                this.print("New entity -- deleting", entity);
                entity.delete();
                bl = false;
            }
            return bl;
        }

        private final void print(String prefix, XD resource) {
            Companion.getLogger().warn(prefix + " key/id: " + this.getKey(resource) + '/' + resource.getUuid());
        }

        @NotNull
        public abstract String getKey(@NotNull XD var1);

        public abstract boolean contains(@NotNull XD var1);

        @NotNull
        public final XdEntityType<XD> getEntityType() {
            return this.entityType;
        }

        public DuplicateFinder(@NotNull XdEntityType<? extends XD> entityType) {
            Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
            this.entityType = entityType;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/hub/server/migration/RemoveDoubledServiceChildren$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

