/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import jetbrains.jetpass.client.hub.HubJsonSubtypesKt;
import jetbrains.jetpass.rest.common.JetPassAnnotationIntrospector;
import jetbrains.jetpass.rest.dto.ContactJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.JabberJSON;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Provider
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\u0014\u0010\u0006\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/hub/server/rest/HubObjectMapper;", "Ljavax/ws/rs/ext/ContextResolver;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "()V", "mapper", "configure", "getContext", "clazz", "Ljava/lang/Class;", "jetbrains.jetpass.server"})
public final class HubObjectMapper
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper mapper;

    private final ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule("BackwardCompatibility module", new Version(0, 1, 0, "0.1", "jetpass", "hub"));
        module.addDeserializer(ContactJSON.class, (JsonDeserializer)new JsonDeserializer<ContactJSON>(){

            @NotNull
            public ContactJSON deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext p1) throws IOException, JsonProcessingException {
                ContactJSON res;
                Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                String value = parser.getText();
                if (Intrinsics.areEqual((Object)parser.getCurrentName(), (Object)"jabber")) {
                    JabberJSON jabber = new JabberJSON();
                    jabber.setJabber(value);
                    res = (ContactJSON)jabber;
                } else {
                    EmailJSON email = new EmailJSON();
                    email.setEmail(value);
                    res = (ContactJSON)email;
                }
                return res;
            }
        });
        mapper.registerModule((Module)module);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new JetPassAnnotationIntrospector(), (AnnotationIntrospector)new JacksonAnnotationIntrospector()));
        HubJsonSubtypesKt.registerHubSubtypes((ObjectMapper)mapper);
        return mapper;
    }

    @NotNull
    public ObjectMapper getContext(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.mapper;
    }

    public HubObjectMapper() {
        ObjectMapper objectMapper;
        ObjectMapper objectMapper2 = new ObjectMapper();
        HubObjectMapper hubObjectMapper = this;
        ObjectMapper $receiver = objectMapper2;
        this.configure($receiver);
        hubObjectMapper.mapper = objectMapper = objectMapper2;
    }
}

