/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.hub.server.throttling;

import java.net.UnknownHostException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import jetbrains.exodus.database.IEventsMultiplexer;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.hub.server.feature.HubConfigurationParameters;
import jetbrains.hub.server.throttling.ThrottlingInitializer;
import jetbrains.jetpass.core.throttling.RateLimiter;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdThrottlingSettings;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.listener.LegacyEventMultiplexerUtilsKt;
import kotlinx.dnq.listener.XdEntityListener;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Scope;

@Named
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0010\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/hub/server/throttling/ThrottlingInitializer;", "", "eventsMultiplexer", "Ljetbrains/exodus/entitystore/EventsMultiplexer;", "loginThrottler", "Ljetbrains/jetpass/core/throttling/RateLimiter;", "", "(Ljetbrains/exodus/entitystore/EventsMultiplexer;Ljetbrains/jetpass/core/throttling/RateLimiter;)V", "initialize", "", "config", "Ljetbrains/hub/server/feature/HubConfigurationParameters;", "subscribeOnDatabaseUpdates", "throttler", "updatePersistentSettings", "updateTransitiveSettings", "reloadWhiteList", "settings", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdThrottlingSettings;", "Companion", "jetbrains.jetpass.server"})
public final class ThrottlingInitializer {
    private final EventsMultiplexer eventsMultiplexer;
    private final RateLimiter<String> loginThrottler;
    public static final Companion Companion = new Companion(null);

    public final void initialize(@NotNull HubConfigurationParameters config) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)config), (String)"config");
        this.subscribeOnDatabaseUpdates(this.loginThrottler);
        this.updatePersistentSettings(config);
        this.updateTransitiveSettings(this.loginThrottler, config);
    }

    private final void subscribeOnDatabaseUpdates(RateLimiter<String> throttler) {
        LegacyEventMultiplexerUtilsKt.addListener((IEventsMultiplexer)((IEventsMultiplexer)this.eventsMultiplexer), (XdEntityType)((XdEntityType)XdThrottlingSettings.Companion), (XdEntityListener)((XdEntityListener)new XdEntityListener<XdThrottlingSettings>(this, throttler){
            final /* synthetic */ ThrottlingInitializer this$0;
            final /* synthetic */ RateLimiter $throttler;

            public void updatedSync(@NotNull XdThrottlingSettings old, @NotNull XdThrottlingSettings current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                this.$throttler.setEnabled(current.getEnabled());
                ThrottlingInitializer.access$reloadWhiteList(this.this$0, this.$throttler, current);
            }
            {
                this.this$0 = $outer;
                this.$throttler = $captured_local_variable$1;
            }

            public void addedAsync(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncBeforeConstraints(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdThrottlingSettings removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdThrottlingSettings removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdThrottlingSettings removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdThrottlingSettings removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdThrottlingSettings added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdThrottlingSettings old, @NotNull XdThrottlingSettings current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdThrottlingSettings old, @NotNull XdThrottlingSettings current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncBeforeConstraints(@NotNull XdThrottlingSettings old, @NotNull XdThrottlingSettings current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdThrottlingSettings old, @NotNull XdThrottlingSettings current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        }));
    }

    private final void updatePersistentSettings(HubConfigurationParameters config) {
        block1: {
            List list;
            Object object;
            Boolean bl = config.isLoginThrottlingEnabled();
            if (bl != null) {
                object = bl;
                boolean state = (Boolean)object;
                TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(state){
                    final /* synthetic */ boolean $state;

                    public final void invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdRoots.INSTANCE.getThrottlingSettings().setEnabled(this.$state);
                    }
                    {
                        this.$state = bl;
                        super(1);
                    }
                }), (int)7, null);
            }
            String string = config.getLoginThrottlingWhiteList();
            if (string == null) break block1;
            Object value = object = string;
            List addresses = list = StringsKt.split$default((CharSequence)((CharSequence)value), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(addresses){
                final /* synthetic */ List $addresses;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Iterable $receiver$iv = this.$addresses;
                    for (T element$iv : $receiver$iv) {
                        String it2 = (String)element$iv;
                        try {
                            XdRoots.INSTANCE.getThrottlingSettings().trust(it2);
                        }
                        catch (IllegalArgumentException ex) {
                            ThrottlingInitializer.Companion.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(it2){
                                final /* synthetic */ String $it;

                                @NotNull
                                public final String invoke() {
                                    return "Can't add " + this.$it + " to the white list";
                                }
                                {
                                    this.$it = string;
                                    super(0);
                                }
                            });
                        }
                    }
                }
                {
                    this.$addresses = list;
                    super(1);
                }
            }), (int)7, null);
        }
    }

    private final void updateTransitiveSettings(RateLimiter<String> throttler, HubConfigurationParameters config) {
        block5: {
            int it;
            Integer n;
            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, throttler){
                final /* synthetic */ ThrottlingInitializer this$0;
                final /* synthetic */ RateLimiter $throttler;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$throttler.setEnabled(XdRoots.INSTANCE.getThrottlingSettings().getEnabled());
                    this.$throttler.getWhiteList().clear();
                    ThrottlingInitializer.access$reloadWhiteList(this.this$0, this.$throttler, XdRoots.INSTANCE.getThrottlingSettings());
                }
                {
                    this.this$0 = throttlingInitializer;
                    this.$throttler = rateLimiter;
                    super(1);
                }
            }), (int)7, null);
            Integer n2 = config.getLoginThrottlingMaxOfTrackingKeys();
            if (n2 != null) {
                n = n2;
                it = ((Number)n).intValue();
                throttler.getFailedKeys().setMaxSize(it);
            }
            Integer n3 = config.getLoginThrottlingMaxOfFailuresPerKey();
            if (n3 != null) {
                n = n3;
                it = ((Number)n).intValue();
                throttler.getFailedKeys().setBucketSize(it);
            }
            Integer n4 = config.getLoginThrottlingCooldownValuePerPeriod();
            if (n4 != null) {
                n = n4;
                it = ((Number)n).intValue();
                throttler.getFailedKeys().setLeakRateAmount(it);
            }
            Integer n5 = config.getLoginThrottlingCooldownPeriodInSeconds();
            if (n5 == null) break block5;
            n = n5;
            it = ((Number)n).intValue();
            try {
                throttler.getFailedKeys().setLeakRatePeriodSec((long)it);
            }
            catch (IllegalArgumentException ex) {
                Companion.getLogger().warn((Throwable)ex, (Function0)updateTransitiveSettings.5.1.INSTANCE);
            }
        }
    }

    private final void reloadWhiteList(@NotNull RateLimiter<String> $receiver, XdThrottlingSettings settings) {
        Iterable whiteList;
        $receiver.getWhiteList().clear();
        Iterable $receiver$iv = whiteList = settings.getTrustedKeys();
        for (Object element$iv : $receiver$iv) {
            String username = (String)element$iv;
            try {
                $receiver.getWhiteList().add(username);
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (exception instanceof IllegalArgumentException || exception instanceof UnknownHostException) {
                    Companion.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(username){
                        final /* synthetic */ String $username;

                        @NotNull
                        public final String invoke() {
                            return "Username [" + this.$username + "] can not be added to the username white list";
                        }
                        {
                            this.$username = string;
                            super(0);
                        }
                    });
                    continue;
                }
                throw (Throwable)ex;
            }
        }
    }

    @Inject
    public ThrottlingInitializer(@NotNull EventsMultiplexer eventsMultiplexer, @NotNull RateLimiter<String> loginThrottler) {
        Intrinsics.checkParameterIsNotNull((Object)eventsMultiplexer, (String)"eventsMultiplexer");
        Intrinsics.checkParameterIsNotNull(loginThrottler, (String)"loginThrottler");
        this.eventsMultiplexer = eventsMultiplexer;
        this.loginThrottler = loginThrottler;
    }

    public static final /* synthetic */ void access$reloadWhiteList(ThrottlingInitializer $this, @NotNull RateLimiter $receiver, @NotNull XdThrottlingSettings settings) {
        $this.reloadWhiteList((RateLimiter<String>)$receiver, settings);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/hub/server/throttling/ThrottlingInitializer$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.server"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

