/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.server.main;

import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.management.StatisticsItem;
import jetbrains.jetpass.api.metrics.Database;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/jetpass/server/main/DatabaseMetrics;", "Ljetbrains/jetpass/api/metrics/Database;", "database", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "persistentDatabaseEnvironment", "Ljetbrains/exodus/env/Environment;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;Ljetbrains/exodus/env/Environment;)V", "getBackgroundThreadsCount", "", "getBlobsSize", "", "getDataSize", "getEntityIterableCacheHitRate", "", "getEntityIterableCacheSize", "getLocation", "", "getPendingJobsCount", "getTextIndexSize", "getTransactionsCount", "getTransactionsPerSecond", "jetbrains.jetpass.server"})
public final class DatabaseMetrics
implements Database {
    private final PersistentEntityStoreImpl database;
    private final Environment persistentDatabaseEnvironment;

    @NotNull
    public String getLocation() {
        return this.database.getLocation();
    }

    public long getDataSize() {
        StatisticsItem statisticsItem = this.persistentDatabaseEnvironment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.DISK_USAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentDatabaseEnviro\u2026atistics.Type.DISK_USAGE)");
        return statisticsItem.getTotal();
    }

    public long getTextIndexSize() {
        return -1L;
    }

    public long getBlobsSize() {
        StatisticsItem statisticsItem = this.database.getStatistics().getStatisticsItem((Enum)PersistentEntityStoreStatistics.Type.BLOBS_DISK_USAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"database.statistics.getS\u2026cs.Type.BLOBS_DISK_USAGE)");
        return statisticsItem.getTotal();
    }

    public int getBackgroundThreadsCount() {
        EntityStoreSharedAsyncProcessor entityStoreSharedAsyncProcessor = this.database.getAsyncProcessor();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityStoreSharedAsyncProcessor, (String)"database.asyncProcessor");
        return entityStoreSharedAsyncProcessor.getThreadCount();
    }

    public int getPendingJobsCount() {
        return this.database.getAsyncProcessor().pendingJobs();
    }

    public int getEntityIterableCacheSize() {
        return this.database.getEntityIterableCache().count();
    }

    public double getEntityIterableCacheHitRate() {
        return this.database.getEntityIterableCache().hitRate();
    }

    public long getTransactionsCount() {
        StatisticsItem statisticsItem = this.persistentDatabaseEnvironment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.TRANSACTIONS);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentDatabaseEnviro\u2026istics.Type.TRANSACTIONS)");
        return statisticsItem.getTotal();
    }

    public double getTransactionsPerSecond() {
        StatisticsItem statisticsItem = this.persistentDatabaseEnvironment.getStatistics().getStatisticsItem((Enum)EnvironmentStatistics.Type.TRANSACTIONS);
        Intrinsics.checkExpressionValueIsNotNull((Object)statisticsItem, (String)"persistentDatabaseEnviro\u2026istics.Type.TRANSACTIONS)");
        return statisticsItem.getMean();
    }

    public DatabaseMetrics(@NotNull PersistentEntityStoreImpl database, @NotNull Environment persistentDatabaseEnvironment) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)persistentDatabaseEnvironment, (String)"persistentDatabaseEnvironment");
        this.database = database;
        this.persistentDatabaseEnvironment = persistentDatabaseEnvironment;
    }
}

