/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.api.workflow.annotations.ApiMethod;
import jetbrains.youtrack.api.workflow.annotations.ApiMpsIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiScope;
import jetbrains.youtrack.api.workflow.annotations.ApiSince;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.scripts.model.AbstractScriptingContext;
import jetbrains.youtrack.scripts.persistent.BeansKt;
import jetbrains.youtrack.workflow.api.IssueAttachmentsWorkflowApiExtensionKt;
import jetbrains.youtrack.workflow.api.log;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007\u001a0\u0010\u0007\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\r"}, d2={"copyAttachmentStreamToTemporaryFile", "Ljava/io/File;", "content", "Ljava/io/InputStream;", "delete", "", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "importAttachment", "Ljetbrains/youtrack/persistent/XdIssueAttachment$Companion;", "name", "", "charset", "mimeType", "youtrack-workflow"})
public final class IssueAttachmentsWorkflowApiExtensionKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2018.1.40030")
    @ApiMpsIgnore
    @ApiDoc(value="Permanently deletes the attachment.")
    public static final void delete(@NotNull XdIssueAttachment $receiver) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            XdIssue xdIssue = $receiver.getIssue();
            if (xdIssue == null) break block0;
            xdIssue.removeAttachment($receiver);
        }
    }

    @ApiMethod(scopes={ApiScope.PLUGIN})
    @NotNull
    public static final XdIssueAttachment importAttachment(@NotNull XdIssueAttachment.Companion $receiver, @NotNull InputStream content, @NotNull String name2, @Nullable String charset, @Nullable String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        XdIssueAttachment attachment2 = XdIssueAttachment.Companion.new(null, (Function1)new Function1<XdIssueAttachment, Unit>(name2, charset, mimeType){
            final /* synthetic */ String $name;
            final /* synthetic */ String $charset;
            final /* synthetic */ String $mimeType;

            public final void invoke(@NotNull XdIssueAttachment $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setName(this.$name);
                $receiver.setCharset(this.$charset);
                $receiver.setMimeType(this.$mimeType);
            }
            {
                this.$name = string;
                this.$charset = string2;
                this.$mimeType = string3;
                super(1);
            }
        });
        try {
            attachment2.getEntity().setBlob("content", IssueAttachmentsWorkflowApiExtensionKt.copyAttachmentStreamToTemporaryFile(content));
            attachment2.doInit();
            return attachment2;
        }
        catch (Throwable e) {
            attachment2.delete();
            log.INSTANCE.getLogger().error(e, (Function0)importAttachment.2.INSTANCE);
            throw (Throwable)new RuntimeException("Problem with importing attachment", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File copyAttachmentStreamToTemporaryFile(InputStream content) {
        AbstractScriptingContext abstractScriptingContext = BeansKt.getScriptingContextHolder().get();
        if (abstractScriptingContext == null) {
            Intrinsics.throwNpe();
        }
        File result = abstractScriptingContext.createTempFile("importAttachment", ".blob");
        FileOutputStream fileStream = new FileOutputStream(result);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(fileStream);
        try {
            IOUtils.copy((InputStream)content, (OutputStream)bufferedStream);
            bufferedStream.flush();
        }
        finally {
            bufferedStream.close();
            fileStream.close();
            content.close();
        }
        File file = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"result");
        return file;
    }
}

