/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker;

import java.util.Iterator;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.plugin.XdCustomFieldType;
import jetbrains.charisma.persistence.customfields.meta.YPrimitiveType;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.TypedValueResolver;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.scripts.wrappers.EntityValueResolver;
import jetbrains.youtrack.scripts.wrappers.SimpleValueResolver;
import jetbrains.youtrack.workflow.checker.TypeCheckerKt;
import jetbrains.youtrack.workflow.checker.TypeProblemListener;
import jetbrains.youtrack.workflow.requirement.FieldRequirement;
import jetbrains.youtrack.workflow.requirement.TypeRequirement;
import jetbrains.youtrack.workflow.wrappers.XdValueResolveUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0014J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u001a\u0010\u001a\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/workflow/checker/TypeChecker;", "", "listener", "Ljetbrains/youtrack/workflow/checker/TypeProblemListener;", "globalResolver", "Ljetbrains/youtrack/workflow/wrappers/XdValueResolveUtil;", "(Ljetbrains/youtrack/workflow/checker/TypeProblemListener;Ljetbrains/youtrack/workflow/wrappers/XdValueResolveUtil;)V", "getListener", "()Ljetbrains/youtrack/workflow/checker/TypeProblemListener;", "check", "", "requirement", "Ljetbrains/youtrack/workflow/requirement/TypeRequirement;", "resolver", "Ljetbrains/youtrack/scripts/wrappers/EntityValueResolver;", "checkField", "fieldRequirement", "Ljetbrains/youtrack/workflow/requirement/FieldRequirement;", "Ljetbrains/youtrack/api/workflow/wrappers/TypedValueResolver;", "checkFields", "typeRequirement", "typeResolver", "checkPrimitiveType", "fieldType", "checkType", "entityValueResolver", "checkValues", "compatibleWith", "", "youtrack-workflow"})
public class TypeChecker {
    @NotNull
    private final TypeProblemListener listener;
    private final XdValueResolveUtil globalResolver;

    public final void check(@NotNull TypeRequirement requirement, @NotNull EntityValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)requirement, (String)"requirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.checkType(requirement, resolver);
    }

    private final void checkType(TypeRequirement typeRequirement, EntityValueResolver entityValueResolver) {
        this.checkFields(typeRequirement, (TypedValueResolver)entityValueResolver);
        this.checkValues(typeRequirement, entityValueResolver);
    }

    private final void checkValues(TypeRequirement typeRequirement, EntityValueResolver entityValueResolver) {
        Object object = typeRequirement;
        if (object == null || (object = ((TypeRequirement)object).getValues()) == null) {
            return;
        }
        Object values = object;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String value2 = (String)iterator.next();
            if (entityValueResolver.resolveEnumReference(value2) != null) continue;
            this.listener.noSuchValue(typeRequirement, entityValueResolver, value2);
        }
    }

    private final void checkFields(TypeRequirement typeRequirement, TypedValueResolver typeResolver) {
        Iterable<FieldRequirement> fields = typeRequirement.getFields();
        for (FieldRequirement fieldRequirement : fields) {
            String linkName;
            PropertyValueResolver valueResolver;
            String requiredTypeName = fieldRequirement.getType().getName();
            if (fieldRequirement.getName() == null) {
                continue;
            }
            PropertyValueResolver propertyValueResolver = valueResolver = Intrinsics.areEqual((Object)requiredTypeName, (Object)XdIssueLinkPrototype.Companion.getEntityType()) ? this.globalResolver.findLinkTypeResolver(null, null, linkName) : typeResolver.resolveProperty(linkName);
            if (valueResolver == null) {
                XdCustomFieldType fieldType;
                XdCustomFieldPrototype field;
                XdCustomFieldPrototype xdCustomFieldPrototype = field = XdCustomFieldPrototype.Companion.findPrototype(linkName);
                Object object = fieldType = xdCustomFieldPrototype != null ? xdCustomFieldPrototype.getType() : null;
                if (fieldType == null || Intrinsics.areEqual((Object)requiredTypeName, (Object)fieldType.getValueType()) || Intrinsics.areEqual((Object)requiredTypeName, (Object)fieldType.getName()) || Intrinsics.areEqual((Object)requiredTypeName, (Object)XdIssueLinkPrototype.Companion.getEntityType()) || StringsKt.equals((String)YPrimitiveType.getPrimitiveTypeName((String)requiredTypeName), (String)fieldType.getValueType(), (boolean)true)) {
                    this.listener.noSuchField(typeRequirement, fieldRequirement);
                    continue;
                }
                SimpleValueResolver resolver = new SimpleValueResolver(null, fieldType.getName());
                this.listener.badTypeName(fieldRequirement, (TypedValueResolver)resolver);
                continue;
            }
            this.checkField(fieldRequirement, (TypedValueResolver)valueResolver);
        }
    }

    public final void checkField(@NotNull FieldRequirement fieldRequirement, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        TypeRequirement fieldType = fieldRequirement.getType();
        if (resolver.isPrimitive() != fieldType.getPrimitive()) {
            this.listener.badTypeName(fieldRequirement, resolver);
        } else if (resolver.isPrimitive()) {
            this.checkPrimitiveType(fieldRequirement, fieldType, resolver);
        } else if (!this.compatibleWith(fieldType, resolver)) {
            this.listener.badTypeName(fieldRequirement, resolver);
        } else {
            if (resolver.isMultiple() != fieldType.getMultiple()) {
                this.listener.badCardinality(fieldRequirement, resolver);
            }
            this.checkType(fieldType, (EntityValueResolver)resolver);
        }
    }

    private final boolean compatibleWith(@NotNull TypeRequirement $receiver, TypedValueResolver resolver) {
        return StringsKt.equals((String)$receiver.getName(), (String)resolver.getTypeName(), (boolean)true) || Intrinsics.areEqual((Object)$receiver.getName(), (Object)"EnumField") && TypeCheckerKt.getEnumFieldCompatibleTypes().contains(resolver.getTypeName());
    }

    protected void checkPrimitiveType(@NotNull FieldRequirement fieldRequirement, @NotNull TypeRequirement fieldType, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)fieldType, (String)"fieldType");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        String typeName = resolver.getTypeName();
        if (!StringsKt.equals((String)typeName, (String)fieldType.getName(), (boolean)true) && !StringsKt.equals((String)typeName, (String)YPrimitiveType.getPrimitiveTypeName((String)fieldType.getName()), (boolean)true)) {
            this.listener.badTypeName(fieldRequirement, resolver);
        }
    }

    @NotNull
    protected final TypeProblemListener getListener() {
        return this.listener;
    }

    public TypeChecker(@NotNull TypeProblemListener listener, @NotNull XdValueResolveUtil globalResolver) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)globalResolver, (String)"globalResolver");
        this.listener = listener;
        this.globalResolver = globalResolver;
    }
}

