/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.loaders;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.youtrack.api.workflow.WorkflowNamesConverter;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.scripts.loader.ScriptPackagesLoader;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.model.PredefinedScriptsAware;
import jetbrains.youtrack.scripts.persistence.ScriptFullName;
import jetbrains.youtrack.scripts.persistence.ScriptImpl;
import jetbrains.youtrack.scripts.persistence.WorkflowImpl;
import jetbrains.youtrack.scripts.persistent.XdScript;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import jetbrains.youtrack.workflow.loaders.XdPredefinedWorkflowDescriptor;
import jetbrains.youtrack.workflow.persistence.XdScriptUsage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0001;B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\n !*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0014J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010'\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0018J\u0010\u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u000202H\u0014J\b\u00103\u001a\u00020\u0016H\u0002J\u000e\u00104\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0018J\u0016\u00104\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0004J\u0006\u00105\u001a\u00020\u0016J\u000e\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u0018J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u000209H\u0002R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Ljetbrains/youtrack/workflow/loaders/PredefinedWorkflowsLoader;", "Ljetbrains/youtrack/scripts/loader/ScriptPackagesLoader;", "Ljetbrains/youtrack/scripts/model/PredefinedScriptsAware;", "rootFolderPath", "", "(Ljava/lang/String;)V", "availablePackages", "", "getAvailablePackages", "()Ljava/util/Set;", "setAvailablePackages", "(Ljava/util/Set;)V", "namesProvider", "Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;", "getNamesProvider", "()Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;", "setNamesProvider", "(Ljetbrains/youtrack/api/workflow/WorkflowNamesConverter;)V", "predefinedRuleNames", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "calculateHashes", "", "scriptPackage", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "findExistingScriptByHash", "Ljetbrains/youtrack/scripts/persistent/XdScript;", "pkg", "scriptSource", "Ljetbrains/youtrack/scripts/loader/ScriptSource;", "findRelatedScripts", "", "getNewPackageName", "kotlin.jvm.PlatformType", "getScripts", "", "has", "", "name", "hasNewVersion", "hasWorkflowsToRestore", "isLegibleForAutoUpdate", "packageEntity", "isPredefinedScriptName", "load", "migrateFromOldWorkflow", "migrateUsages", "oldScript", "newScript", "packageProcessed", "Ljetbrains/exodus/entitystore/Entity;", "processMandatoryFieldRule", "restore", "restoreAll", "restoreByReplacing", "oldPackage", "toRespectiveOldScriptFullName", "Ljetbrains/youtrack/scripts/persistence/ScriptFullName;", "scriptFullName", "Companion", "youtrack-workflow"})
public final class PredefinedWorkflowsLoader
extends ScriptPackagesLoader
implements PredefinedScriptsAware {
    @Nullable
    private Set<String> availablePackages;
    @NotNull
    public WorkflowNamesConverter namesProvider;
    private final HashSet<String> predefinedRuleNames;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Set<String> getAvailablePackages() {
        return this.availablePackages;
    }

    public final void setAvailablePackages(@Nullable Set<String> set) {
        this.availablePackages = set;
    }

    @NotNull
    public final WorkflowNamesConverter getNamesProvider() {
        WorkflowNamesConverter workflowNamesConverter = this.namesProvider;
        if (workflowNamesConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"namesProvider");
        }
        return workflowNamesConverter;
    }

    public final void setNamesProvider(@NotNull WorkflowNamesConverter workflowNamesConverter) {
        Intrinsics.checkParameterIsNotNull((Object)workflowNamesConverter, (String)"<set-?>");
        this.namesProvider = workflowNamesConverter;
    }

    public void load() {
        super.load();
        this.processMandatoryFieldRule();
        Set set = this.availablePackages;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $receiver$iv = set2;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (XdPredefinedWorkflowDescriptor.Companion.findByName(it) != null) continue;
            XdPredefinedWorkflowDescriptor.Companion.new$default(XdPredefinedWorkflowDescriptor.Companion, it, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Iterable<ScriptSource> getScripts() {
        void $receiver$iv$iv;
        Object destination$iv$iv;
        Iterable scripts = super.getScripts();
        if (this.availablePackages == null) {
            Object object;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Iterable iterable = scripts;
            PredefinedWorkflowsLoader predefinedWorkflowsLoader = this;
            void var3_4 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ScriptSource scriptSource = (ScriptSource)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = new ScriptFullName(it.getName()).getPkg();
                object.add(string);
            }
            object = (List)destination$iv$iv;
            predefinedWorkflowsLoader.availablePackages = CollectionsKt.toSet((Iterable)((Iterable)object));
        }
        Set packagesToSkip = new LinkedHashSet();
        Iterable $receiver$iv = scripts;
        for (Object element$iv : $receiver$iv) {
            ScriptFullName scriptFullName;
            ScriptFullName oldScriptFullName;
            ScriptSource it = (ScriptSource)element$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            if (StringsKt.startsWith$default((String)string, (String)"@jetbrains/youtrack-workflow-", (boolean)false, (int)2, null)) {
                this.predefinedRuleNames.add(it.getName());
            }
            if ((oldScriptFullName = this.toRespectiveOldScriptFullName(scriptFullName = new ScriptFullName(it.getName()))) != null && packagesToSkip.contains(oldScriptFullName.getPkg())) continue;
            ScriptFullName scriptFullName2 = oldScriptFullName;
            Entity oldWorkflow = WorkflowImpl.find((String)(scriptFullName2 != null ? scriptFullName2.getPkg() : null));
            String workflowName = scriptFullName.getPkg();
            if (oldWorkflow != null) {
                if (((XdScriptPackage)XdExtensionsKt.toXd((Entity)oldWorkflow)).getAllowAutoUpdate()) continue;
                Companion.getLogger().info((Function0)new Function0<String>(workflowName, scriptFullName, oldScriptFullName){
                    final /* synthetic */ String $workflowName;
                    final /* synthetic */ ScriptFullName $scriptFullName;
                    final /* synthetic */ ScriptFullName $oldScriptFullName;

                    @NotNull
                    public final String invoke() {
                        return "Old predefined workflow package " + this.$workflowName + " is not legible for loading as script " + this.$scriptFullName + " can not overwrite " + this.$oldScriptFullName;
                    }
                    {
                        this.$workflowName = string;
                        this.$scriptFullName = scriptFullName;
                        this.$oldScriptFullName = scriptFullName2;
                        super(0);
                    }
                });
                String string2 = workflowName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workflowName");
                packagesToSkip.add(string2);
                continue;
            }
            String string3 = workflowName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"workflowName");
            XdScriptPackage newWorkflow = XdScriptPackage.Companion.find(string3);
            if (newWorkflow != null) {
                if (newWorkflow.getAllowAutoUpdate() && this.isLegibleForAutoUpdate(newWorkflow)) continue;
                Companion.getLogger().info((Function0)new Function0<String>(workflowName, scriptFullName){
                    final /* synthetic */ String $workflowName;
                    final /* synthetic */ ScriptFullName $scriptFullName;

                    @NotNull
                    public final String invoke() {
                        return "JS script package " + this.$workflowName + " is not legible for loading as script " + this.$scriptFullName + " was modified";
                    }
                    {
                        this.$workflowName = string;
                        this.$scriptFullName = scriptFullName;
                        super(0);
                    }
                });
                packagesToSkip.add(workflowName);
                continue;
            }
            if (XdPredefinedWorkflowDescriptor.Companion.findByName(workflowName) == null) continue;
            Companion.getLogger().info((Function0)new Function0<String>(workflowName){
                final /* synthetic */ String $workflowName;

                @NotNull
                public final String invoke() {
                    return "Skip package " + this.$workflowName + " as it was removed by user";
                }
                {
                    this.$workflowName = string;
                    super(0);
                }
            });
            packagesToSkip.add(workflowName);
        }
        $receiver$iv = scripts;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScriptSource it = (ScriptSource)element$iv$iv;
            boolean bl = false;
            if (!(!packagesToSkip.contains(new ScriptFullName(it.getName()).getPkg()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    protected void packageProcessed(@NotNull Entity pkg) {
        String nameWithoutPrefix;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        XdScriptPackage scriptPackage = (XdScriptPackage)XdExtensionsKt.toXd((Entity)pkg);
        String string = scriptPackage.getName();
        String string2 = nameWithoutPrefix = string != null ? StringsKt.removePrefix((String)string, (CharSequence)"@jetbrains/youtrack-workflow-") : null;
        if (scriptPackage.isNew()) {
            WorkflowNamesConverter workflowNamesConverter = this.namesProvider;
            if (workflowNamesConverter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"namesProvider");
            }
            if (workflowNamesConverter.getOldName(nameWithoutPrefix) != null) {
                this.migrateFromOldWorkflow(scriptPackage);
            } else {
                scriptPackage.setAllowAutoUpdate(true);
            }
        }
        this.calculateHashes(scriptPackage);
    }

    private final void calculateHashes(XdScriptPackage scriptPackage) {
        List rulesList = XdQueryKt.toList((XdQuery)((XdQuery)scriptPackage.getRules()));
        Iterable $receiver$iv = rulesList;
        for (Object element$iv : $receiver$iv) {
            XdScript it = (XdScript)element$iv;
            boolean bl = false;
            String script = it.getScript();
            if (script == null) {
                Companion.getLogger().error((Function0)new Function0<String>(it){
                    final /* synthetic */ XdScript $it;

                    @NotNull
                    public final String invoke() {
                        return "Script is null for rule " + this.$it.getName() + " in workflow " + this.$it.getEntity().getLink("workflow");
                    }
                    {
                        this.$it = xdScript;
                        super(0);
                    }
                });
                continue;
            }
            String hash = ScriptImpl.calculateScriptHash((String)script);
            if (!(Intrinsics.areEqual((Object)hash, (Object)it.getOriginalHash()) ^ true)) continue;
            it.setOriginalHash(hash);
        }
        int size = rulesList.size();
        if (scriptPackage.getOriginalScriptsCount() != size) {
            scriptPackage.setOriginalScriptsCount(size);
        }
    }

    private final void migrateFromOldWorkflow(XdScriptPackage scriptPackage) {
        XdScriptPackage oldPackage = null;
        Iterable $receiver$iv = XdQueryKt.toList((XdQuery)((XdQuery)scriptPackage.getRules()));
        for (Object element$iv : $receiver$iv) {
            XdScript oldScript;
            ScriptFullName oldScriptFullName;
            XdScript script = (XdScript)element$iv;
            boolean bl = false;
            ScriptFullName scriptFullName = new ScriptFullName(script.getEntity());
            if (this.toRespectiveOldScriptFullName(scriptFullName) == null) {
                continue;
            }
            if (oldPackage == null) {
                Entity entity = WorkflowImpl.find((String)oldScriptFullName.getPkg());
                Object object = oldPackage = entity != null ? (XdScriptPackage)XdExtensionsKt.toXd((Entity)entity) : null;
                if (oldPackage == null) {
                    Companion.getLogger().info((Function0)new Function0<String>(oldScriptFullName){
                        final /* synthetic */ ScriptFullName $oldScriptFullName;

                        @NotNull
                        public final String invoke() {
                            return "Package " + this.$oldScriptFullName.getPkg() + " must have been removed earlier";
                        }
                        {
                            this.$oldScriptFullName = scriptFullName;
                            super(0);
                        }
                    });
                    continue;
                }
            } else {
                XdScriptPackage xdScriptPackage = oldPackage;
                if (Intrinsics.areEqual((Object)(xdScriptPackage != null ? xdScriptPackage.getName() : null), (Object)oldScriptFullName.getPkg()) ^ true) {
                    XdScriptPackage xdScriptPackage2 = oldPackage;
                    throw (Throwable)new RuntimeException("Something went wrong: scripts from " + scriptPackage.getName() + " are mapped to " + (xdScriptPackage2 != null ? xdScriptPackage2.getName() : null) + " and " + oldScriptFullName.getPkg());
                }
            }
            Entity entity = ScriptImpl.find((ScriptFullName)oldScriptFullName);
            Object object = oldScript = entity != null ? (XdScript)XdExtensionsKt.toXd((Entity)entity) : null;
            if (oldScript == null) {
                Companion.getLogger().info((Function0)new Function0<String>(oldScriptFullName){
                    final /* synthetic */ ScriptFullName $oldScriptFullName;

                    @NotNull
                    public final String invoke() {
                        return "Script " + this.$oldScriptFullName + " must have been removed earlier";
                    }
                    {
                        this.$oldScriptFullName = scriptFullName;
                        super(0);
                    }
                });
                continue;
            }
            this.migrateUsages(oldScript, script);
        }
        scriptPackage.setAllowAutoUpdate(true);
        XdScriptPackage xdScriptPackage = oldPackage;
        if (xdScriptPackage == null) {
            return;
        }
        XdScriptPackage old = xdScriptPackage;
        scriptPackage.setAutoAttach(old.getAutoAttach());
        old.delete();
    }

    private final ScriptFullName toRespectiveOldScriptFullName(ScriptFullName scriptFullName) {
        String string = scriptFullName.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptFullName.toString()");
        String nameWithoutPrefix = StringsKt.removePrefix((String)string, (CharSequence)"@jetbrains/youtrack-workflow-");
        WorkflowNamesConverter workflowNamesConverter = this.namesProvider;
        if (workflowNamesConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"namesProvider");
        }
        String string2 = workflowNamesConverter.getOldName(nameWithoutPrefix);
        if (string2 == null) {
            return null;
        }
        String oldScriptName = string2;
        ScriptFullName sfn = new ScriptFullName("jetbrains-youtrack-" + oldScriptName);
        String string3 = sfn.getPkg();
        String string4 = sfn.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sfn.name");
        return new ScriptFullName(string3, StringsKt.replace$default((String)string4, (String)"|", (String)"/", (boolean)false, (int)4, null), false);
    }

    private final void processMandatoryFieldRule() {
        XdScript oldScript;
        ScriptFullName sfn = new ScriptFullName("jetbrains-youtrack-mandatoryField", "Don't allow to submit issue without Due Date set", false);
        Entity entity = ScriptImpl.find((ScriptFullName)sfn);
        Object object = oldScript = entity != null ? (XdScript)XdExtensionsKt.toXd((Entity)entity) : null;
        if (oldScript != null && oldScript.getWorkflow().isPredefinedUnmodified()) {
            XdScript newScript;
            ScriptFullName newSfn = new ScriptFullName("@jetbrains/youtrack-workflow-due-date", "require-due-date", true);
            Entity entity2 = ScriptImpl.find((ScriptFullName)newSfn);
            Object object2 = newScript = entity2 != null ? (XdScript)XdExtensionsKt.toXd((Entity)entity2) : null;
            if (newScript != null && (newScript.isPredefinedUnmodified() || newScript.isNew())) {
                this.migrateUsages(oldScript, newScript);
                oldScript.getWorkflow().delete();
                LegacySupportKt.flush();
            }
        }
    }

    private final void migrateUsages(XdScript oldScript, XdScript newScript) {
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScriptUsage.Companion), (Function2)((Function2)new Function2<FilteringContext, XdScriptUsage, XdSearchingNode>(oldScript){
            final /* synthetic */ XdScript $oldScript;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdScriptUsage it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((XdEntity)it.getScript(), (XdEntity)this.$oldScript);
            }
            {
                this.$oldScript = xdScript;
                super(2);
            }
        })));
        for (Object element$iv : $receiver$iv) {
            XdScriptUsage oldScriptUsage = (XdScriptUsage)((Object)element$iv);
            boolean bl = false;
            if (!XdQueryKt.isEmpty((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScriptUsage.Companion), (Function2)((Function2)new Function2<FilteringContext, XdScriptUsage, XdSearchingNode>(oldScriptUsage, newScript){
                final /* synthetic */ XdScriptUsage $oldScriptUsage;
                final /* synthetic */ XdScript $newScript$inlined;
                {
                    this.$oldScriptUsage = xdScriptUsage;
                    this.$newScript$inlined = xdScript;
                    super(2);
                }

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdScriptUsage it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return $receiver.eq((XdEntity)it.getScript(), (XdEntity)this.$newScript$inlined).and($receiver.eq((XdEntity)it.getProject(), (XdEntity)this.$oldScriptUsage.getProject()));
                }
            })))) continue;
            oldScriptUsage.setScript(newScript);
        }
    }

    private final boolean hasNewVersion(XdScriptPackage pkg) {
        return pkg.isMpsPackage() && this.getNewPackageName(pkg) != null;
    }

    public final boolean has(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Set<String> set = this.availablePackages;
        return set != null ? set.contains(name2) : false;
    }

    public final void restoreByReplacing(@NotNull XdScriptPackage oldPackage) {
        Entity newPackageEntity;
        Intrinsics.checkParameterIsNotNull((Object)oldPackage, (String)"oldPackage");
        String newPackageShortName = this.getNewPackageName(oldPackage);
        Entity entity = newPackageEntity = this.findOrCreatePackage("@jetbrains/youtrack-workflow-" + newPackageShortName, 0, oldPackage.getReadOnly(), oldPackage.getAutoAttach());
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"newPackageEntity");
        XdScriptPackage newPackage = (XdScriptPackage)XdExtensionsKt.toXd((Entity)entity);
        Iterable $receiver$iv = this.findRelatedScripts(newPackage);
        for (Object element$iv : $receiver$iv) {
            ScriptSource it = (ScriptSource)element$iv;
            boolean bl = false;
            this.processScript(it, newPackageEntity);
        }
        this.migrateFromOldWorkflow(newPackage);
        this.calculateHashes(newPackage);
    }

    private final String getNewPackageName(XdScriptPackage pkg) {
        WorkflowNamesConverter workflowNamesConverter = this.namesProvider;
        if (workflowNamesConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"namesProvider");
        }
        String string = pkg.getName();
        return workflowNamesConverter.getNewName(string != null ? StringsKt.removePrefix((String)string, (CharSequence)"jetbrains-youtrack-") : null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restore(@NotNull XdScriptPackage pkg) {
        void $receiver$iv$iv;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        pkg.setUpdated(0L);
        pkg.setUpdatedBy((XdUser)null);
        Set processedScripts = new LinkedHashSet();
        List<ScriptSource> scripts = this.findRelatedScripts(pkg);
        Iterable $receiver$iv = scripts;
        for (Object element$iv : $receiver$iv) {
            it = (ScriptSource)element$iv;
            boolean bl = false;
            XdScript existing = this.findExistingScriptByHash(pkg, (ScriptSource)it);
            XdScript xdScript = existing;
            this.processScript((ScriptSource)it, pkg.getEntity(), (Entity)(xdScript != null ? xdScript.getEntity() : null));
            String string = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            processedScripts.add(string);
        }
        $receiver$iv = XdQueryKt.toList((XdQuery)((XdQuery)pkg.getRules()));
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdScript it2 = (XdScript)element$iv$iv;
            boolean bl = false;
            if (!(!processedScripts.contains(new ScriptFullName(it2.getEntity()).toString()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (XdScript)element$iv;
            boolean bl = false;
            it.delete();
        }
        pkg.setAllowAutoUpdate(true);
        this.calculateHashes(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XdScript findExistingScriptByHash(XdScriptPackage pkg, ScriptSource scriptSource) {
        String string;
        InputStream inputStream = scriptSource.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"scriptSource.body");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
        object = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        String body = string;
        String hash = ScriptImpl.calculateScriptHash((String)body);
        return (XdScript)XdQueryKt.firstOrNull((XdQuery)((XdQuery)pkg.getRules()), (NodeBase)((NodeBase)new PropertyEqual("originalHash", (Comparable)((Object)hash))));
    }

    public final void restore(@NotNull XdScriptPackage packageEntity, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)packageEntity, (String)"packageEntity");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.has(name2)) {
            this.restore(packageEntity);
        } else if (this.hasNewVersion(packageEntity)) {
            this.restoreByReplacing(packageEntity);
        }
    }

    public final void restoreAll() {
        Set set = this.availablePackages;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $receiver$iv = set2;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            XdScriptPackage xdScriptPackage = XdScriptPackage.Companion.find(it);
            if (xdScriptPackage == null) {
                xdScriptPackage = XdScriptPackage.Companion.new((Function1)new Function1<XdScriptPackage, Unit>(it){
                    final /* synthetic */ String $it;

                    public final void invoke(@NotNull XdScriptPackage $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.setName(this.$it);
                    }
                    {
                        this.$it = string;
                        super(1);
                    }
                });
            }
            this.restore(xdScriptPackage);
        }
    }

    public final boolean hasWorkflowsToRestore() {
        boolean bl;
        block4: {
            Set set = this.availablePackages;
            Set set2 = set;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            Iterable $receiver$iv = set2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    XdScriptPackage workflow2 = XdScriptPackage.Companion.find(it);
                    boolean bl3 = workflow2 == null || !workflow2.getAllowAutoUpdate();
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isLegibleForAutoUpdate(@NotNull XdScriptPackage packageEntity) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)packageEntity, (String)"packageEntity");
        XdScriptPackage $receiver = packageEntity;
        boolean bl2 = false;
        String string = $receiver.getName();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl3 = false;
            bl = $receiver.isMpsPackage() && StringsKt.startsWith$default((String)it, (String)"jetbrains-youtrack-", (boolean)false, (int)2, null) && this.hasNewVersion($receiver) || !$receiver.isMpsPackage() && StringsKt.startsWith$default((String)it, (String)"@jetbrains/youtrack-workflow-", (boolean)false, (int)2, null) && this.has(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isPredefinedScriptName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.predefinedRuleNames.contains(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptSource> findRelatedScripts(XdScriptPackage pkg) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = super.getScripts();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScriptSource it = (ScriptSource)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)new ScriptFullName(it.getName()).getPkg(), (Object)pkg.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public PredefinedWorkflowsLoader(@NotNull String rootFolderPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootFolderPath, (String)"rootFolderPath");
        super(rootFolderPath);
        PredefinedWorkflowsLoader predefinedWorkflowsLoader = this;
        HashSet hashSet = new HashSet();
        predefinedWorkflowsLoader.predefinedRuleNames = hashSet;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/workflow/loaders/PredefinedWorkflowsLoader$Companion;", "Lmu/KLogging;", "()V", "youtrack-workflow"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

