/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.customfields.meta.Workflow;
import jetbrains.charisma.persistence.customfields.meta.WorkflowRule;
import jetbrains.charisma.persistence.customfields.meta.Workflows;
import jetbrains.charisma.persistence.customfields.meta.YCustomField;
import jetbrains.charisma.persistence.customfields.meta.YProject;
import jetbrains.charisma.persistence.customfields.meta.YProjects;
import jetbrains.charisma.persistence.customfields.meta.YType;
import jetbrains.charisma.persistence.customfields.meta.YTypeReference;
import jetbrains.charisma.persistence.customfields.meta.YWorkflowVersion;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.rest.HasPermissionSecurityConstraint;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTNotFoundException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadRequestProcessor;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.scripts.persistence.WorkflowImpl;
import jetbrains.youtrack.scripts.ydata.YDataLoader;
import jetbrains.youtrack.workflow.ObsoleteScriptUsageMethods;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.CentralManager;

@Path(value="/workflow")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class WorkflowResource
implements Resource {
    protected static Log log = LogFactory.getLog(WorkflowResource.class);

    @GET
    @Path(value="/editable")
    public Response get_Editable(@QueryParam(value="workflowName") String workflowName) {
        if (workflowName != null && workflowName.length() > 0) {
            this.checkAccess(workflowName, Operation.UPDATE, false);
        } else if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.UPDATE_PROJECT, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_READ_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
            String message = String.format("You have no permission to read workflows.", new Object[0]);
            throw new ForbiddenException(message);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/version")
    public YWorkflowVersion get_Version() {
        return new YWorkflowVersion(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName(), ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion(), ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild());
    }

    @GET
    @Path(value="/types")
    public YProjects get_Types(@QueryParam(value="projectId") String projectId) {
        HasPermissionSecurityConstraint.check((Permission)Permission.UPDATE_PROJECT, null);
        return WorkflowResource.retrieveAndTransformYProjects(projectId);
    }

    @GET
    @Path(value="/stubs")
    @Produces(value={"application/text"})
    public Response get_Stubs() {
        HasPermissionSecurityConstraint.check((Permission)Permission.UPDATE_PROJECT, null);
        try {
            return Response.ok((Object)((YDataLoader)ServiceLocator.getBean((String)"yDataLoader")).getWorkflowJsStubs()).header("Content-Disposition", (Object)"attachment; filename=\"stubs.js\"").build();
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                log.error((Object)"", t);
            }
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/model")
    @Produces(value={"application/octet-stream"})
    public InputStream get_Model(@QueryParam(value="workflowName") String workflowName) {
        Entity w2 = this.checkAccess(workflowName, Operation.READ, true);
        return PrimitiveAssociationSemantics.getBlob((Entity)AssociationSemantics.getToOne((Entity)w2, (String)"model"), (String)"content");
    }

    @GET
    @Path(value="/distributive/{fileName}")
    @Produces(value={"application/zip"})
    public Response get_DistributiveFileName(@PathParam(value="fileName") String fileName) {
        String workflowName = fileName;
        if (workflowName.endsWith(".zip")) {
            workflowName = StringUtils.substring((String)workflowName, (int)0, (int)(workflowName.length() - 4));
        }
        Entity w2 = this.checkAccess(workflowName, Operation.READ, true);
        return Response.ok((Object)PrimitiveAssociationSemantics.getBlob((Entity)AssociationSemantics.getToOne((Entity)w2, (String)"model"), (String)"content")).header("Content-Disposition", (Object)("attachment; filename=\"" + workflowName + ".zip\"")).build();
    }

    @GET
    public Workflows get() {
        IListSequence workflows = ListSequence.fromList(new ArrayList());
        final ObsoleteScriptUsageMethods methods = (ObsoleteScriptUsageMethods)ServiceLocator.getBean((String)"scriptUsageMethods");
        Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"Workflow")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Workflow")).isAccessible(Operation.READ, it) && (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"readOnly", Boolean.class, null) == false && ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Workflow")).isMpsPackage(it);
            }
        }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((List)workflows){
            final /* synthetic */ List val$workflows;
            {
                this.val$workflows = list;
            }

            public void visit(Entity it) {
                Workflow workflow2 = new Workflow((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, null), (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"readOnly", Boolean.class, null), (Long)PrimitiveAssociationSemantics.get((Entity)it, (String)"updated", null), (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"updatedBy"), (String)"login", String.class, (Object)"<no user>"));
                ISequence workflowRules = Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)it, (String)"rules")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, WorkflowRule>(){

                    public WorkflowRule select(Entity rule2) {
                        WorkflowRule workflowRule = new WorkflowRule((String)PrimitiveAssociationSemantics.get((Entity)rule2, (String)"name", String.class, null));
                        workflowRule.setProjects((List)Sequence.fromIterable(methods.getAttachedProjects(rule2)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                            public String select(Entity project2) {
                                return (String)PrimitiveAssociationSemantics.get((Entity)project2, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
                            }
                        }).toListSequence());
                        return workflowRule;
                    }
                });
                workflow2.setRules((List)Sequence.fromIterable((Iterable)workflowRules).toListSequence());
                ListSequence.fromList((List)this.val$workflows).addElement((Object)workflow2);
            }
        });
        return new Workflows((List)workflows);
    }

    @POST
    public Response post(@QueryParam(value="autoAttachNewRulesToProjectId") String autoAttachNewRulesToProjectId) {
        final ObsoleteScriptUsageMethods methods = (ObsoleteScriptUsageMethods)ServiceLocator.getBean((String)"scriptUsageMethods");
        for (DiskFileItem f : Sequence.fromIterable((Iterable)FileUploadRequestProcessor.getFileItems())) {
            Entity workflow2;
            if (log.isInfoEnabled()) {
                log.info((Object)("Uploading workflow package [" + f.getName() + "]"));
            }
            final Wrappers._T project2 = new Wrappers._T(null);
            if (autoAttachNewRulesToProjectId != null && autoAttachNewRulesToProjectId.length() > 0) {
                project2.value = ProjectImpl.findProject((String)autoAttachNewRulesToProjectId);
                if (EntityOperations.equals((Entity)((Entity)project2.value), null)) {
                    throw new RESTNotFoundException("Project is not found [" + autoAttachNewRulesToProjectId + "]");
                }
            }
            try {
                workflow2 = WorkflowImpl.update((DiskFileItem)f);
            }
            catch (SecurityException e) {
                throw new ForbiddenException(e.getMessage());
            }
            catch (IOException ex) {
                throw new BadRequestException(ex.getMessage());
            }
            if (EntityOperations.equals((Entity)((Entity)project2.value), null)) continue;
            if (!((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)project2.value), (String)"Project")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Entity)project2.value)) {
                throw new ForbiddenException("No rights to attach workflow to project [" + autoAttachNewRulesToProjectId + "]");
            }
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)workflow2, (String)"rules")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    methods.attach((Entity)project2.value, it);
                }
            });
        }
        DnqUtils.getCurrentTransientSession().flush();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/{workflowName}")
    public Response delete_WorkflowName(@PathParam(value="workflowName") String workflowName) {
        Entity w2 = this.checkAccess(workflowName, Operation.DELETE, false);
        EntityOperations.remove((Entity)w2);
        DnqUtils.getCurrentTransientSession().flush();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Entity checkAccess(String workflowName, Operation operation, boolean forReadingOrEditing) {
        Entity w2 = WorkflowImpl.find((String)workflowName);
        if (EntityOperations.equals((Entity)w2, null)) {
            throw new RESTNotFoundException("Workflow is not found [" + workflowName + "]");
        }
        if (forReadingOrEditing && ((Boolean)PrimitiveAssociationSemantics.get((Entity)w2, (String)"readOnly", Boolean.class, null)).booleanValue()) {
            throw new ForbiddenException("Workflow [" + workflowName + "] is 'read only'");
        }
        if (!((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)w2, (String)"Workflow")).isMpsPackage(w2)) {
            throw new ForbiddenException("Workflow [" + workflowName + "] can not be retrieved via this resource");
        }
        this.checkAccess(w2, operation);
        return w2;
    }

    private void checkAccess(@NotNull Entity w2, Operation operation) {
        String m = ((WorkflowImpl)DnqUtils.getPersistentClassInstance((Entity)w2, (String)"Workflow")).getAccessMessage(operation, w2);
        if (m != null) {
            throw new ForbiddenException(m);
        }
    }

    public static YProjects retrieveAndTransformYProjects(String projectId) {
        final HashMap<String, String> toReplace = new HashMap<String, String>();
        final YProjects yProjects = ((YDataLoader)ServiceLocator.getBean((String)"yDataLoader")).getYProjects(projectId);
        toReplace.put("dateTime", "instant");
        toReplace.put("text", "string");
        return new YProjects(yProjects.getBundles(), yProjects.getTypes(), (List)ListSequence.fromList((List)yProjects.getProjects()).select((_FunctionTypes._return_P1_E0)new ISelector<YProject, YProject>(){

            public YProject select(YProject it) {
                return WorkflowResource.replaceTypes(it, toReplace, yProjects.getTypes());
            }
        }).toListSequence(), WorkflowResource.replaceTypes(yProjects.getProjectDefaults(), toReplace, yProjects.getTypes()), yProjects.getGroups());
    }

    private static YProject replaceTypes(YProject yProject, final Map<String, String> mapping, final List<YType> yTypes) {
        ISequence modifiedFields = ListSequence.fromList((List)yProject.getFields()).select((_FunctionTypes._return_P1_E0)new ISelector<YCustomField, YCustomField>(){

            public YCustomField select(YCustomField it) {
                final String newName = (String)mapping.get(it.getType().getName());
                if (newName != null) {
                    YType newType = (YType)ListSequence.fromList((List)yTypes).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<YType>(){

                        public boolean accept(YType it) {
                            return newName.equals(it.getName());
                        }
                    });
                    YCustomField newField = new YCustomField(it.getName(), it.getLocalizedName(), it.getDomain(), it.getId());
                    newField.setTypeRef(new YTypeReference(newType, it.getTypeRef().getCardinality()));
                    return newField;
                }
                return it;
            }
        });
        return new YProject(yProject.getName(), (List)Sequence.fromIterable((Iterable)modifiedFields).toListSequence(), yProject.getLinks());
    }
}

