/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.ExecutorCoroutineDispatcherBase;
import kotlinx.coroutines.experimental.Job;
import kotlinx.coroutines.experimental.PoolThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/coroutines/experimental/ThreadPoolDispatcher;", "Lkotlinx/coroutines/experimental/ExecutorCoroutineDispatcherBase;", "nThreads", "", "name", "", "job", "Lkotlinx/coroutines/experimental/Job;", "(ILjava/lang/String;Lkotlinx/coroutines/experimental/Job;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "threadNo", "Ljava/util/concurrent/atomic/AtomicInteger;", "toString", "kotlinx-coroutines-core"})
public final class ThreadPoolDispatcher
extends ExecutorCoroutineDispatcherBase {
    private final AtomicInteger threadNo;
    @NotNull
    private final ScheduledExecutorService executor;
    private final int nThreads;
    private final String name;

    @Override
    @NotNull
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @NotNull
    public String toString() {
        return "ThreadPoolDispatcher[" + this.nThreads + ", " + this.name + ']';
    }

    public ThreadPoolDispatcher(int nThreads, @NotNull String name, @NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        this.nThreads = nThreads;
        this.name = name;
        this.threadNo = new AtomicInteger();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(this.nThreads, new ThreadFactory(this){
            final /* synthetic */ ThreadPoolDispatcher this$0;

            @NotNull
            public final PoolThread newThread(Runnable target) {
                Runnable runnable = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"target");
                return new PoolThread(this.this$0, runnable, ThreadPoolDispatcher.access$getNThreads$p(this.this$0) == 1 ? ThreadPoolDispatcher.access$getName$p(this.this$0) : ThreadPoolDispatcher.access$getName$p(this.this$0) + "-" + ThreadPoolDispatcher.access$getThreadNo$p(this.this$0).incrementAndGet());
            }
            {
                this.this$0 = threadPoolDispatcher;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledTh\u2026.incrementAndGet())\n    }");
        this.executor = scheduledExecutorService;
        Job.DefaultImpls.invokeOnCompletion$default(job, false, (Function1)new Function1<Throwable, Unit>(){

            public final void invoke(@Nullable Throwable it) {
                this.getExecutor().shutdown();
            }
        }, 1, null);
    }

    public static final /* synthetic */ int access$getNThreads$p(ThreadPoolDispatcher $this) {
        return $this.nThreads;
    }

    @NotNull
    public static final /* synthetic */ String access$getName$p(ThreadPoolDispatcher $this) {
        return $this.name;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getThreadNo$p(ThreadPoolDispatcher $this) {
        return $this.threadNo;
    }
}

