/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.decorators.HashMapDecorator;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TemporaryEmptyStore;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.TreeMetaInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadWriteTransaction
extends TransactionBase {
    @NotNull
    private final Map<Integer, ITreeMutable> mutableTrees = new TreeMap<Integer, ITreeMutable>();
    @NotNull
    private final LongHashMap<Pair<String, ITree>> removedStores = new LongHashMap();
    @NotNull
    private final Map<String, TreeMetaInfo> createdStores = new HashMapDecorator();
    @Nullable
    private final Runnable beginHook;
    @Nullable
    private Runnable commitHook;
    private int replayCount;

    ReadWriteTransaction(final @NotNull EnvironmentImpl env, final @Nullable Runnable beginHook, boolean isExclusive, final boolean cloneMeta) {
        super(env, isExclusive);
        this.beginHook = new Runnable(){

            @Override
            public void run() {
                MetaTreeImpl currentMetaTree = env.getMetaTreeInternal();
                ReadWriteTransaction.this.setMetaTree(cloneMeta ? currentMetaTree.getClone() : currentMetaTree);
                env.registerTransaction(ReadWriteTransaction.this);
                if (beginHook != null) {
                    beginHook.run();
                }
            }
        };
        this.replayCount = 0;
        this.setExclusive(this.isExclusive() | env.shouldTransactionBeExclusive(this));
        env.holdNewestSnapshotBy(this);
        env.getStatistics().getStatisticsItem(EnvironmentStatistics.Type.TRANSACTIONS).incTotal();
    }

    ReadWriteTransaction(@NotNull TransactionBase origin, @Nullable Runnable beginHook) {
        super(origin.getEnvironment(), false);
        EnvironmentImpl env = this.getEnvironment();
        this.beginHook = this.getWrappedBeginHook(beginHook);
        this.replayCount = 0;
        this.setMetaTree(origin.getMetaTree());
        this.setExclusive(env.shouldTransactionBeExclusive(this));
        env.acquireTransaction(this);
        env.registerTransaction(this);
        env.getStatistics().getStatisticsItem(EnvironmentStatistics.Type.TRANSACTIONS).incTotal();
    }

    public boolean isIdempotent() {
        return this.mutableTrees.isEmpty() && this.removedStores.isEmpty() && this.createdStores.isEmpty();
    }

    public void abort() {
        this.checkIsFinished();
        this.clearImmutableTrees();
        this.doRevert();
        this.getEnvironment().finishTransaction(this);
    }

    public boolean commit() {
        this.checkIsFinished();
        return this.getEnvironment().commitTransaction(this, false);
    }

    public boolean flush() {
        this.checkIsFinished();
        EnvironmentImpl env = this.getEnvironment();
        boolean result = env.flushTransaction(this, false);
        if (result) {
            if (!this.wasCreatedExclusive() && this.isExclusive() && env.getEnvironmentConfig().getEnvTxnDowngradeAfterFlush()) {
                env.downgradeTransaction(this);
                this.setExclusive(false);
            }
            this.setStarted(System.currentTimeMillis());
        } else {
            this.incReplayCount();
        }
        return result;
    }

    public void revert() {
        this.checkIsFinished();
        if (this.isReadonly()) {
            throw new ExodusException("Attempt ot revert read-only transaction");
        }
        long oldRoot = this.getMetaTree().root;
        boolean wasExclusive = this.isExclusive();
        EnvironmentImpl env = this.getEnvironment();
        if (this.isIdempotent()) {
            env.holdNewestSnapshotBy(this, false);
        } else {
            this.doRevert();
            if (wasExclusive || !env.shouldTransactionBeExclusive(this)) {
                env.holdNewestSnapshotBy(this, false);
            } else {
                env.releaseTransaction(this);
                this.setExclusive(true);
                env.holdNewestSnapshotBy(this);
            }
        }
        if (!env.isRegistered(this)) {
            throw new ExodusException("Transaction should remain registered after revert");
        }
        if (!this.checkVersion(oldRoot)) {
            this.clearImmutableTrees();
            env.runTransactionSafeTasks();
        }
        this.setStarted(System.currentTimeMillis());
    }

    public void setCommitHook(@Nullable Runnable hook) {
        this.commitHook = hook;
    }

    public boolean isReadonly() {
        return false;
    }

    public boolean forceFlush() {
        this.checkIsFinished();
        return this.getEnvironment().flushTransaction(this, true);
    }

    @NotNull
    public StoreImpl openStoreByStructureId(int structureId) {
        this.checkIsFinished();
        EnvironmentImpl env = this.getEnvironment();
        String storeName = this.getMetaTree().getStoreNameByStructureId(structureId, env);
        return storeName == null ? new TemporaryEmptyStore(env) : env.openStoreImpl(storeName, StoreConfig.USE_EXISTING, this, this.getTreeMetaInfo(storeName));
    }

    @Override
    @NotNull
    public ITree getTree(@NotNull StoreImpl store) {
        this.checkIsFinished();
        ITreeMutable result = this.mutableTrees.get(store.getStructureId());
        if (result == null) {
            return super.getTree(store);
        }
        return result;
    }

    @Override
    @Nullable
    TreeMetaInfo getTreeMetaInfo(@NotNull String name) {
        this.checkIsFinished();
        TreeMetaInfo result = this.createdStores.get(name);
        return result == null ? super.getTreeMetaInfo(name) : result;
    }

    @Override
    void storeRemoved(@NotNull StoreImpl store) {
        this.checkIsFinished();
        super.storeRemoved(store);
        int structureId = store.getStructureId();
        ITree tree = store.openImmutableTree(this.getMetaTree());
        this.removedStores.put((long)structureId, (Object)new Pair((Object)store.getName(), (Object)tree));
        this.mutableTrees.remove(structureId);
    }

    void storeCreated(@NotNull StoreImpl store) {
        this.getMutableTree(store);
        this.createdStores.put(store.getName(), store.getMetaInfo());
    }

    int getReplayCount() {
        return this.replayCount;
    }

    void incReplayCount() {
        ++this.replayCount;
    }

    boolean isStoreNew(@NotNull String name) {
        return this.createdStores.containsKey(name);
    }

    Iterable<ExpiredLoggableInfo>[] doCommit(@NotNull MetaTreeImpl.Proto[] out) {
        Collection<ExpiredLoggableInfo> last;
        Set<Map.Entry<Integer, ITreeMutable>> entries = this.mutableTrees.entrySet();
        Set removedEntries = this.removedStores.entrySet();
        int size = entries.size() + removedEntries.size();
        Iterable[] expiredLoggables = new Iterable[size + 1];
        int i2 = 0;
        ITreeMutable metaTreeMutable = this.getMetaTree().tree.getMutableCopy();
        for (Map.Entry entry : removedEntries) {
            Pair value = (Pair)entry.getValue();
            MetaTreeImpl.removeStore(metaTreeMutable, (String)value.getFirst(), (Long)entry.getKey());
            expiredLoggables[i2++] = TreeMetaInfo.getTreeLoggables((ITree)value.getSecond());
        }
        this.removedStores.clear();
        for (Map.Entry entry : this.createdStores.entrySet()) {
            MetaTreeImpl.addStore(metaTreeMutable, (String)entry.getKey(), (TreeMetaInfo)entry.getValue());
        }
        this.createdStores.clear();
        for (Map.Entry<Integer, ITreeMutable> entry : entries) {
            ITreeMutable treeMutable = entry.getValue();
            expiredLoggables[i2++] = treeMutable.getExpiredLoggables();
            MetaTreeImpl.saveTree(metaTreeMutable, treeMutable);
        }
        this.clearImmutableTrees();
        this.mutableTrees.clear();
        expiredLoggables[i2] = last = metaTreeMutable.getExpiredLoggables();
        out[0] = MetaTreeImpl.saveMetaTree(metaTreeMutable, this.getEnvironment(), last);
        return expiredLoggables;
    }

    void executeCommitHook() {
        if (this.commitHook != null) {
            this.commitHook.run();
        }
    }

    @NotNull
    ITreeMutable getMutableTree(@NotNull StoreImpl store) {
        Thread creatingThread;
        this.checkIsFinished();
        if (this.getEnvironment().getEnvironmentConfig().getEnvTxnSingleThreadWrites() && !(creatingThread = this.getCreatingThread()).equals(Thread.currentThread())) {
            throw new ExodusException("Can't create mutable tree in a thread different from the one which transaction was created in");
        }
        int structureId = store.getStructureId();
        ITreeMutable result = this.mutableTrees.get(structureId);
        if (result == null) {
            result = this.getTree(store).getMutableCopy();
            this.mutableTrees.put(structureId, result);
        }
        return result;
    }

    boolean hasTreeMutable(@NotNull StoreImpl store) {
        return this.mutableTrees.containsKey(store.getStructureId());
    }

    void removeTreeMutable(@NotNull StoreImpl store) {
        this.mutableTrees.remove(store.getStructureId());
    }

    @Override
    @NotNull
    List<String> getAllStoreNames() {
        List<String> result = super.getAllStoreNames();
        if (this.createdStores.isEmpty()) {
            return result;
        }
        if (result.isEmpty()) {
            result = new ArrayList<String>();
        }
        result.addAll(this.createdStores.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    @Nullable
    Runnable getBeginHook() {
        return this.beginHook;
    }

    private void doRevert() {
        this.mutableTrees.clear();
        this.removedStores.clear();
        this.createdStores.clear();
    }
}

