/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.Loggable;
import org.jetbrains.annotations.NotNull;

public class ExpiredLoggableInfo {
    private static final boolean EXPIRED_LOGGABLE_CHECK_OFF = Boolean.getBoolean("jetbrains.exodus.log.expiredLoggableCheckOff");
    public final long address;
    public final int length;

    public ExpiredLoggableInfo(@NotNull Loggable loggable) {
        this.address = ExpiredLoggableInfo.checkAddressNonNegative(loggable.getAddress());
        this.length = ExpiredLoggableInfo.assertPositiveLength(loggable.length());
    }

    public ExpiredLoggableInfo(long address, int length) {
        this.address = ExpiredLoggableInfo.checkAddressNonNegative(address);
        this.length = ExpiredLoggableInfo.assertPositiveLength(length);
    }

    private static int assertPositiveLength(int length) {
        if (!EXPIRED_LOGGABLE_CHECK_OFF && length < 1) {
            throw new ExodusException("Expired loggable length is negative or nil: " + length);
        }
        return length;
    }

    private static long checkAddressNonNegative(long address) {
        if (!EXPIRED_LOGGABLE_CHECK_OFF && address < 0L) {
            throw new ExodusException("Expired loggable address is negative: " + address);
        }
        return address;
    }
}

