/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageImmutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BasePageMutable
extends BasePage
implements MutableTreeRoot {
    protected BaseLeafNodeMutable[] keys;
    protected long[] keysAddresses;

    protected BasePageMutable(BTreeMutable tree) {
        super(tree);
    }

    protected BasePageMutable(BTreeMutable tree, BasePageImmutable page) {
        super(tree);
        this.size = page.size;
        BTreeBalancePolicy bp = this.getBalancePolicy();
        this.createChildren(Math.max(page.size, tree.isDup() ? bp.getDupPageMaxSize() : bp.getPageMaxSize()));
        if (this.size > 0) {
            this.load(page.getDataIterator(), page.keyAddressLen);
        }
    }

    protected void load(ByteIterator it, int keyAddressLen) {
        CompressedUnsignedLongArrayByteIterable.loadLongs((long[])this.keysAddresses, (ByteIterator)it, (int)this.size, (int)keyAddressLen);
    }

    @Override
    @NotNull
    protected BasePageMutable getMutableCopy(BTreeMutable treeMutable) {
        return this;
    }

    @Override
    protected long getDataAddress() {
        return -1L;
    }

    protected void createChildren(int max) {
        this.keys = new BaseLeafNodeMutable[max];
        this.keysAddresses = new long[max];
    }

    protected abstract boolean delete(@NotNull ByteIterable var1, @Nullable ByteIterable var2);

    protected abstract BasePageMutable put(@NotNull ByteIterable var1, @NotNull ByteIterable var2, boolean var3, boolean[] var4);

    public abstract BasePageMutable putRight(@NotNull ByteIterable var1, @NotNull ByteIterable var2);

    protected ByteIterable getData() {
        return new CompoundByteIterable(this.getByteIterables(this.saveChildren()));
    }

    @NotNull
    protected abstract ReclaimFlag saveChildren();

    protected abstract ByteIterable[] getByteIterables(ReclaimFlag var1);

    protected long save() {
        ReclaimFlag flag = this.saveChildren();
        byte type = this.getType();
        BTreeBase tree = this.getTree();
        int structureId = tree.structureId;
        Log log = tree.log;
        if (flag == ReclaimFlag.PRESERVE) {
            if (log.getWrittenHighAddress() % log.getFileLengthBound() == 0L) {
                flag = ReclaimFlag.RECLAIM;
            } else {
                ByteIterable[] iterables = this.getByteIterables(flag);
                long result = log.tryWrite(type, structureId, (ByteIterable)new CompoundByteIterable(iterables));
                if (result < 0L) {
                    iterables[0] = CompressedUnsignedLongByteIterable.getIterable((this.size << 1) + ReclaimFlag.RECLAIM.value);
                    result = log.writeContinuously(type, structureId, (ByteIterable)new CompoundByteIterable(iterables));
                    if (result < 0L) {
                        throw new TooBigLoggableException();
                    }
                }
                return result;
            }
        }
        return log.write(type, structureId, (ByteIterable)new CompoundByteIterable(this.getByteIterables(flag)));
    }

    protected abstract byte getType();

    @Override
    protected long getKeyAddress(int index) {
        return this.keysAddresses[index];
    }

    @Override
    @NotNull
    public BaseLeafNode getKey(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.size);
        }
        return this.keys[index] == null ? this.getTree().loadLeaf(this.keysAddresses[index]) : this.keys[index];
    }

    protected abstract void setMutableChild(int var1, @NotNull BasePageMutable var2);

    protected BTreeBalancePolicy getBalancePolicy() {
        return this.getTree().getBalancePolicy();
    }

    @Override
    protected boolean isMutable() {
        return true;
    }

    @Nullable
    protected BasePageMutable insertAt(int pos, @NotNull ILeafNode key, @Nullable BasePageMutable child) {
        if (!this.getBalancePolicy().needSplit(this)) {
            this.insertDirectly(pos, key, child);
            return null;
        }
        int splitPos = this.getBalancePolicy().getSplitPos(this, pos);
        BasePageMutable sibling = this.split(splitPos, this.size - splitPos);
        if (pos >= splitPos) {
            sibling.insertDirectly(pos - splitPos, key, child);
        } else {
            this.insertDirectly(pos, key, child);
        }
        return sibling;
    }

    protected void set(int pos, @NotNull ILeafNode key, @Nullable BasePageMutable child) {
        this.keys[pos] = key instanceof BaseLeafNodeMutable ? (BaseLeafNodeMutable)key : null;
        this.keysAddresses[pos] = key.getAddress();
    }

    protected void insertDirectly(int pos, @NotNull ILeafNode key, @Nullable BasePageMutable child) {
        if (pos < this.size) {
            this.copyChildren(pos, pos + 1);
        }
        ++this.size;
        this.set(pos, key, child);
    }

    protected void copyChildren(int from, int to) {
        if (from >= this.size) {
            return;
        }
        System.arraycopy(this.keys, from, this.keys, to, this.size - from);
        System.arraycopy(this.keysAddresses, from, this.keysAddresses, to, this.size - from);
    }

    @Override
    protected int binarySearch(ByteIterable key) {
        return this.binarySearch(key, 0);
    }

    @Override
    protected int binarySearch(ByteIterable key, int low) {
        return BasePageMutable.binarySearch(this, key, low, this.getSize() - 1);
    }

    protected void decrementSize(int value) {
        if (this.size < value) {
            throw new ExodusException("Can't decrease BTree page size " + this.size + " on " + value);
        }
        int initialSize = this.size;
        this.size -= value;
        for (int i2 = this.size; i2 < initialSize; ++i2) {
            this.keys[i2] = null;
            this.keysAddresses[i2] = 0L;
        }
    }

    protected abstract BasePageMutable split(int var1, int var2);

    protected abstract BasePageMutable mergeWithChildren();

    protected abstract void mergeWithRight(BasePageMutable var1);

    protected abstract void mergeWithLeft(BasePageMutable var1);

    protected static int binarySearch(@NotNull BasePage page, @NotNull ByteIterable key, int low, int high) {
        while (low <= high) {
            int mid = low + high + 1 >>> 1;
            BaseLeafNode midKey = page.getKey(mid);
            int cmp = midKey.compareKeyTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected static enum ReclaimFlag {
        PRESERVE(0),
        RECLAIM(1);

        final int value;

        private ReclaimFlag(int value) {
            this.value = value;
        }
    }
}

