/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.ExpiredLoggableInfo;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeCursorMutable;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.TreeCursorMutable;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceTransient;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.MutableNodeSaveContext;
import jetbrains.exodus.tree.patricia.MutableRoot;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaReclaimActualTraverser;
import jetbrains.exodus.tree.patricia.PatriciaReclaimSourceTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeForReclaim;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PatriciaTreeMutable
extends PatriciaTreeBase
implements ITreeMutable {
    private MutableRoot root;
    @Nullable
    private Collection<ExpiredLoggableInfo> expiredLoggables;
    private Set<ITreeCursorMutable> openCursors = null;

    PatriciaTreeMutable(@NotNull Log log, int structureId, long treeSize, @NotNull ImmutableNode immutableRoot) {
        super(log, structureId);
        this.size = treeSize;
        this.root = new MutableRoot(immutableRoot);
        this.expiredLoggables = null;
        this.addExpiredLoggable(immutableRoot.getLoggable());
    }

    @Override
    public long getRootAddress() {
        return -1L;
    }

    @Override
    @NotNull
    public PatriciaTreeMutable getMutableCopy() {
        return this;
    }

    @Override
    public boolean put(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ByteIterator it = key.iterator();
        MutableNode node = this.root;
        MutableRoot prev = null;
        byte prevFirstByte = 0;
        while (true) {
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                MutableNode prefix = node.splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                if (NodeBase.MatchResult.hasNext(matchResult)) {
                    prefix.hang(NodeBase.MatchResult.getNextByte(matchResult), it).setValue(value);
                } else {
                    prefix.setValue(value);
                }
                if (prev == null) {
                    this.root = new MutableRoot(prefix, this.root.sourceAddress);
                } else {
                    prev.setChild(prevFirstByte, prefix);
                }
                ++this.size;
                return true;
            }
            if (!it.hasNext()) {
                ByteIterable oldValue = node.getValue();
                node.setValue(value);
                if (oldValue == null) {
                    ++this.size;
                    return true;
                }
                return !oldValue.equals(value);
            }
            byte nextByte = it.next();
            NodeBase child = node.getChild(this, nextByte);
            if (child == null) {
                if (node.hasChildren() || node.hasKey() || node.hasValue()) {
                    node.hang(nextByte, it).setValue(value);
                } else {
                    node.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                    node.setValue(value);
                }
                ++this.size;
                return true;
            }
            prev = node;
            prevFirstByte = nextByte;
            MutableNode mutableChild = child.getMutableCopy(this);
            if (!child.isMutable()) {
                node.setChild(nextByte, mutableChild);
            }
            node = mutableChild;
        }
    }

    @Override
    public void putRight(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ByteIterator it = key.iterator();
        MutableNode node = this.root;
        MutableRoot prev = null;
        byte prevFirstByte = 0;
        while (true) {
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                if (!NodeBase.MatchResult.hasNext(matchResult)) {
                    throw new IllegalArgumentException();
                }
                MutableNode prefix = node.splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                prefix.hangRight(NodeBase.MatchResult.getNextByte(matchResult), it).setValue(value);
                if (prev == null) {
                    this.root = new MutableRoot(prefix, this.root.sourceAddress);
                } else {
                    prev.setChild(prevFirstByte, prefix);
                }
                ++this.size;
                break;
            }
            if (!it.hasNext()) {
                if (node.hasChildren() || node.hasValue()) {
                    throw new IllegalArgumentException();
                }
                node.setValue(value);
                ++this.size;
                break;
            }
            byte nextByte = it.next();
            NodeBase child = node.getRightChild(this, nextByte);
            if (child == null) {
                if (node.hasChildren() || node.hasKey() || node.hasValue()) {
                    node.hangRight(nextByte, it).setValue(value);
                } else {
                    node.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                    node.setValue(value);
                }
                ++this.size;
                break;
            }
            prev = node;
            prevFirstByte = nextByte;
            MutableNode mutableChild = child.getMutableCopy(this);
            if (!child.isMutable()) {
                node.setRightChild(nextByte, mutableChild);
            }
            node = mutableChild;
        }
    }

    @Override
    public boolean add(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ByteIterator it = key.iterator();
        NodeBase node = this.root;
        MutableNode mutableNode = null;
        ArrayDeque<ChildReferenceTransient> stack = new ArrayDeque<ChildReferenceTransient>();
        while (true) {
            long matchResult;
            int matchingLength;
            if ((matchingLength = NodeBase.MatchResult.getMatchingLength(matchResult = node.matchesKeySequence(it))) < 0) {
                MutableNode prefix = ((NodeBase)node).getMutableCopy(this).splitKey(-matchingLength - 1, NodeBase.MatchResult.getKeyByte(matchResult));
                if (NodeBase.MatchResult.hasNext(matchResult)) {
                    prefix.hang(NodeBase.MatchResult.getNextByte(matchResult), it).setValue(value);
                } else {
                    prefix.setValue(value);
                }
                if (stack.isEmpty()) {
                    this.root = new MutableRoot(prefix, this.root.sourceAddress);
                    break;
                }
                ChildReferenceTransient parent = (ChildReferenceTransient)stack.pop();
                mutableNode = parent.mutate(this);
                mutableNode.setChild(parent.firstByte, prefix);
                break;
            }
            if (!it.hasNext()) {
                if (node.hasValue()) {
                    return false;
                }
                mutableNode = ((NodeBase)node).getMutableCopy(this);
                mutableNode.setValue(value);
                break;
            }
            byte nextByte = it.next();
            NodeBase child = ((NodeBase)node).getChild(this, nextByte);
            if (child == null) {
                mutableNode = ((NodeBase)node).getMutableCopy(this);
                if (mutableNode.hasChildren() || mutableNode.hasKey() || mutableNode.hasValue()) {
                    mutableNode.hang(nextByte, it).setValue(value);
                    break;
                }
                mutableNode.setKeySequence((ByteIterable)new ArrayByteIterable(nextByte, it));
                mutableNode.setValue(value);
                break;
            }
            stack.push(new ChildReferenceTransient(nextByte, node));
            node = child;
        }
        ++this.size;
        this.mutateUp(stack, mutableNode);
        return true;
    }

    @Override
    public boolean delete(@NotNull ByteIterable key) {
        return this.deleteImpl(key);
    }

    @Override
    public boolean delete(@NotNull ByteIterable key, @Nullable ByteIterable value, @Nullable ITreeCursorMutable cursorToSkip) {
        if (value == null) {
            if (this.deleteImpl(key)) {
                TreeCursorMutable.notifyCursors(this, cursorToSkip);
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException("Patricia tree doesn't support duplicates!");
    }

    @Override
    public void put(@NotNull INode ln) {
        this.put(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public void putRight(@NotNull INode ln) {
        this.putRight(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public boolean add(@NotNull INode ln) {
        return this.add(ln.getKey(), PatriciaTreeMutable.getNotNullValue(ln));
    }

    @Override
    public long save() {
        return this.root.save(this, new MutableNodeSaveContext(CompressedUnsignedLongByteIterable.getIterable(this.size)));
    }

    @Override
    @NotNull
    public Collection<ExpiredLoggableInfo> getExpiredLoggables() {
        Collection<ExpiredLoggableInfo> expiredLoggables = this.expiredLoggables;
        return expiredLoggables == null ? Collections.emptyList() : expiredLoggables;
    }

    @Override
    public ITreeCursor openCursor() {
        if (this.openCursors == null) {
            this.openCursors = new HashSet();
        }
        TreeCursorMutable result = new TreeCursorMutable(this, new PatriciaTraverser(this, this.root), this.root.hasValue());
        this.openCursors.add(result);
        return result;
    }

    @Override
    public void cursorClosed(@NotNull ITreeCursorMutable cursor) {
        this.openCursors.remove(cursor);
    }

    @Override
    public boolean reclaim(@NotNull RandomAccessLoggable loggable, @NotNull Iterator<RandomAccessLoggable> loggables) {
        long minAddress = loggable.getAddress();
        while (true) {
            byte type;
            if ((type = loggable.getType()) < 12 || type > 43) {
                if (type != 0) {
                    throw new ExodusException("Unexpected loggable type " + loggable.getType());
                }
            } else {
                if (loggable.getStructureId() != this.structureId) {
                    throw new ExodusException("Unexpected structure id " + loggable.getStructureId());
                }
                if (PatriciaTreeBase.nodeIsRoot(type)) break;
            }
            if (!loggables.hasNext()) {
                return false;
            }
            loggable = loggables.next();
        }
        long maxAddress = loggable.getAddress();
        PatriciaTreeForReclaim sourceTree = new PatriciaTreeForReclaim(this.log, maxAddress, this.structureId);
        ImmutableNode sourceRoot = sourceTree.getRoot();
        long backRef = sourceTree.getBackRef();
        if (backRef > 0L) {
            long treeStartAddress = sourceTree.getRootAddress() - backRef;
            if (treeStartAddress > minAddress) {
                throw new IllegalStateException("Wrong back reference!");
            }
            if (!this.log.hasAddressRange(treeStartAddress, maxAddress)) {
                return false;
            }
            minAddress = treeStartAddress;
        }
        PatriciaReclaimActualTraverser actual = new PatriciaReclaimActualTraverser(this);
        PatriciaTreeMutable.reclaim(new PatriciaReclaimSourceTraverser(sourceTree, sourceRoot, minAddress), actual);
        return actual.wasReclaim || sourceRoot.getAddress() == this.root.sourceAddress;
    }

    @Override
    public MutableRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isAllowingDuplicates() {
        return false;
    }

    @Override
    @Nullable
    public Iterable<ITreeCursorMutable> getOpenCursors() {
        return this.openCursors;
    }

    MutableNode mutateNode(@NotNull ImmutableNode node) {
        this.addExpiredLoggable(node.getLoggable());
        return new MutableNode(node);
    }

    static ByteIterable getNotNullValue(@NotNull INode ln) {
        ByteIterable value = ln.getValue();
        if (value == null) {
            throw new ExodusException("Value can't be null");
        }
        return value;
    }

    private void addExpiredLoggable(@Nullable RandomAccessLoggable sourceLoggable) {
        if (sourceLoggable != null && sourceLoggable.getAddress() != -1L) {
            Collection<ExpiredLoggableInfo> expiredLoggables = this.expiredLoggables;
            if (expiredLoggables == null) {
                this.expiredLoggables = expiredLoggables = new ArrayList<ExpiredLoggableInfo>(16);
            }
            expiredLoggables.add(new ExpiredLoggableInfo(sourceLoggable));
        }
    }

    private boolean deleteImpl(@NotNull ByteIterable key) {
        ByteIterator it = key.iterator();
        NodeBase node = this.root;
        ArrayDeque<ChildReferenceTransient> stack = new ArrayDeque<ChildReferenceTransient>();
        while (true) {
            if (node == null || NodeBase.MatchResult.getMatchingLength(node.matchesKeySequence(it)) < 0) {
                return false;
            }
            if (!it.hasNext()) break;
            byte nextByte = it.next();
            stack.push(new ChildReferenceTransient(nextByte, node));
            node = ((NodeBase)node).getChild(this, nextByte);
        }
        if (!node.hasValue()) {
            return false;
        }
        --this.size;
        MutableNode mutableNode = ((NodeBase)node).getMutableCopy(this);
        ChildReferenceTransient parent = (ChildReferenceTransient)stack.peek();
        boolean hasChildren = mutableNode.hasChildren();
        if (!hasChildren && parent != null) {
            stack.pop();
            mutableNode = parent.mutate(this);
            mutableNode.removeChild(parent.firstByte);
            if (!mutableNode.hasValue() && mutableNode.getChildrenCount() == 1) {
                mutableNode.mergeWithSingleChild(this);
            }
        } else {
            mutableNode.setValue(null);
            if (!hasChildren) {
                mutableNode.setKeySequence(ByteIterable.EMPTY);
            } else if (mutableNode.getChildrenCount() == 1) {
                mutableNode.mergeWithSingleChild(this);
            }
        }
        this.mutateUp(stack, mutableNode);
        return true;
    }

    private void mutateUp(@NotNull Deque<ChildReferenceTransient> stack, MutableNode node) {
        while (!stack.isEmpty()) {
            ChildReferenceTransient parent = stack.pop();
            MutableNode mutableParent = parent.mutate(this);
            mutableParent.setChild(parent.firstByte, node);
            node = mutableParent;
        }
    }

    private static void reclaim(@NotNull PatriciaReclaimSourceTraverser source, @NotNull PatriciaReclaimActualTraverser actual) {
        NodeBase actualNode = actual.currentNode;
        NodeBase sourceNode = source.currentNode;
        if (actualNode.getAddress() == sourceNode.getAddress()) {
            actual.currentNode = actualNode.getMutableCopy(actual.mainTree);
            actual.getItr();
            actual.wasReclaim = true;
            PatriciaTreeMutable.reclaimActualChildren(source, actual);
        } else {
            int i2;
            int actPushes;
            int srcPushes;
            block11: {
                ByteIterator srcItr = sourceNode.keySequence.iterator();
                ByteIterator actItr = actualNode.keySequence.iterator();
                srcPushes = 0;
                actPushes = 0;
                while (true) {
                    ChildReference child;
                    NodeChildrenIterator children;
                    if (srcItr.hasNext()) {
                        if (actItr.hasNext()) {
                            if (srcItr.next() == actItr.next()) continue;
                        } else {
                            children = actual.currentNode.getChildren(srcItr.next());
                            child = children.getNode();
                            if (child != null) {
                                actual.currentChild = child;
                                actual.currentIterator = children;
                                actual.moveDown();
                                ++actPushes;
                                actItr = actual.currentNode.keySequence.iterator();
                                continue;
                            }
                        }
                    } else {
                        if (!actItr.hasNext()) break;
                        children = source.currentNode.getChildren(actItr.next());
                        child = children.getNode();
                        if (child != null && source.isAddressReclaimable(child.suffixAddress)) {
                            source.currentChild = child;
                            source.currentIterator = children;
                            source.moveDown();
                            ++srcPushes;
                            srcItr = source.currentNode.keySequence.iterator();
                            continue;
                        }
                    }
                    break block11;
                    break;
                }
                PatriciaTreeMutable.reclaimChildren(source, actual);
            }
            for (i2 = 0; i2 < srcPushes; ++i2) {
                source.moveUp();
            }
            for (i2 = 0; i2 < actPushes; ++i2) {
                actual.popAndMutate();
            }
        }
    }

    private static void reclaimActualChildren(@NotNull PatriciaReclaimSourceTraverser source, @NotNull PatriciaReclaimActualTraverser actual) {
        while (actual.isValidPos()) {
            ChildReference actualChild = actual.currentChild;
            long suffixAddress = actualChild.suffixAddress;
            if (source.isAddressReclaimable(suffixAddress)) {
                actual.moveDown();
                actual.currentNode = actual.currentNode.getMutableCopy(actual.mainTree);
                actual.getItr();
                actual.wasReclaim = true;
                PatriciaTreeMutable.reclaimActualChildren(source, actual);
                actual.popAndMutate();
            }
            actual.moveRight();
        }
    }

    private static void reclaimChildren(@NotNull PatriciaReclaimSourceTraverser source, @NotNull PatriciaReclaimActualTraverser actual) {
        source.moveToNextReclaimable();
        while (source.isValidPos() && actual.isValidPos()) {
            ChildReference sourceChild = source.currentChild;
            int sourceByte = sourceChild.firstByte & 0xFF;
            int actualByte = actual.currentChild.firstByte & 0xFF;
            if (sourceByte < actualByte) {
                source.moveRight();
                continue;
            }
            if (sourceByte > actualByte) {
                actual.moveRight();
                continue;
            }
            source.moveDown();
            actual.moveDown();
            PatriciaTreeMutable.reclaim(source, actual);
            actual.popAndMutate();
            source.moveUp();
            source.moveRight();
            actual.moveRight();
        }
    }
}

